/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.core.expression.VariableUtils;
import io.github.linuxforhealth.hl7.data.SimpleDataTypeMapper;
import io.github.linuxforhealth.hl7.data.ValueExtractor;
import io.github.linuxforhealth.hl7.expression.AbstractExpression;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimpleExpression
extends AbstractExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleExpression.class);
    private String value;

    @JsonCreator
    public SimpleExpression(ExpressionAttributes expAttr) {
        super(expAttr);
        this.value = expAttr.getValue();
        if (StringUtils.isBlank((CharSequence)this.value)) {
            this.value = expAttr.getValueOf();
        }
    }

    @Override
    public EvaluationResult evaluateExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseValue) {
        Preconditions.checkArgument((contextValues != null ? 1 : 0) != 0, (Object)"contextValues cannot be null");
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
        if (baseValue != null && !baseValue.isEmpty()) {
            localContextValues.put(baseValue.getIdentifier(), baseValue);
            localContextValues.put("BASE_VALUE", baseValue);
        }
        String resolvedValue = null;
        if (VariableUtils.isVar(this.value)) {
            EvaluationResult obj = SimpleExpression.getVariableValueFromVariableContextMap(this.value, (ImmutableMap<String, EvaluationResult>)ImmutableMap.copyOf(localContextValues));
            if (obj != null && !obj.isEmpty()) {
                resolvedValue = obj.getValue();
            }
        } else {
            LOGGER.debug("Evaluated {} returning value enclosed as GenericResult.", (Object)this.value);
            resolvedValue = this.value;
        }
        LOGGER.debug("Evaluated value {} to {} ", (Object)this.value, (Object)resolvedValue);
        if (resolvedValue != null) {
            return this.getValueOfSpecifiedType(resolvedValue);
        }
        LOGGER.debug("Evaluated {} returning null", (Object)this.value);
        return null;
    }

    private EvaluationResult getValueOfSpecifiedType(Object obj) {
        if (obj != null) {
            LOGGER.debug("Evaluated value {} to {} type {} ", new Object[]{this.value, obj, obj.getClass()});
            ValueExtractor<Object, ?> resolver = SimpleDataTypeMapper.getValueResolver(this.getType());
            return EvaluationResultFactory.getEvaluationResult(resolver.apply(obj));
        }
        LOGGER.debug("Evaluated {} returning null", (Object)this.value);
        return null;
    }

    private static EvaluationResult getVariableValueFromVariableContextMap(String varName, ImmutableMap<String, EvaluationResult> contextValues) {
        if (StringUtils.isNotBlank((CharSequence)varName)) {
            EvaluationResult fetchedValue = (EvaluationResult)contextValues.get((Object)VariableUtils.getVarName(varName));
            return fetchedValue;
        }
        return null;
    }
}

