/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.expression.EmptyEvaluationResult;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.hl7.expression.AbstractExpression;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExtractionGeneralExpression
extends AbstractExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueExtractionGeneralExpression.class);
    private ImmutablePair<String, String> fetch;
    private boolean isUseGroup;

    @JsonCreator
    public ValueExtractionGeneralExpression(ExpressionAttributes expAttr) {
        super(expAttr);
        this.fetch = expAttr.getFetch();
        this.isUseGroup = expAttr.isUseGroup();
    }

    @Override
    public EvaluationResult evaluateExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult basevalue) {
        Preconditions.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"dataSource cannot be null");
        Preconditions.checkArgument((contextValues != null ? 1 : 0) != 0, (Object)"contextValues cannot be null");
        HashMap<String, EvaluationResult> resolvedVariables = new HashMap<String, EvaluationResult>(contextValues);
        EvaluationResult resource = "BASE_VALUE".equals(this.fetch.getKey()) ? basevalue : (EvaluationResult)resolvedVariables.get(this.getKeyName(contextValues));
        if (resource != null && resource.getValue() instanceof Map) {
            Map resourceMap = (Map)resource.getValue();
            return EvaluationResultFactory.getEvaluationResult(resourceMap.get(this.fetch.getValue()));
        }
        if (resource != null && resource.getValue() instanceof ResourceValue) {
            ResourceValue rv = (ResourceValue)resource.getValue();
            Map<String, Object> resourceMap = rv.getResource();
            return EvaluationResultFactory.getEvaluationResult(resourceMap.get(this.fetch.getValue()));
        }
        return new EmptyEvaluationResult();
    }

    private String getKeyName(Map<String, EvaluationResult> contextValues) {
        if (this.isUseGroup) {
            String groupId = ValueExtractionGeneralExpression.getGroupId(contextValues);
            return (String)this.fetch.getKey() + "_" + groupId;
        }
        return (String)this.fetch.getKey();
    }
}

