/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression.specification;

import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.core.expression.EmptyEvaluationResult;
import io.github.linuxforhealth.core.expression.SimpleEvaluationResult;
import io.github.linuxforhealth.core.expression.VariableUtils;
import io.github.linuxforhealth.hl7.expression.specification.SimpleSpecification;
import java.util.List;
import java.util.Map;

public class ContextMapData
implements InputDataExtractor {
    @Override
    public EvaluationResult evaluateJexlExpression(String expression, Map<String, EvaluationResult> contextValues) {
        throw new IllegalStateException("No supported for this input source type");
    }

    @Override
    public String getName() {
        return "ContextMap";
    }

    @Override
    public String getId() {
        throw new IllegalStateException("No supported for this input source type");
    }

    @Override
    public EvaluationResult extractValueForSpec(Specification spec, Map<String, EvaluationResult> contextValues) {
        EvaluationResult fetchedValue = this.extractMultipleValuesForSpec(spec, contextValues);
        if (fetchedValue != null && !fetchedValue.isEmpty()) {
            return new SimpleEvaluationResult<Object>(ContextMapData.getSingleValue(fetchedValue.getValue()));
        }
        return new EmptyEvaluationResult();
    }

    @Override
    public EvaluationResult extractMultipleValuesForSpec(Specification spec, Map<String, EvaluationResult> contextValues) {
        SimpleSpecification simpleSpec = (SimpleSpecification)spec;
        EvaluationResult res = contextValues.get(ContextMapData.getKeyName(contextValues, VariableUtils.getVarName(simpleSpec.getVariable())));
        if (res != null && !res.isEmpty()) {
            return res;
        }
        return new EmptyEvaluationResult();
    }

    private static Object getSingleValue(Object object) {
        if (object instanceof List) {
            List value = (List)object;
            if (value.isEmpty()) {
                return null;
            }
            return value.get(0);
        }
        return object;
    }

    private static String getGroupId(Map<String, EvaluationResult> localContext) {
        EvaluationResult result = localContext.get("GROUP_ID");
        if (result != null) {
            return (String)result.getValue();
        }
        return null;
    }

    private static String getKeyName(Map<String, EvaluationResult> contextValues, String key) {
        boolean useGroup = false;
        EvaluationResult result = contextValues.get("useGroup");
        if (result != null && !result.isEmpty()) {
            useGroup = (Boolean)result.getValue();
        }
        if (useGroup) {
            String groupId = ContextMapData.getGroupId(contextValues);
            return key + "_" + groupId;
        }
        return key;
    }
}

