/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression.specification;

import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.core.expression.EmptyEvaluationResult;
import java.util.List;
import java.util.Map;

public class SpecificationUtil {
    private SpecificationUtil() {
    }

    public static EvaluationResult extractValueForSpec(List<Specification> hl7specs, InputDataExtractor source, Map<String, EvaluationResult> contextValues) {
        EvaluationResult fetchedValue = null;
        for (Specification spec : hl7specs) {
            fetchedValue = spec.extractValueForSpec(source, contextValues);
            if (fetchedValue == null || fetchedValue.isEmpty()) continue;
            return fetchedValue;
        }
        return new EmptyEvaluationResult();
    }

    public static EvaluationResult extractMultipleValuesForSpec(List<Specification> hl7specs, InputDataExtractor source, Map<String, EvaluationResult> contextValues) {
        EvaluationResult fetchedValue = null;
        for (Specification spec : hl7specs) {
            fetchedValue = spec.extractMultipleValuesForSpec(source, contextValues);
            if (fetchedValue == null || fetchedValue.isEmpty()) continue;
            return fetchedValue;
        }
        return new EmptyEvaluationResult();
    }
}

