/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression.variable;

import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.core.expression.EmptyEvaluationResult;
import io.github.linuxforhealth.hl7.expression.variable.SimpleVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpressionVariable
extends SimpleVariable {
    private String expression;

    public ExpressionVariable(String name, String expression, List<String> spec, boolean extractMultiple) {
        super(name, spec, extractMultiple, false);
        this.expression = expression;
    }

    public ExpressionVariable(String name, String expression, List<String> spec, boolean extractMultiple, boolean retainEmpty) {
        super(name, spec, extractMultiple, false, retainEmpty);
        this.expression = expression;
    }

    @Override
    public EvaluationResult extractVariableValue(Map<String, EvaluationResult> contextValues, InputDataExtractor dataSource) {
        EvaluationResult result = null;
        if (!this.getSpec().isEmpty()) {
            result = this.getValueFromSpecs(contextValues, dataSource);
        }
        if (result == null) {
            result = new EmptyEvaluationResult();
        }
        if (this.expression != null) {
            HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
            localContextValues.put(this.getName(), result);
            result = dataSource.evaluateJexlExpression(this.expression, localContextValues);
        }
        return result;
    }

    public String getExpression() {
        return this.expression;
    }
}

