/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.FHIRResourceTemplate;
import io.github.linuxforhealth.api.MessageEngine;
import io.github.linuxforhealth.api.MessageTemplate;
import io.github.linuxforhealth.hl7.message.HL7FHIRResourceTemplate;
import io.github.linuxforhealth.hl7.message.HL7MessageData;
import io.github.linuxforhealth.hl7.parsing.HL7DataExtractor;
import io.github.linuxforhealth.hl7.parsing.HL7HapiParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Bundle;

public class HL7MessageModel
implements MessageTemplate<Message> {
    private List<FHIRResourceTemplate> resources;
    private String messageName;

    @JsonCreator
    public HL7MessageModel(@JsonProperty(value="messageName") String messageName, @JsonProperty(value="resources") List<HL7FHIRResourceTemplate> resources) {
        this.messageName = messageName;
        this.resources = new ArrayList<FHIRResourceTemplate>();
        if (resources != null && !resources.isEmpty()) {
            this.resources.addAll(resources);
        }
    }

    @Override
    public String convert(String message, MessageEngine engine) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)message), (Object)"Input Hl7 message cannot be blank");
        HL7HapiParser hparser = null;
        try {
            hparser = new HL7HapiParser();
            Message hl7message = hparser.getParser().parse(message);
            String string = this.convert(hl7message, engine);
            return string;
        }
        catch (HL7Exception e) {
            throw new IllegalArgumentException("Cannot parse the message.", e);
        }
        finally {
            if (hparser != null) {
                hparser.getContext().close();
            }
        }
    }

    @Override
    public String convert(Message message, MessageEngine engine) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"Input Hl7 message cannot be null");
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (Object)"MessageEngine cannot be null");
        HL7DataExtractor hl7DTE = new HL7DataExtractor(message);
        HL7MessageData dataSource = new HL7MessageData(hl7DTE);
        Bundle bundle = engine.transform(dataSource, this.getResources(), new HashMap<String, EvaluationResult>());
        return engine.getFHIRContext().encodeResourceToString(bundle);
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    @Override
    public List<FHIRResourceTemplate> getResources() {
        return new ArrayList<FHIRResourceTemplate>(this.resources);
    }
}

