/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;

public class HL7Segment {
    private static final String SEGMENT_CANNOT_BE_NULL_OR_EMPTY = "Segment cannot be null or empty";
    private static final String DEFAULT_GROUP = null;
    private List<String> group;
    private String segment;
    private boolean fromGroup;

    public HL7Segment(String group, String segment) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)segment), (Object)SEGMENT_CANNOT_BE_NULL_OR_EMPTY);
        this.segment = segment;
        this.group = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)group)) {
            this.group.add(group);
        }
    }

    public HL7Segment(List<String> group, String segment) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)segment), (Object)SEGMENT_CANNOT_BE_NULL_OR_EMPTY);
        this.segment = segment;
        this.group = new ArrayList<String>();
        if (group != null) {
            this.group.addAll(group);
        }
    }

    public HL7Segment(String segment, boolean fromGroup) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)segment), (Object)SEGMENT_CANNOT_BE_NULL_OR_EMPTY);
        this.segment = segment;
        this.group = new ArrayList<String>();
        this.fromGroup = fromGroup;
    }

    public HL7Segment(List<String> group, String segment, boolean fromGroup) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)segment), (Object)SEGMENT_CANNOT_BE_NULL_OR_EMPTY);
        this.segment = segment;
        this.group = new ArrayList<String>();
        if (group != null) {
            this.group.addAll(group);
        }
        this.fromGroup = fromGroup;
    }

    public HL7Segment(String segment) {
        this(DEFAULT_GROUP, segment);
    }

    public String getSegment() {
        return this.segment;
    }

    public List<String> getGroup() {
        return ImmutableList.copyOf(this.group);
    }

    public static HL7Segment parse(String rawSegment) {
        return HL7Segment.parse(rawSegment, null);
    }

    public static HL7Segment parse(String rawSegment, String rawGroup) {
        if (StringUtils.startsWith((CharSequence)rawSegment, (CharSequence)".")) {
            String segment = StringUtils.removeStart((String)rawSegment, (String)".");
            return HL7Segment.createHL7Segment(segment, rawGroup);
        }
        return HL7Segment.createHL7Segment(rawSegment);
    }

    private static HL7Segment createHL7Segment(String rawSegment, String rawGroup) {
        List<String> group = HL7Segment.parseGroup(rawGroup);
        StringTokenizer tokSegment = new StringTokenizer(rawSegment, ".");
        String segment = null;
        List tokensSegment = tokSegment.getTokenList();
        if (tokensSegment.size() > 1) {
            group.addAll(tokensSegment.subList(0, tokensSegment.size() - 1));
            segment = (String)tokensSegment.get(tokensSegment.size() - 1);
        } else if (tokensSegment.size() == 1) {
            segment = (String)tokensSegment.get(0);
        } else {
            throw new IllegalArgumentException("rawSegment cannot be parsed:" + rawSegment);
        }
        return new HL7Segment(group, segment, true);
    }

    public static List<String> parseGroup(String rawGroup) {
        ArrayList<String> group = new ArrayList<String>();
        if (rawGroup != null) {
            StringTokenizer tokGroup = new StringTokenizer(rawGroup, ".");
            group.addAll(tokGroup.getTokenList());
        }
        return group;
    }

    private static HL7Segment createHL7Segment(String rawSegment) {
        StringTokenizer stk = new StringTokenizer(rawSegment, ".");
        String segment = null;
        ArrayList<String> group = new ArrayList<String>();
        List tokens = stk.getTokenList();
        if (tokens.size() > 1) {
            group.addAll(tokens.subList(0, tokens.size() - 1));
            segment = (String)tokens.get(tokens.size() - 1);
        } else if (tokens.size() == 1) {
            segment = (String)tokens.get(0);
        } else {
            throw new IllegalArgumentException("rawSegment cannot be parsed:" + rawSegment);
        }
        return new HL7Segment(group, segment, false);
    }

    public boolean isFromGroup() {
        return this.fromGroup;
    }
}

