/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.parsing;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Unmodifiable;
import ca.uhn.hl7v2.model.Variable;
import ca.uhn.hl7v2.util.Terser;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.github.linuxforhealth.hl7.parsing.result.Hl7ParsingStringResult;
import io.github.linuxforhealth.hl7.parsing.result.Hl7ParsingStructureResult;
import io.github.linuxforhealth.hl7.parsing.result.Hl7ParsingTypeResult;
import io.github.linuxforhealth.hl7.parsing.result.ParsingResult;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7DataExtractor {
    private static final String CANNOT_EXTRACT_VALUE_FOR_REP_REASON = "Cannot extract value for {} rep {} reason {}";
    private static final String SEGMENT_CANNOT_BE_NULL_OR_EMPTY = "segment cannot be null or empty";
    private static final String REP_CANNOT_BE_NEGATIVE = "rep cannot be negative";
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7DataExtractor.class);
    private final Message message;

    public HL7DataExtractor(Message message) {
        this.message = message;
    }

    private static Predicate<Structure> isEmpty() {
        return p -> {
            try {
                return p == null || p.isEmpty();
            }
            catch (HL7Exception e) {
                LOGGER.debug("Error", (Throwable)e);
                return true;
            }
        };
    }

    public ParsingResult<Structure> getStructure(String group, int groupRep, String segment, int rep) {
        LOGGER.debug("Fetching segment: {} {} {} {}", new Object[]{group, groupRep, segment, rep});
        try {
            Group gp;
            Structure s;
            Hl7ParsingStructureResult parsingResult = null;
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)group), (Object)"group cannot be null or empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)segment), (Object)SEGMENT_CANNOT_BE_NULL_OR_EMPTY);
            Preconditions.checkArgument((groupRep >= 0 ? 1 : 0) != 0, (Object)"groupRep should be greater than or equal to 0");
            Preconditions.checkArgument((rep >= 0 ? 1 : 0) != 0, (Object)"Segment rep cannot be less than 0");
            Structure groupStr = this.message.get(group, groupRep);
            parsingResult = groupStr instanceof Group ? ((s = (gp = (Group)groupStr).get(segment, rep)) != null && !s.isEmpty() ? new Hl7ParsingStructureResult(s) : new Hl7ParsingStructureResult(new ArrayList<Structure>())) : new Hl7ParsingStructureResult(new ArrayList<Structure>());
            return parsingResult;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            String spec = group + " " + groupRep + " " + segment;
            LOGGER.debug("Cannot extract value for {} rep {} ", new Object[]{spec, rep, e});
            LOGGER.warn(CANNOT_EXTRACT_VALUE_FOR_REP_REASON, new Object[]{spec, rep, e.getMessage()});
            return new Hl7ParsingStructureResult(new ArrayList<Structure>());
        }
    }

    public ParsingResult<Structure> getAllStructures(String group, int groupRep, String segment) {
        LOGGER.debug("Fetching segment: {} {} {} ", new Object[]{group, groupRep, segment});
        try {
            Hl7ParsingStructureResult parsingResult = null;
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)group), (Object)"group cannot be null or empty");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)segment), (Object)SEGMENT_CANNOT_BE_NULL_OR_EMPTY);
            Preconditions.checkArgument((groupRep >= 0 ? 1 : 0) != 0, (Object)"groupRep should be greater than or equal to 0");
            Structure groupStr = this.message.get(group, groupRep);
            if (groupStr instanceof Group) {
                Group gp = (Group)groupStr;
                Object[] s = gp.getAll(segment);
                ArrayList list = Lists.newArrayList((Object[])s);
                list.removeIf(HL7DataExtractor.isEmpty());
                parsingResult = new Hl7ParsingStructureResult(Lists.newArrayList((Iterable)list));
            } else {
                parsingResult = new Hl7ParsingStructureResult(new ArrayList<Structure>());
            }
            return parsingResult;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            String spec = group + " " + groupRep + " " + segment;
            LOGGER.debug("Cannot extract value for {} ", (Object)spec, (Object)e);
            LOGGER.warn("Cannot extract value for {} reason {}", (Object)spec, (Object)e.getMessage());
            return new Hl7ParsingStructureResult(new ArrayList<Structure>());
        }
    }

    public boolean doesSegmentExists(String spec) {
        LOGGER.debug("Checking if segment exists: {}", (Object)spec);
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)spec), (Object)"Not a valid string to extract from Message");
            Message unmodifiableMessage = Unmodifiable.unmodifiableMessage((Message)this.message);
            Structure s = unmodifiableMessage.get(spec);
            return s != null;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for {}  ", (Object)spec, (Object)e);
            LOGGER.warn("Cannot extract value for {} reason {}", (Object)spec, (Object)e.getMessage());
            return false;
        }
    }

    public boolean doesSegmentExists(String spec, int rep) {
        LOGGER.debug("Checking if segment exists: {}", (Object)spec);
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)spec), (Object)"Not a valid string to extract from Terser");
            Preconditions.checkArgument((rep >= 0 ? 1 : 0) != 0, (Object)"Segment rep cannot be less than 0");
            Message unmodifiableMessage = Unmodifiable.unmodifiableMessage((Message)this.message);
            Structure s = unmodifiableMessage.get(spec, rep);
            return s != null;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for {} rep{}  ", new Object[]{spec, rep, e});
            LOGGER.warn(CANNOT_EXTRACT_VALUE_FOR_REP_REASON, new Object[]{spec, rep, e.getMessage()});
            return false;
        }
    }

    public ParsingResult<Structure> getStructure(String structure, int rep) {
        try {
            Hl7ParsingStructureResult parsingResult = null;
            if (this.doesSegmentExists(structure, rep)) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)structure), (Object)"Not a valid string to extract from Hl7");
                Preconditions.checkArgument((rep >= 0 ? 1 : 0) != 0, (Object)REP_CANNOT_BE_NEGATIVE);
                LOGGER.debug("fetching values for spec {} rep {}", (Object)structure, (Object)rep);
                parsingResult = new Hl7ParsingStructureResult(this.message.get(structure, rep));
            } else {
                parsingResult = new Hl7ParsingStructureResult(new ArrayList<Structure>());
            }
            return parsingResult;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for {} rep {}  ", new Object[]{structure, rep, e});
            LOGGER.warn(CANNOT_EXTRACT_VALUE_FOR_REP_REASON, new Object[]{structure, rep, e.getMessage()});
            return new Hl7ParsingStructureResult(new ArrayList<Structure>());
        }
    }

    public ParsingResult<Structure> getAllStructures(String structure) {
        try {
            Hl7ParsingStructureResult parsingResult = null;
            if (this.doesSegmentExists(structure)) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)structure), (Object)"Not a valid string to extract from Hl7");
                LOGGER.debug("fetching values for spec {}, ", (Object)structure);
                Object[] strs = this.message.getAll(structure);
                parsingResult = new Hl7ParsingStructureResult(Lists.newArrayList((Object[])strs));
            } else {
                parsingResult = new Hl7ParsingStructureResult(new ArrayList<Structure>());
            }
            return parsingResult;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for {}   ", (Object)structure, (Object)e);
            LOGGER.warn("Cannot extract value for {}  reason {}", (Object)structure, (Object)e.getMessage());
            return new Hl7ParsingStructureResult(new ArrayList<Structure>());
        }
    }

    public ParsingResult<Type> getType(Segment segment, int field, int rep) {
        try {
            Preconditions.checkArgument((segment != null ? 1 : 0) != 0, (Object)"segment cannot be null");
            Preconditions.checkArgument((field >= 1 ? 1 : 0) != 0, (Object)"field cannot be negative");
            Preconditions.checkArgument((rep >= 0 ? 1 : 0) != 0, (Object)REP_CANNOT_BE_NEGATIVE);
            LOGGER.debug("fetching values for Segment {} field {} rep {}, ", new Object[]{segment, field, rep});
            return new Hl7ParsingTypeResult(segment.getField(field, rep));
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for {} rep {}  field {} ", new Object[]{segment, rep, field, e});
            LOGGER.warn("Cannot extract value for {} rep {} field {} reason {}", new Object[]{segment, rep, field, e.getMessage()});
            return new Hl7ParsingTypeResult(new ArrayList<Type>());
        }
    }

    public ParsingResult<Type> getTypes(Segment segment, int field) {
        try {
            Preconditions.checkArgument((segment != null ? 1 : 0) != 0, (Object)"segment cannot be null");
            Preconditions.checkArgument((field >= 1 ? 1 : 0) != 0, (Object)"field cannot be negative");
            LOGGER.debug("fetching values for Segment {} field {}  ", (Object)segment, (Object)field);
            Object[] fields = segment.getField(field);
            return new Hl7ParsingTypeResult(Lists.newArrayList((Object[])fields));
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for segment {} field {}  ", new Object[]{segment, field, e});
            LOGGER.warn("Cannot extract value for segment {} field {}, reason {}", new Object[]{segment, field, e.getMessage()});
            return new Hl7ParsingTypeResult(new ArrayList<Type>());
        }
    }

    public ParsingResult<Type> getComponent(Type inputType, int component) {
        try {
            Type value;
            Preconditions.checkArgument((inputType != null ? 1 : 0) != 0, (Object)"type!=null");
            Type type = inputType;
            if (inputType instanceof Variable) {
                type = ((Variable)inputType).getData();
            }
            Hl7ParsingTypeResult result = type instanceof Composite ? ((value = ((Composite)type).getComponent(component - 1)) != null && !value.isEmpty() ? new Hl7ParsingTypeResult(((Composite)type).getComponent(component - 1)) : new Hl7ParsingTypeResult(new ArrayList<Type>())) : new Hl7ParsingTypeResult(type);
            return result;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for type {} component {}  ", new Object[]{inputType, component, e});
            LOGGER.warn("Cannot extract value for type {} component {}, reason {}", new Object[]{inputType, component, e.getMessage()});
            return new Hl7ParsingTypeResult(new ArrayList<Type>());
        }
    }

    public ParsingResult<Type> getComponent(Type inputType, int component, int subComponent) {
        try {
            Primitive prim;
            Preconditions.checkArgument((inputType != null ? 1 : 0) != 0, (Object)"inputType!=null");
            Type type = inputType;
            if (inputType instanceof Variable) {
                type = ((Variable)inputType).getData();
            }
            Hl7ParsingTypeResult result = (prim = Terser.getPrimitive((Type)type, (int)component, (int)subComponent)) != null && !prim.isEmpty() ? new Hl7ParsingTypeResult((Type)prim) : new Hl7ParsingTypeResult(new ArrayList<Type>());
            return result;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for type {} component {} subComponent {}  ", new Object[]{inputType, component, subComponent, e});
            LOGGER.warn("Cannot extract value for type {} component {},subComponent {}, reason {}", new Object[]{inputType, component, subComponent, e.getMessage()});
            return new Hl7ParsingTypeResult(new ArrayList<Type>());
        }
    }

    private Terser getTerser() {
        Message unmodifiableMessage = Unmodifiable.unmodifiableMessage((Message)this.message);
        return new Terser(unmodifiableMessage);
    }

    public static String getMessageType(Message message) {
        return message.getName();
    }

    public String getMessageType() {
        return this.message.getName();
    }

    public ParsingResult<String> get(String segment, String field) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)segment), (Object)"segment cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)field), (Object)"field cannot be blank");
        try {
            return new Hl7ParsingStringResult(this.getTerser().get("/" + segment + "-" + field));
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for Segment {} field {}   ", new Object[]{segment, field, e});
            LOGGER.warn("Cannot extract value for Segment {} field {}, reason {}", new Object[]{segment, field, e.getMessage()});
            return new Hl7ParsingStringResult(null);
        }
    }

    public String getMessageId() {
        try {
            return this.getTerser().get("/MSH-10");
        }
        catch (HL7Exception | IllegalArgumentException e) {
            LOGGER.warn("Cannot extract message control id, reason {} ", (Object)e.getMessage());
            LOGGER.debug("Cannot extract message control id", e);
            return null;
        }
    }

    public ParsingResult<Structure> getAllStructures(Structure struct, String segment) {
        LOGGER.debug("Fetching segment: {} {}  ", (Object)struct, (Object)segment);
        try {
            Hl7ParsingStructureResult parsingResult = null;
            Preconditions.checkArgument((struct != null ? 1 : 0) != 0, (Object)"struct cannot be null ");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)segment), (Object)SEGMENT_CANNOT_BE_NULL_OR_EMPTY);
            if (struct instanceof Group) {
                Group gp = (Group)struct;
                Object[] s = gp.getAll(segment);
                ArrayList list = Lists.newArrayList((Object[])s);
                list.removeIf(HL7DataExtractor.isEmpty());
                parsingResult = new Hl7ParsingStructureResult(list);
            } else {
                parsingResult = new Hl7ParsingStructureResult(new ArrayList<Structure>());
            }
            return parsingResult;
        }
        catch (HL7Exception | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            LOGGER.debug("Cannot extract value for Structure {} Segment {}   ", new Object[]{struct, segment, e});
            LOGGER.warn("Cannot extract value for Structure {} Segment {}, reason {}", new Object[]{struct, segment, e.getMessage()});
            return new Hl7ParsingStructureResult(new ArrayList<Structure>());
        }
    }
}

