/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.resource;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableMap;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.Expression;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.ResourceModel;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.exception.DataExtractionException;
import io.github.linuxforhealth.core.exception.RequiredConstraintFailureException;
import io.github.linuxforhealth.core.resource.ResourceResult;
import io.github.linuxforhealth.core.resource.SimpleResourceValue;
import io.github.linuxforhealth.hl7.expression.Hl7Expression;
import io.github.linuxforhealth.hl7.expression.JEXLExpression;
import io.github.linuxforhealth.hl7.expression.ReferenceExpression;
import io.github.linuxforhealth.hl7.expression.ResourceExpression;
import io.github.linuxforhealth.hl7.expression.SimpleExpression;
import io.github.linuxforhealth.hl7.expression.ValueExtractionGeneralExpression;
import io.github.linuxforhealth.hl7.resource.deserializer.HL7DataBasedResourceDeserializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=HL7DataBasedResourceDeserializer.class)
public class HL7DataBasedResourceModel
implements ResourceModel {
    private static final String EVALUATING = "Evaluating {} {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7DataBasedResourceModel.class);
    private Map<String, Expression> expressions = new HashMap<String, Expression>();
    private String spec;
    private String name;

    public HL7DataBasedResourceModel(String name, Map<String, Expression> expressions, String hl7spec) {
        this.expressions.putAll(expressions);
        this.spec = hl7spec;
        this.name = name;
    }

    public HL7DataBasedResourceModel(String name, Map<String, Expression> expressions) {
        this(name, expressions, null);
    }

    @Override
    public Map<String, Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public ResourceResult evaluate(InputDataExtractor dataSource, Map<String, EvaluationResult> variables, EvaluationResult baseValue) {
        ResourceResult resources = null;
        try {
            HashMap<String, EvaluationResult> localContext = new HashMap<String, EvaluationResult>(variables);
            Map<String, Expression> expressionMap = this.getExpressions();
            Map<String, Expression> defaultExp = expressionMap.entrySet().stream().filter(e -> e.getValue() instanceof SimpleExpression).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Expression> resourceExp = expressionMap.entrySet().stream().filter(e -> e.getValue() instanceof ResourceExpression).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Expression> refResourceExp = expressionMap.entrySet().stream().filter(e -> e.getValue() instanceof ReferenceExpression).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Expression> hl7Exps = expressionMap.entrySet().stream().filter(e -> e.getValue() instanceof Hl7Expression).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Expression> valueExtractionExp = expressionMap.entrySet().stream().filter(e -> e.getValue() instanceof ValueExtractionGeneralExpression).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Expression> jexlExp = expressionMap.entrySet().stream().filter(e -> e.getValue() instanceof JEXLExpression).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList<ResourceValue> additionalResolveValues = new ArrayList<ResourceValue>();
            HashMap<String, Object> resolveValues = new HashMap<String, Object>();
            if (!resourceExp.isEmpty()) {
                LOGGER.info("Started Evaluating resource expressions for {}", (Object)this.name);
            }
            HL7DataBasedResourceModel.evaluateResourceExpression(dataSource, localContext, resourceExp, additionalResolveValues, resolveValues, baseValue);
            if (!refResourceExp.isEmpty()) {
                LOGGER.info("Started Evaluating reference resource expression for {}", (Object)this.name);
            }
            HL7DataBasedResourceModel.evaluateReferenceExpression(dataSource, localContext, refResourceExp, additionalResolveValues, resolveValues, baseValue);
            if (!hl7Exps.isEmpty()) {
                LOGGER.info("Started Evaluating HL7 expression for {}", (Object)this.name);
            }
            HL7DataBasedResourceModel.executeExpression(dataSource, localContext, resolveValues, hl7Exps, baseValue);
            if (!valueExtractionExp.isEmpty()) {
                LOGGER.info("Started Evaluating value extraction expression for {}", (Object)this.name);
            }
            HL7DataBasedResourceModel.executeExpression(dataSource, localContext, resolveValues, valueExtractionExp, baseValue);
            if (!defaultExp.isEmpty()) {
                LOGGER.info("Started Evaluating Simple expression for {}", (Object)this.name);
            }
            HL7DataBasedResourceModel.executeExpression(dataSource, localContext, resolveValues, defaultExp, baseValue);
            if (!jexlExp.isEmpty()) {
                LOGGER.info("Started Evaluating JEXL expressions for {}", (Object)this.name);
            }
            HL7DataBasedResourceModel.executeExpression(dataSource, localContext, resolveValues, jexlExp, baseValue);
            resolveValues.values().removeIf(Objects::isNull);
            if (!resolveValues.isEmpty()) {
                String groupId = HL7DataBasedResourceModel.getGroupId(localContext);
                resources = new ResourceResult(new SimpleResourceValue(resolveValues, this.name), additionalResolveValues, groupId);
            }
        }
        catch (RequiredConstraintFailureException e2) {
            LOGGER.warn("Resource Constraint condition not satisfied for  {} , exception {}", (Object)this.name, (Object)e2.getMessage());
            LOGGER.debug("Resource Constraint condition not satisfied for  {} , exception {}", (Object)this.name, (Object)e2);
            return null;
        }
        catch (DataExtractionException | IllegalArgumentException | IllegalStateException e3) {
            LOGGER.error("Exception during  resource {} evaluation reason {}", (Object)this.name, (Object)e3);
            return null;
        }
        return resources;
    }

    private static String getGroupId(Map<String, EvaluationResult> localContext) {
        EvaluationResult result = localContext.get("GROUP_ID");
        if (result != null && result.getValue() instanceof String) {
            return (String)result.getValue();
        }
        return null;
    }

    private static void evaluateReferenceExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> localContext, Map<String, Expression> refResourceExp, List<ResourceValue> additionalResolveValues, Map<String, Object> resolveValues, EvaluationResult baseValue) {
        for (Map.Entry<String, Expression> entry : refResourceExp.entrySet()) {
            ReferenceExpression exp = (ReferenceExpression)entry.getValue();
            LOGGER.debug(EVALUATING, (Object)exp.getType(), (Object)entry.getKey());
            LOGGER.debug("Extracting reference resource  {} {} reference {}", new Object[]{exp.getType(), entry.getKey(), exp.getReference()});
            EvaluationResult obj = exp.evaluate(dataSource, (Map<String, EvaluationResult>)ImmutableMap.copyOf(localContext), baseValue);
            LOGGER.debug("Extracted object from reference resource  {} {} reference {}  value {}", new Object[]{exp.getType(), entry.getKey(), exp.getReference(), obj});
            if (obj == null || obj.isEmpty()) continue;
            if (!resolveValues.containsKey(HL7DataBasedResourceModel.getKeyName(entry.getKey()))) {
                resolveValues.put(HL7DataBasedResourceModel.getKeyName(entry.getKey()), obj.getValue());
            } else {
                Object existing = resolveValues.get(HL7DataBasedResourceModel.getKeyName(entry.getKey()));
                if (existing instanceof List) {
                    if (obj.getValue() instanceof List) {
                        ((List)existing).addAll((Collection)obj.getValue());
                    } else {
                        ((List)existing).add(obj.getValue());
                    }
                }
            }
            if (obj.getAdditionalResources() == null || obj.getAdditionalResources().isEmpty()) continue;
            additionalResolveValues.addAll(obj.getAdditionalResources());
        }
    }

    private static void evaluateResourceExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> localContext, Map<String, Expression> resourceExp, List<ResourceValue> additionalResolveValues, Map<String, Object> resolveValues, EvaluationResult baseValue) {
        for (Map.Entry<String, Expression> entry : resourceExp.entrySet()) {
            ResourceExpression exp = (ResourceExpression)entry.getValue();
            LOGGER.debug(EVALUATING, (Object)exp.getType(), (Object)entry.getKey());
            LOGGER.debug("Extracted resource  {} {} reference {}", new Object[]{exp.getType(), entry.getKey(), exp.getResource()});
            EvaluationResult obj = exp.evaluate(dataSource, (Map<String, EvaluationResult>)ImmutableMap.copyOf(localContext), baseValue);
            LOGGER.debug("Extracted object from reference resource  {} {} reference {}  value {}", new Object[]{exp.getType(), entry.getKey(), exp.getResource(), obj});
            if (obj == null || obj.isEmpty()) continue;
            if (!resolveValues.containsKey(HL7DataBasedResourceModel.getKeyName(entry.getKey()))) {
                resolveValues.put(HL7DataBasedResourceModel.getKeyName(entry.getKey()), obj.getValue());
            } else {
                Object existing = resolveValues.get(HL7DataBasedResourceModel.getKeyName(entry.getKey()));
                if (existing instanceof List) {
                    if (obj.getValue() instanceof List) {
                        ((List)existing).addAll((Collection)obj.getValue());
                    } else {
                        ((List)existing).add(obj.getValue());
                    }
                }
            }
            if (obj.getAdditionalResources() == null || obj.getAdditionalResources().isEmpty()) continue;
            additionalResolveValues.addAll(obj.getAdditionalResources());
        }
    }

    private static String getKeyName(String key) {
        return StringUtils.split((String)key, (String)"_")[0];
    }

    private static void executeExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> localContext, Map<String, Object> resolveValues, Map<String, Expression> hl7Exps, EvaluationResult baseValue) {
        for (Map.Entry<String, Expression> entry : hl7Exps.entrySet()) {
            Expression exp = entry.getValue();
            LOGGER.debug(EVALUATING, (Object)entry.getKey(), (Object)entry.getValue());
            EvaluationResult obj = exp.evaluate(dataSource, localContext, baseValue);
            LOGGER.debug("Evaluated {} {} value returned {} ", new Object[]{entry.getKey(), entry.getValue(), obj});
            if (obj == null || obj.isEmpty()) continue;
            if (!resolveValues.containsKey(HL7DataBasedResourceModel.getKeyName(entry.getKey()))) {
                resolveValues.put(HL7DataBasedResourceModel.getKeyName(entry.getKey()), obj.getValue());
                continue;
            }
            Object existing = resolveValues.get(HL7DataBasedResourceModel.getKeyName(entry.getKey()));
            if (!(existing instanceof List)) continue;
            if (obj.getValue() instanceof List) {
                ((List)existing).addAll((Collection)obj.getValue());
                continue;
            }
            ((List)existing).add(obj.getValue());
        }
    }

    public String getSpec() {
        return this.spec;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

