/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.resource.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.linuxforhealth.api.Expression;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import io.github.linuxforhealth.hl7.resource.HL7DataBasedResourceModel;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7DataBasedResourceDeserializer
extends JsonDeserializer<HL7DataBasedResourceModel> {
    private static final String RESOURCE_TYPE_FIELD_NAME = "resourceType";
    private static final ObjectMapper MAPPER = ObjectMapperUtil.getYAMLInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7DataBasedResourceDeserializer.class);

    public HL7DataBasedResourceModel deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectNode node = (ObjectNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode hl7PrefixNode = node.get("specs");
        String hl7Prefix = null;
        if (hl7PrefixNode != null) {
            hl7Prefix = hl7PrefixNode.toString();
        }
        HashMap<String, Expression> expressions = new HashMap<String, Expression>();
        Iterator iter = node.fields();
        while (iter.hasNext()) {
            Expression e;
            Map.Entry entry = (Map.Entry)iter.next();
            LOGGER.debug("deserealizing {}", (Object)entry);
            ExpressionAttributes expAttr = (ExpressionAttributes)MAPPER.convertValue(entry.getValue(), ExpressionAttributes.class);
            if (expAttr == null || expAttr.getExpressionType() == null) continue;
            expAttr.setName((String)entry.getKey());
            try {
                Constructor<? extends Expression> ctor = expAttr.getExpressionType().getEvaluator().getConstructor(ExpressionAttributes.class);
                e = ctor.newInstance(expAttr);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                LOGGER.error("deserialization failure {} expression type {}", new Object[]{entry, expAttr.getExpressionType(), e1});
                e = null;
            }
            if (e != null) {
                expressions.put((String)entry.getKey(), e);
            }
            LOGGER.debug("deserialized {} expression type {}", (Object)entry, (Object)e);
        }
        JsonNode namenode = node.get(RESOURCE_TYPE_FIELD_NAME);
        String name = String.valueOf(ctxt.findInjectableValue((Object)"resourceName", null, null));
        if (namenode != null) {
            name = namenode.textValue();
        }
        return new HL7DataBasedResourceModel(name, expressions, hl7Prefix);
    }
}

