/*
 * Decompiled with CFR 0.152.
 */
package io.github.linyimin0812.profiler.common.ui;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.github.linyimin0812.profiler.common.logger.LogFactory;
import io.github.linyimin0812.profiler.common.ui.BeanInitResult;
import io.github.linyimin0812.profiler.common.ui.MethodInvokeDetail;
import io.github.linyimin0812.profiler.common.ui.MethodInvokeMetrics;
import io.github.linyimin0812.profiler.common.ui.Statistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class StartupVO {
    private static final Logger logger = LogFactory.getStartupLogger();
    private static final List<BeanInitResult> beanInitResultList = new ArrayList<BeanInitResult>();
    private static final List<Statistics> statisticsList = new ArrayList<Statistics>();
    private static final Map<String, Set<String>> unusedJarMap = new HashMap<String, Set<String>>();
    private static final List<MethodInvokeDetail> methodInvokeDetailList = new ArrayList<MethodInvokeDetail>();

    public static void addBeanInitResult(BeanInitResult beanInitResult) {
        beanInitResultList.add(beanInitResult);
    }

    public static void addStatistics(Statistics statistics) {
        statisticsList.add(statistics);
    }

    public static void addUnusedJar(Map.Entry<ClassLoader, Set<String>> entry) {
        unusedJarMap.put(entry.getKey().toString(), entry.getValue());
    }

    public static void addMethodInvokeDetail(MethodInvokeDetail invokeDetail) {
        methodInvokeDetailList.add(invokeDetail);
    }

    public static List<BeanInitResult> getBeanInitResultList() {
        return beanInitResultList;
    }

    public static List<Statistics> getStatisticsList() {
        return statisticsList;
    }

    public static List<MethodInvokeDetail> getMethodInvokeDetailList() {
        return methodInvokeDetailList;
    }

    public static String toJSONString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("statisticsList", JSON.toJSONString(statisticsList));
        map.put("beanInitResultList", JSON.toJSONString(beanInitResultList));
        map.put("unusedJarMap", JSON.toJSONString(unusedJarMap));
        map.put("methodInvokeDetailList", JSON.toJSONString(StartupVO.calculateInvokeMetrics(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter}));
        return JSON.toJSONString(map);
    }

    public static void clearBeanInitResultList() {
        beanInitResultList.clear();
    }

    public static void clearStatisticsList() {
        statisticsList.clear();
    }

    public static void clearUnusedJarMap() {
        unusedJarMap.clear();
    }

    public static void clearMethodInvokeDetailList() {
        methodInvokeDetailList.clear();
    }

    private static List<MethodInvokeMetrics> calculateInvokeMetrics() {
        ArrayList<MethodInvokeMetrics> metricsList = new ArrayList<MethodInvokeMetrics>();
        try {
            Map<String, List<MethodInvokeDetail>> invokeMap = methodInvokeDetailList.stream().collect(Collectors.groupingBy(MethodInvokeDetail::getMethodQualifier));
            for (Map.Entry<String, List<MethodInvokeDetail>> entry : invokeMap.entrySet()) {
                long totalCost = entry.getValue().stream().mapToLong(MethodInvokeDetail::getDuration).sum();
                double averageCost = (double)totalCost / (1.0 * (double)entry.getValue().size());
                List<MethodInvokeDetail> top100 = entry.getValue().stream().sorted((o1, o2) -> (int)(o2.getDuration() - o1.getDuration())).limit(100L).collect(Collectors.toList());
                metricsList.add(new MethodInvokeMetrics(entry.getKey(), entry.getValue().size(), totalCost, averageCost, top100));
            }
        }
        catch (Exception ex) {
            List copies = methodInvokeDetailList.stream().map(invokeDetail -> new MethodInvokeDetail(invokeDetail.getMethodQualifier(), invokeDetail.getStartMillis(), invokeDetail.getDuration())).collect(Collectors.toList());
            logger.error("calculateInvokeMetrics error. methodInvokeDetailList: {}", (Object)JSON.toJSONString(copies, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter}), (Object)ex);
        }
        return metricsList;
    }
}

