/*
 * Decompiled with CFR 0.152.
 */
package com.gtihub.lipiridi.webflux;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.gtihub.lipiridi.webflux.JsonUtils;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.RequestPath;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class HttpLog {
    private URI uri;
    private RequestPath path;
    private HttpMethod method;
    private HttpStatusCode statusCode;
    private MultiValueMap<String, String> queryParams;
    private Map<String, List<String>> formData;
    private HttpHeaders requestHeaders;
    private String requestBody;
    private HttpHeaders responseHeaders;
    private String responseBody;

    public HttpLog() {
    }

    public HttpLog(URI uri, RequestPath path, HttpMethod method, HttpStatusCode statusCode, MultiValueMap<String, String> queryParams, Map<String, List<String>> formData, HttpHeaders requestHeaders, String requestBody, HttpHeaders responseHeaders, String responseBody) {
        this.uri = uri;
        this.path = path;
        this.method = method;
        this.queryParams = queryParams;
        this.formData = formData;
        this.requestHeaders = requestHeaders;
        this.requestBody = requestBody;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.statusCode = statusCode;
    }

    @JsonGetter(value="path")
    public String getJsonPath() {
        return this.path == null ? null : this.path.toString();
    }

    @JsonGetter(value="method")
    public String getJsonMethod() {
        return this.method == null ? null : this.method.toString();
    }

    @JsonGetter(value="statusCode")
    public Integer getJsonStatusCode() {
        return this.statusCode == null ? null : Integer.valueOf(this.statusCode.value());
    }

    @JsonGetter(value="requestBody")
    public Object getJsonRequestBody() {
        return this.getProcessedBody(this.requestBody);
    }

    @JsonGetter(value="responseBody")
    public Object getJsonResponseBody() {
        return this.getProcessedBody(this.responseBody);
    }

    @Nullable
    private Object getProcessedBody(String body) {
        if (!StringUtils.hasLength((String)body)) {
            return null;
        }
        JsonNode jsonNode = JsonUtils.getContainerJsonNode(body);
        return jsonNode == null ? body : jsonNode;
    }

    public URI getUri() {
        return this.uri;
    }

    public RequestPath getPath() {
        return this.path;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public MultiValueMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, List<String>> getFormData() {
        return this.formData;
    }

    public HttpHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setPath(RequestPath path) {
        this.path = path;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setQueryParams(MultiValueMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void setFormData(Map<String, List<String>> formData) {
        this.formData = formData;
    }

    public void setRequestHeaders(HttpHeaders requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setResponseHeaders(HttpHeaders responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public void setStatusCode(HttpStatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpLog httpLog = (HttpLog)o;
        if (!Objects.equals(this.uri, httpLog.uri)) {
            return false;
        }
        if (!Objects.equals(this.method, httpLog.method)) {
            return false;
        }
        return Objects.equals(this.statusCode, httpLog.statusCode);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.statusCode != null ? this.statusCode.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HttpLog{uri=" + String.valueOf(this.uri) + ", method=" + String.valueOf(this.method) + ", statusCode=" + String.valueOf(this.statusCode) + "}";
    }
}

