/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.dataflow;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.dataflow.DataflowElement;
import it.unive.lisa.analysis.dataflow.DefiniteDataflowDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class AvailableExpressions
implements DataflowElement<DefiniteDataflowDomain<AvailableExpressions>, AvailableExpressions> {
    private final ValueExpression expression;

    public AvailableExpressions() {
        this(null);
    }

    public AvailableExpressions(ValueExpression expression) {
        this.expression = expression;
    }

    public String toString() {
        return this.representation().toString();
    }

    public Collection<Identifier> getInvolvedIdentifiers() {
        return AvailableExpressions.getIdentifierOperands(this.expression);
    }

    private static Collection<Identifier> getIdentifierOperands(ValueExpression expression) {
        HashSet<Identifier> result = new HashSet<Identifier>();
        if (expression == null) {
            return result;
        }
        if (expression instanceof Identifier) {
            result.add((Identifier)expression);
        }
        if (expression instanceof UnaryExpression) {
            result.addAll(AvailableExpressions.getIdentifierOperands((ValueExpression)((UnaryExpression)expression).getExpression()));
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            result.addAll(AvailableExpressions.getIdentifierOperands((ValueExpression)binary.getLeft()));
            result.addAll(AvailableExpressions.getIdentifierOperands((ValueExpression)binary.getRight()));
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            result.addAll(AvailableExpressions.getIdentifierOperands((ValueExpression)ternary.getLeft()));
            result.addAll(AvailableExpressions.getIdentifierOperands((ValueExpression)ternary.getMiddle()));
            result.addAll(AvailableExpressions.getIdentifierOperands((ValueExpression)ternary.getRight()));
        }
        return result;
    }

    public Collection<AvailableExpressions> gen(Identifier id, ValueExpression expression, ProgramPoint pp, DefiniteDataflowDomain<AvailableExpressions> domain) {
        HashSet<AvailableExpressions> result = new HashSet<AvailableExpressions>();
        AvailableExpressions ae = new AvailableExpressions(expression);
        if (!ae.getInvolvedIdentifiers().contains(id) && AvailableExpressions.filter(expression)) {
            result.add(ae);
        }
        return result;
    }

    public Collection<AvailableExpressions> gen(ValueExpression expression, ProgramPoint pp, DefiniteDataflowDomain<AvailableExpressions> domain) {
        HashSet<AvailableExpressions> result = new HashSet<AvailableExpressions>();
        AvailableExpressions ae = new AvailableExpressions(expression);
        if (AvailableExpressions.filter(expression)) {
            result.add(ae);
        }
        return result;
    }

    private static boolean filter(ValueExpression expression) {
        if (expression instanceof Identifier) {
            return false;
        }
        if (expression instanceof Constant) {
            return false;
        }
        if (expression instanceof Skip) {
            return false;
        }
        return !(expression instanceof PushAny);
    }

    public Collection<AvailableExpressions> kill(Identifier id, ValueExpression expression, ProgramPoint pp, DefiniteDataflowDomain<AvailableExpressions> domain) {
        HashSet<AvailableExpressions> result = new HashSet<AvailableExpressions>();
        for (AvailableExpressions ae : domain.getDataflowElements()) {
            Collection<Identifier> ids = AvailableExpressions.getIdentifierOperands(ae.expression);
            if (!ids.contains(id)) continue;
            result.add(ae);
        }
        return result;
    }

    public Collection<AvailableExpressions> kill(ValueExpression expression, ProgramPoint pp, DefiniteDataflowDomain<AvailableExpressions> domain) {
        return Collections.emptyList();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvailableExpressions other = (AvailableExpressions)obj;
        return !(this.expression == null ? other.expression != null : !this.expression.equals((Object)other.expression));
    }

    public StructuredRepresentation representation() {
        return new StringRepresentation((Object)this.expression);
    }

    public AvailableExpressions pushScope(ScopeToken scope) throws SemanticException {
        return new AvailableExpressions((ValueExpression)this.expression.pushScope(scope));
    }

    public AvailableExpressions popScope(ScopeToken scope) throws SemanticException {
        return new AvailableExpressions((ValueExpression)this.expression.popScope(scope));
    }
}

