/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.dataflow;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.dataflow.DataflowElement;
import it.unive.lisa.analysis.dataflow.PossibleDataflowDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;

public class Liveness
implements DataflowElement<PossibleDataflowDomain<Liveness>, Liveness> {
    private final Identifier id;

    public Liveness() {
        this(null);
    }

    public Liveness(Identifier id) {
        this.id = id;
    }

    private static Collection<Identifier> getIdentifierOperands(ValueExpression expression) {
        HashSet<Identifier> result = new HashSet<Identifier>();
        if (expression == null) {
            return result;
        }
        if (expression instanceof Identifier) {
            result.add((Identifier)expression);
        }
        if (expression instanceof UnaryExpression) {
            result.addAll(Liveness.getIdentifierOperands((ValueExpression)((UnaryExpression)expression).getExpression()));
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            result.addAll(Liveness.getIdentifierOperands((ValueExpression)binary.getLeft()));
            result.addAll(Liveness.getIdentifierOperands((ValueExpression)binary.getRight()));
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            result.addAll(Liveness.getIdentifierOperands((ValueExpression)ternary.getLeft()));
            result.addAll(Liveness.getIdentifierOperands((ValueExpression)ternary.getMiddle()));
            result.addAll(Liveness.getIdentifierOperands((ValueExpression)ternary.getRight()));
        }
        return result;
    }

    public Liveness pushScope(ScopeToken token) throws SemanticException {
        return new Liveness((Identifier)this.id.pushScope(token));
    }

    public Liveness popScope(ScopeToken token) throws SemanticException {
        return new Liveness((Identifier)this.id.popScope(token));
    }

    public Collection<Identifier> getInvolvedIdentifiers() {
        return Collections.singleton(this.id);
    }

    public StructuredRepresentation representation() {
        return new StringRepresentation((Object)this.id);
    }

    public String toString() {
        return this.representation().toString();
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Liveness other = (Liveness)obj;
        return Objects.equals(this.id, other.id);
    }

    public Collection<Liveness> gen(Identifier id, ValueExpression expression, ProgramPoint pp, PossibleDataflowDomain<Liveness> domain) throws SemanticException {
        Collection<Identifier> ids = Liveness.getIdentifierOperands(expression);
        return ids.stream().map(Liveness::new).collect(Collectors.toSet());
    }

    public Collection<Liveness> gen(ValueExpression expression, ProgramPoint pp, PossibleDataflowDomain<Liveness> domain) throws SemanticException {
        Collection<Identifier> ids = Liveness.getIdentifierOperands(expression);
        return ids.stream().map(Liveness::new).collect(Collectors.toSet());
    }

    public Collection<Liveness> kill(Identifier id, ValueExpression expression, ProgramPoint pp, PossibleDataflowDomain<Liveness> domain) throws SemanticException {
        return Collections.singleton(new Liveness(id));
    }

    public Collection<Liveness> kill(ValueExpression expression, ProgramPoint pp, PossibleDataflowDomain<Liveness> domain) throws SemanticException {
        return Collections.emptySet();
    }
}

