/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.BaseHeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.heap.MemoryAllocation;
import it.unive.lisa.symbolic.value.HeapLocation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.ReferenceType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.representation.SetRepresentation;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;

public class TypeBasedHeap
implements BaseHeapDomain<TypeBasedHeap> {
    private static final TypeBasedHeap TOP = new TypeBasedHeap();
    private static final TypeBasedHeap BOTTOM = new TypeBasedHeap();
    private final Set<String> names;

    public TypeBasedHeap() {
        this(new HashSet<String>());
    }

    public TypeBasedHeap(Set<String> names) {
        this.names = names;
    }

    public Set<String> getKnownTypes() {
        return this.names;
    }

    public ExpressionSet rewrite(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (ExpressionSet)expression.accept((ExpressionVisitor)Rewriter.SINGLETON, new Object[]{pp, oracle});
    }

    public TypeBasedHeap assign(Identifier id, SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this;
    }

    public TypeBasedHeap assume(SymbolicExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return this;
    }

    public TypeBasedHeap forgetIdentifier(Identifier id) throws SemanticException {
        return this;
    }

    public TypeBasedHeap forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        return this;
    }

    public Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    public StructuredRepresentation representation() {
        return new SetRepresentation(this.names, StringRepresentation::new);
    }

    public TypeBasedHeap top() {
        return TOP;
    }

    public TypeBasedHeap bottom() {
        return BOTTOM;
    }

    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return Collections.emptyList();
    }

    public TypeBasedHeap mk(TypeBasedHeap reference) {
        return new TypeBasedHeap(reference.names);
    }

    public TypeBasedHeap mk(TypeBasedHeap reference, List<HeapSemanticOperation.HeapReplacement> replacements) {
        return new TypeBasedHeap(reference.names);
    }

    public TypeBasedHeap semanticsOf(HeapExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (expression instanceof AccessChild) {
            AccessChild access = (AccessChild)expression;
            TypeBasedHeap containerState = (TypeBasedHeap)this.smallStepSemantics(access.getContainer(), pp, oracle);
            return (TypeBasedHeap)containerState.smallStepSemantics(access.getChild(), pp, oracle);
        }
        if (expression instanceof MemoryAllocation) {
            HashSet<String> names = new HashSet<String>(this.names);
            for (Type type : oracle.getRuntimeTypesOf((SymbolicExpression)expression, pp, oracle)) {
                if (!type.isInMemoryType()) continue;
                names.add(type.toString());
            }
            return new TypeBasedHeap(names);
        }
        if (expression instanceof HeapReference) {
            return (TypeBasedHeap)this.smallStepSemantics(((HeapReference)expression).getExpression(), pp, oracle);
        }
        if (expression instanceof HeapDereference) {
            return (TypeBasedHeap)this.smallStepSemantics(((HeapDereference)expression).getExpression(), pp, oracle);
        }
        return this.top();
    }

    public TypeBasedHeap lubAux(TypeBasedHeap other) throws SemanticException {
        return new TypeBasedHeap((Set<String>)SetUtils.union(this.names, other.names));
    }

    public TypeBasedHeap glbAux(TypeBasedHeap other) throws SemanticException {
        return new TypeBasedHeap((Set<String>)SetUtils.intersection(this.names, other.names));
    }

    public boolean lessOrEqualAux(TypeBasedHeap other) throws SemanticException {
        return other.names.containsAll(this.names);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeBasedHeap other = (TypeBasedHeap)obj;
        return !(this.names == null ? other.names != null : !this.names.equals(other.names));
    }

    public boolean knowsIdentifier(Identifier id) {
        return false;
    }

    public Satisfiability alias(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        HashSet ltypes = new HashSet();
        for (SymbolicExpression e : this.rewrite(x, pp, oracle)) {
            ltypes.addAll(oracle.getRuntimeTypesOf(e, pp, oracle));
        }
        HashSet rtypes = new HashSet();
        for (SymbolicExpression e : this.rewrite(y, pp, oracle)) {
            rtypes.addAll(oracle.getRuntimeTypesOf(e, pp, oracle));
        }
        if (CollectionUtils.intersection(ltypes, rtypes).isEmpty()) {
            return Satisfiability.NOT_SATISFIED;
        }
        return Satisfiability.UNKNOWN;
    }

    public Satisfiability isReachableFrom(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    public static class Rewriter
    extends BaseHeapDomain.Rewriter {
        public static final Rewriter SINGLETON = new Rewriter();

        public ExpressionSet visit(AccessChild expression, ExpressionSet receiver, ExpressionSet child, Object ... params) throws SemanticException {
            HashSet<HeapLocation> result = new HashSet<HeapLocation>();
            ProgramPoint pp = (ProgramPoint)params[0];
            SemanticOracle oracle = (SemanticOracle)params[1];
            for (SymbolicExpression rec : receiver) {
                if (!((rec = this.removeTypingExpressions(rec)) instanceof MemoryPointer)) continue;
                MemoryPointer pid = (MemoryPointer)rec;
                for (Type t : oracle.getRuntimeTypesOf((SymbolicExpression)pid, pp, oracle)) {
                    if (!t.isPointerType()) continue;
                    Type inner = t.asPointerType().getInnerType();
                    HeapLocation e = new HeapLocation(inner, inner.toString(), true, expression.getCodeLocation());
                    result.add(e);
                }
            }
            return new ExpressionSet(result);
        }

        public ExpressionSet visit(MemoryAllocation expression, Object ... params) throws SemanticException {
            HashSet<HeapLocation> result = new HashSet<HeapLocation>();
            Type t = expression.getStaticType();
            if (t.isInMemoryType()) {
                HeapLocation e = new HeapLocation(t, t.toString(), true, expression.getCodeLocation());
                result.add(e);
            }
            return new ExpressionSet(result);
        }

        public ExpressionSet visit(HeapReference expression, ExpressionSet ref, Object ... params) throws SemanticException {
            HashSet<MemoryPointer> result = new HashSet<MemoryPointer>();
            ProgramPoint pp = (ProgramPoint)params[0];
            SemanticOracle oracle = (SemanticOracle)params[1];
            for (SymbolicExpression refExp : ref) {
                if (!((refExp = this.removeTypingExpressions(refExp)) instanceof HeapLocation)) continue;
                Set rt = oracle.getRuntimeTypesOf(refExp, pp, oracle);
                Type sup = Type.commonSupertype((Collection)rt, (Type)Untyped.INSTANCE);
                MemoryPointer e = new MemoryPointer((Type)new ReferenceType(sup), (HeapLocation)refExp, refExp.getCodeLocation());
                result.add(e);
            }
            return new ExpressionSet(result);
        }

        public ExpressionSet visit(HeapDereference expression, ExpressionSet deref, Object ... params) throws SemanticException {
            HashSet<MemoryPointer> result = new HashSet<MemoryPointer>();
            ProgramPoint pp = (ProgramPoint)params[0];
            SemanticOracle oracle = (SemanticOracle)params[1];
            for (SymbolicExpression derefExp : deref) {
                if (!((derefExp = this.removeTypingExpressions(derefExp)) instanceof Variable)) continue;
                Variable var = (Variable)derefExp;
                for (Type t : oracle.getRuntimeTypesOf((SymbolicExpression)var, pp, oracle)) {
                    if (!t.isPointerType()) continue;
                    Type inner = t.asPointerType().getInnerType();
                    HeapLocation loc = new HeapLocation(inner, inner.toString(), true, var.getCodeLocation());
                    MemoryPointer pointer = new MemoryPointer(t, loc, var.getCodeLocation());
                    result.add(pointer);
                }
            }
            return new ExpressionSet(result);
        }
    }
}

