/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap.pointbased;

import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.HeapLocation;
import it.unive.lisa.type.Type;

public abstract class AllocationSite
extends HeapLocation {
    private final String locationName;
    private final String field;

    public AllocationSite(Type staticType, String locationName, CodeLocation location) {
        this(staticType, locationName, false, location);
    }

    public AllocationSite(Type staticType, String locationName, boolean isWeak, CodeLocation location) {
        this(staticType, locationName, (String)null, isWeak, location);
    }

    public AllocationSite(Type staticType, String locationName, SymbolicExpression field, CodeLocation location) {
        this(staticType, locationName, field == null ? null : field.toString(), false, location);
    }

    public AllocationSite(Type staticType, String locationName, SymbolicExpression field, boolean isWeak, CodeLocation location) {
        this(staticType, locationName, field == null ? null : field.toString(), isWeak, location);
    }

    public AllocationSite(Type staticType, String locationName, String field, CodeLocation location) {
        this(staticType, locationName, field, false, location);
    }

    public AllocationSite(Type staticType, String locationName, String field, boolean isWeak, CodeLocation location) {
        super(staticType, "pp@" + locationName + (String)(field == null ? "" : "[" + field + "]"), isWeak, location);
        this.locationName = locationName;
        this.field = field != null ? field.toString() : null;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public String getField() {
        return this.field;
    }

    public abstract AllocationSite toWeak();

    public abstract AllocationSite withField(SymbolicExpression var1);

    public abstract AllocationSite withType(Type var1);
}

