/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap.pointbased;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.BaseHeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.heap.pointbased.AllocationSite;
import it.unive.lisa.analysis.heap.pointbased.AllocationSites;
import it.unive.lisa.analysis.heap.pointbased.HeapAllocationSite;
import it.unive.lisa.analysis.heap.pointbased.StackAllocationSite;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.HeapDereference;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.heap.HeapReference;
import it.unive.lisa.symbolic.heap.MemoryAllocation;
import it.unive.lisa.symbolic.value.HeapLocation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.Variable;
import it.unive.lisa.type.ReferenceType;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.workset.VisitOnceFIFOWorkingSet;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AllocationSiteBasedAnalysis<A extends AllocationSiteBasedAnalysis<A>>
implements BaseHeapDomain<A> {
    public final HeapEnvironment<AllocationSites> heapEnv;
    public final List<HeapSemanticOperation.HeapReplacement> replacements;

    protected AllocationSiteBasedAnalysis() {
        this((HeapEnvironment<AllocationSites>)new HeapEnvironment((NonRelationalHeapDomain)new AllocationSites()));
    }

    public AllocationSiteBasedAnalysis(HeapEnvironment<AllocationSites> heapEnv) {
        this(heapEnv, Collections.emptyList());
    }

    public AllocationSiteBasedAnalysis(HeapEnvironment<AllocationSites> heapEnv, List<HeapSemanticOperation.HeapReplacement> replacements) {
        this.heapEnv = heapEnv;
        this.replacements = replacements.isEmpty() ? Collections.emptyList() : replacements;
    }

    protected abstract A mk(A var1, HeapEnvironment<AllocationSites> var2);

    public A assign(Identifier id, SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        AllocationSiteBasedAnalysis sss = (AllocationSiteBasedAnalysis)this.smallStepSemantics(expression, pp, oracle);
        AllocationSiteBasedAnalysis result = (AllocationSiteBasedAnalysis)this.bottom();
        LinkedList<HeapSemanticOperation.HeapReplacement> replacements = new LinkedList<HeapSemanticOperation.HeapReplacement>();
        ExpressionSet rhsExps = expression.mightNeedRewriting() ? this.rewrite(expression, pp, oracle) : new ExpressionSet(expression);
        for (SymbolicExpression rhs : rhsExps) {
            if (rhs instanceof MemoryPointer) {
                HeapLocation rhs_ref = ((MemoryPointer)rhs).getReferencedLocation();
                if (id instanceof MemoryPointer) {
                    HeapLocation lhs_ref = ((MemoryPointer)id).getReferencedLocation();
                    HeapEnvironment heap = (HeapEnvironment)sss.heapEnv.assign((Identifier)lhs_ref, (SymbolicExpression)rhs_ref, pp, oracle);
                    result = (AllocationSiteBasedAnalysis)result.lub((BaseLattice)this.mk(sss, (HeapEnvironment<AllocationSites>)heap));
                    continue;
                }
                if (rhs_ref instanceof StackAllocationSite && !this.getAllocatedAt(((StackAllocationSite)rhs_ref).getLocationName()).isEmpty()) {
                    result = (AllocationSiteBasedAnalysis)result.lub((BaseLattice)sss.shallowCopy(id, (StackAllocationSite)rhs_ref, replacements, pp, oracle));
                    continue;
                }
                HeapEnvironment heap = (HeapEnvironment)sss.heapEnv.assign(id, (SymbolicExpression)rhs_ref, pp, oracle);
                result = (AllocationSiteBasedAnalysis)result.lub((BaseLattice)this.mk(sss, (HeapEnvironment<AllocationSites>)heap));
                continue;
            }
            result = (AllocationSiteBasedAnalysis)result.lub((BaseLattice)sss);
        }
        return (A)((AllocationSiteBasedAnalysis)this.mk(result, replacements));
    }

    protected Set<AllocationSite> getAllocatedAt(String location) {
        HashSet<AllocationSite> sites = new HashSet<AllocationSite>();
        for (AllocationSites set : this.heapEnv.getValues()) {
            Iterator<AllocationSite> iterator = set.iterator();
            while (iterator.hasNext()) {
                AllocationSite site = iterator.next();
                if (!site.getLocationName().equals(location)) continue;
                sites.add(site);
            }
        }
        return sites;
    }

    public A shallowCopy(Identifier id, StackAllocationSite site, List<HeapSemanticOperation.HeapReplacement> replacements, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        StackAllocationSite clone = new StackAllocationSite(site.getStaticType(), id.getCodeLocation().toString(), site.isWeak(), id.getCodeLocation());
        HeapEnvironment tmp = (HeapEnvironment)this.heapEnv.assign(id, (SymbolicExpression)clone, pp, oracle);
        HeapSemanticOperation.HeapReplacement replacement = new HeapSemanticOperation.HeapReplacement();
        replacement.addSource((Identifier)site);
        replacement.addTarget((Identifier)clone);
        replacement.addTarget((Identifier)site);
        replacements.add(replacement);
        return (A)this.mk(this, (HeapEnvironment<AllocationSites>)tmp);
    }

    public A assume(SymbolicExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return (A)((AllocationSiteBasedAnalysis)this.smallStepSemantics(expression, src, oracle));
    }

    public Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    public StructuredRepresentation representation() {
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        return this.heapEnv.representation();
    }

    public boolean isTop() {
        return this.heapEnv.isTop();
    }

    public boolean isBottom() {
        return this.heapEnv.isBottom();
    }

    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return this.replacements;
    }

    public boolean lessOrEqualAux(A other) throws SemanticException {
        return this.heapEnv.lessOrEqual(((AllocationSiteBasedAnalysis)other).heapEnv);
    }

    public int hashCode() {
        return Objects.hash(this.heapEnv, this.replacements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllocationSiteBasedAnalysis other = (AllocationSiteBasedAnalysis)obj;
        return Objects.equals(this.heapEnv, other.heapEnv) && Objects.equals(this.replacements, other.replacements);
    }

    public A semanticsOf(HeapExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (A)this;
    }

    public ExpressionSet rewrite(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (ExpressionSet)expression.accept((ExpressionVisitor)new Rewriter(), new Object[]{pp, oracle});
    }

    public boolean knowsIdentifier(Identifier id) {
        return this.heapEnv.knowsIdentifier(id) || id instanceof AllocationSite && this.heapEnv.getValues().stream().anyMatch(as -> as.contains((Object)((AllocationSite)id)));
    }

    public Satisfiability alias(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        boolean atLeastOne = false;
        boolean all = true;
        ExpressionSet xrs = this.rewrite(x, pp, oracle);
        ExpressionSet yrs = this.rewrite(y, pp, oracle);
        for (SymbolicExpression xr : xrs) {
            for (SymbolicExpression yr : yrs) {
                if (xr instanceof MemoryPointer && yr instanceof MemoryPointer) {
                    HeapLocation yloc;
                    HeapLocation xloc = ((MemoryPointer)xr).getReferencedLocation();
                    if (xloc.equals((Object)(yloc = ((MemoryPointer)yr).getReferencedLocation()))) {
                        atLeastOne = true;
                        all &= true;
                        continue;
                    }
                    all = false;
                    continue;
                }
                all = false;
            }
        }
        if (all && atLeastOne) {
            return Satisfiability.SATISFIED;
        }
        if (atLeastOne) {
            return Satisfiability.UNKNOWN;
        }
        return Satisfiability.NOT_SATISFIED;
    }

    public Satisfiability isReachableFrom(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        VisitOnceFIFOWorkingSet ws = VisitOnceFIFOWorkingSet.mk();
        this.rewrite(x, pp, oracle).elements().forEach(arg_0 -> ((WorkingSet)ws).push(arg_0));
        ExpressionSet targets = this.rewrite(y, pp, oracle);
        while (!ws.isEmpty()) {
            SymbolicExpression current = (SymbolicExpression)ws.peek();
            if (targets.elements().contains(current)) {
                return Satisfiability.SATISFIED;
            }
            if (current instanceof Identifier && this.heapEnv.knowsIdentifier((Identifier)current)) {
                ((AllocationSites)this.heapEnv.getState((Object)((Identifier)current))).elements().forEach(arg_0 -> ((WorkingSet)ws).push(arg_0));
                continue;
            }
            this.rewrite(current, pp, oracle).elements().forEach(arg_0 -> ((WorkingSet)ws).push(arg_0));
        }
        return Satisfiability.NOT_SATISFIED;
    }

    public class Rewriter
    extends BaseHeapDomain.Rewriter {
        public ExpressionSet visit(AccessChild expression, ExpressionSet receiver, ExpressionSet child, Object ... params) throws SemanticException {
            HashSet<AllocationSite> result = new HashSet<AllocationSite>();
            for (SymbolicExpression rec : receiver) {
                if ((rec = this.removeTypingExpressions(rec)) instanceof MemoryPointer) {
                    MemoryPointer pid = (MemoryPointer)rec;
                    AllocationSite site = (AllocationSite)pid.getReferencedLocation();
                    AllocationSite e = site instanceof StackAllocationSite ? new StackAllocationSite(expression.getStaticType(), site.getLocationName(), true, expression.getCodeLocation()) : new HeapAllocationSite(expression.getStaticType(), site.getLocationName(), true, expression.getCodeLocation());
                    for (SymbolicExpression f : child) {
                        if (!(f instanceof Identifier)) continue;
                        for (Annotation ann : e.getAnnotations()) {
                            e.addAnnotation(ann);
                        }
                    }
                    result.add(e);
                    continue;
                }
                if (!(rec instanceof AllocationSite)) continue;
                result.add(((AllocationSite)rec).withType(expression.getStaticType()));
            }
            return new ExpressionSet(result);
        }

        public ExpressionSet visit(MemoryAllocation expression, Object ... params) throws SemanticException {
            AllocationSite id = expression.isStackAllocation() ? new StackAllocationSite(expression.getStaticType(), expression.getCodeLocation().getCodeLocation(), true, expression.getCodeLocation()) : new HeapAllocationSite(expression.getStaticType(), expression.getCodeLocation().getCodeLocation(), true, expression.getCodeLocation());
            for (Annotation ann : expression.getAnnotations()) {
                id.addAnnotation(ann);
            }
            return new ExpressionSet((SymbolicExpression)id);
        }

        public ExpressionSet visit(HeapReference expression, ExpressionSet arg, Object ... params) throws SemanticException {
            HashSet<Object> result = new HashSet<Object>();
            for (SymbolicExpression loc : arg) {
                if ((loc = this.removeTypingExpressions(loc)) instanceof AllocationSite) {
                    AllocationSite allocSite = (AllocationSite)loc;
                    MemoryPointer e = new MemoryPointer((Type)new ReferenceType(loc.getStaticType()), (HeapLocation)allocSite, loc.getCodeLocation());
                    for (Annotation ann : allocSite.getAnnotations()) {
                        e.addAnnotation(ann);
                    }
                    result.add(e);
                    continue;
                }
                result.add(loc);
            }
            return new ExpressionSet(result);
        }

        public ExpressionSet visit(HeapDereference expression, ExpressionSet arg, Object ... params) throws SemanticException {
            HashSet<Object> result = new HashSet<Object>();
            for (SymbolicExpression ref : arg) {
                if ((ref = this.removeTypingExpressions(ref)) instanceof MemoryPointer) {
                    result.add(((MemoryPointer)ref).getReferencedLocation());
                    continue;
                }
                if (ref instanceof Identifier) {
                    AllocationSite site;
                    Identifier id = (Identifier)ref;
                    if (AllocationSiteBasedAnalysis.this.heapEnv.getKeys().contains(id)) {
                        result.addAll(this.resolveIdentifier(id));
                        continue;
                    }
                    if (!(id instanceof Variable)) continue;
                    CodeLocation loc = expression.getCodeLocation();
                    if (id.getStaticType().isPointerType()) {
                        site = new HeapAllocationSite(id.getStaticType(), "unknown@" + id.getName(), true, loc);
                    } else if (id.getStaticType().isInMemoryType() || id.getStaticType().isUntyped()) {
                        site = new StackAllocationSite(id.getStaticType(), "unknown@" + id.getName(), true, loc);
                    } else {
                        throw new SemanticException("The type " + id.getStaticType() + " cannot be allocated by point-based heap domains");
                    }
                    for (Annotation ann : id.getAnnotations()) {
                        site.addAnnotation(ann);
                    }
                    result.add((Object)site);
                    continue;
                }
                result.add(ref);
            }
            return new ExpressionSet(result);
        }

        public ExpressionSet visit(Identifier expression, Object ... params) throws SemanticException {
            if (!(expression instanceof MemoryPointer) && AllocationSiteBasedAnalysis.this.heapEnv.getKeys().contains(expression)) {
                return new ExpressionSet(this.resolveIdentifier(expression));
            }
            return new ExpressionSet((SymbolicExpression)expression);
        }

        private Set<SymbolicExpression> resolveIdentifier(Identifier v) {
            HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
            Iterator<AllocationSite> iterator = ((AllocationSites)AllocationSiteBasedAnalysis.this.heapEnv.getState((Object)v)).iterator();
            while (iterator.hasNext()) {
                AllocationSite site = iterator.next();
                MemoryPointer e = new MemoryPointer((Type)new ReferenceType(site.getStaticType()), (HeapLocation)site, site.getCodeLocation());
                result.add((SymbolicExpression)e);
            }
            return result;
        }

        public ExpressionSet visit(PushAny expression, Object ... params) throws SemanticException {
            if (expression.getStaticType().isPointerType()) {
                Type inner = expression.getStaticType().asPointerType().getInnerType();
                CodeLocation loc = expression.getCodeLocation();
                HeapAllocationSite site = new HeapAllocationSite(inner, "unknown@" + loc.getCodeLocation(), false, loc);
                return new ExpressionSet((SymbolicExpression)new MemoryPointer(expression.getStaticType(), (HeapLocation)site, loc));
            }
            if (expression.getStaticType().isInMemoryType()) {
                Type type = expression.getStaticType();
                CodeLocation loc = expression.getCodeLocation();
                StackAllocationSite site = new StackAllocationSite(type, "unknown@" + loc.getCodeLocation(), false, loc);
                return new ExpressionSet((SymbolicExpression)new MemoryPointer(expression.getStaticType(), (HeapLocation)site, loc));
            }
            return new ExpressionSet((SymbolicExpression)expression);
        }
    }
}

