/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap.pointbased;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.heap.pointbased.AllocationSite;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.lattices.SetLattice;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class AllocationSites
extends SetLattice<AllocationSites, AllocationSite>
implements NonRelationalHeapDomain<AllocationSites> {
    private static final AllocationSites TOP = new AllocationSites(new HashSet<AllocationSite>(), true);
    private static final AllocationSites BOTTOM = new AllocationSites(new HashSet<AllocationSite>(), false);

    public AllocationSites() {
        this(new HashSet<AllocationSite>(), true);
    }

    AllocationSites(Set<AllocationSite> set, boolean isTop) {
        super(set, isTop);
    }

    public AllocationSites top() {
        return TOP;
    }

    public AllocationSites bottom() {
        return BOTTOM;
    }

    public AllocationSites mk(Set<AllocationSite> set) {
        return new AllocationSites(set, false);
    }

    public Iterator<AllocationSite> iterator() {
        return this.elements.iterator();
    }

    public AllocationSites eval(SymbolicExpression expression, HeapEnvironment<AllocationSites> environment, ProgramPoint pp, SemanticOracle oracle) {
        return new AllocationSites(Collections.singleton((AllocationSite)expression), false);
    }

    public Satisfiability satisfies(SymbolicExpression expression, HeapEnvironment<AllocationSites> environment, ProgramPoint pp, SemanticOracle oracle) {
        return Satisfiability.UNKNOWN;
    }

    public List<HeapSemanticOperation.HeapReplacement> getSubstitution() {
        return Collections.emptyList();
    }

    public AllocationSites lubAux(AllocationSites other) throws SemanticException {
        HashMap lub = new HashMap();
        this.elements.stream().filter(Identifier::isWeak).forEach(e -> lub.put(e.getName(), e));
        other.elements.stream().filter(Identifier::isWeak).forEach(e -> lub.put(e.getName(), e));
        this.elements.stream().filter(Predicate.not(Identifier::isWeak)).filter(e -> !lub.containsKey(e.getName())).forEach(e -> lub.put(e.getName(), e));
        other.elements.stream().filter(Predicate.not(Identifier::isWeak)).filter(e -> !lub.containsKey(e.getName())).forEach(e -> lub.put(e.getName(), e));
        return new AllocationSites(new HashSet<AllocationSite>(lub.values()), false);
    }

    public boolean canProcess(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) {
        return expression instanceof AllocationSite;
    }

    public HeapEnvironment<AllocationSites> assume(HeapEnvironment<AllocationSites> environment, SymbolicExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return environment;
    }

    public ExpressionSet rewrite(SymbolicExpression expression, HeapEnvironment<AllocationSites> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new ExpressionSet();
    }

    public AllocationSites applyReplacement(HeapSemanticOperation.HeapReplacement r, ProgramPoint pp) throws SemanticException {
        if (this.isTop() || this.isBottom() || r.getSources().isEmpty()) {
            return this;
        }
        HashSet<AllocationSite> copy = new HashSet<AllocationSite>(this.elements);
        if (copy.removeAll(r.getSources())) {
            r.getTargets().stream().filter(AllocationSite.class::isInstance).map(AllocationSite.class::cast).forEach(copy::add);
            return new AllocationSites(copy, false);
        }
        return this;
    }

    public AllocationSites unknownVariable(Identifier id) {
        return this.bottom();
    }

    public Satisfiability alias(SymbolicExpression x, SymbolicExpression y, HeapEnvironment<AllocationSites> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    public Satisfiability isReachableFrom(SymbolicExpression x, SymbolicExpression y, HeapEnvironment<AllocationSites> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }
}

