/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap.pointbased;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.heap.pointbased.AllocationSite;
import it.unive.lisa.analysis.heap.pointbased.AllocationSiteBasedAnalysis;
import it.unive.lisa.analysis.heap.pointbased.AllocationSites;
import it.unive.lisa.analysis.heap.pointbased.HeapAllocationSite;
import it.unive.lisa.analysis.heap.pointbased.StackAllocationSite;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.GenericMapLattice;
import it.unive.lisa.analysis.nonrelational.heap.HeapEnvironment;
import it.unive.lisa.analysis.nonrelational.heap.NonRelationalHeapDomain;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.AccessChild;
import it.unive.lisa.symbolic.heap.MemoryAllocation;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.MemoryPointer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class FieldSensitivePointBasedHeap
extends AllocationSiteBasedAnalysis<FieldSensitivePointBasedHeap> {
    public final GenericMapLattice<AllocationSite, ExpressionSet> fields;

    public FieldSensitivePointBasedHeap() {
        this.fields = new GenericMapLattice((Lattice)new ExpressionSet()).top();
    }

    public FieldSensitivePointBasedHeap(HeapEnvironment<AllocationSites> heapEnv) {
        this(heapEnv, (GenericMapLattice<AllocationSite, ExpressionSet>)new GenericMapLattice((Lattice)new ExpressionSet()).top());
    }

    public FieldSensitivePointBasedHeap(HeapEnvironment<AllocationSites> heapEnv, GenericMapLattice<AllocationSite, ExpressionSet> fields) {
        super(heapEnv);
        this.fields = fields;
    }

    public FieldSensitivePointBasedHeap(HeapEnvironment<AllocationSites> heapEnv, List<HeapSemanticOperation.HeapReplacement> replacements, GenericMapLattice<AllocationSite, ExpressionSet> fields) {
        super(heapEnv, replacements);
        this.fields = fields;
    }

    public FieldSensitivePointBasedHeap mk(FieldSensitivePointBasedHeap reference) {
        return reference;
    }

    public FieldSensitivePointBasedHeap mk(FieldSensitivePointBasedHeap reference, List<HeapSemanticOperation.HeapReplacement> replacements) {
        return new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)reference.heapEnv, replacements, reference.fields);
    }

    @Override
    protected FieldSensitivePointBasedHeap mk(FieldSensitivePointBasedHeap reference, HeapEnvironment<AllocationSites> heapEnv) {
        return new FieldSensitivePointBasedHeap(heapEnv, reference.replacements, reference.fields);
    }

    @Override
    public FieldSensitivePointBasedHeap shallowCopy(Identifier id, StackAllocationSite site, List<HeapSemanticOperation.HeapReplacement> replacements, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        StackAllocationSite clone = new StackAllocationSite(site.getStaticType(), id.getCodeLocation().toString(), site.isWeak(), id.getCodeLocation());
        HeapEnvironment heap = (HeapEnvironment)this.heapEnv.assign(id, (SymbolicExpression)clone, pp, oracle);
        HashMap<AllocationSite, ExpressionSet> newFields = new HashMap<AllocationSite, ExpressionSet>(this.fields.getMap());
        if (this.fields.getKeys().contains((Object)site)) {
            for (SymbolicExpression field : (ExpressionSet)this.fields.getState((Object)site)) {
                StackAllocationSite cloneWithField = new StackAllocationSite(field.getStaticType(), id.getCodeLocation().toString(), field, site.isWeak(), id.getCodeLocation());
                StackAllocationSite star_yWithField = new StackAllocationSite(field.getStaticType(), site.getCodeLocation().toString(), field, site.isWeak(), site.getCodeLocation());
                HeapSemanticOperation.HeapReplacement replacement = new HeapSemanticOperation.HeapReplacement();
                replacement.addSource((Identifier)star_yWithField);
                replacement.addTarget((Identifier)cloneWithField);
                replacement.addTarget((Identifier)star_yWithField);
                this.addField(clone, field, newFields);
                replacements.add(replacement);
            }
        }
        HeapSemanticOperation.HeapReplacement replacement = new HeapSemanticOperation.HeapReplacement();
        replacement.addSource((Identifier)site);
        replacement.addTarget((Identifier)clone);
        replacement.addTarget((Identifier)site);
        replacements.add(replacement);
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)heap, (GenericMapLattice<AllocationSite, ExpressionSet>)new GenericMapLattice((Lattice)((ExpressionSet)this.fields.lattice), newFields)));
    }

    public FieldSensitivePointBasedHeap smallStepSemantics(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (expression instanceof AccessChild) {
            FieldSensitivePointBasedHeap sss = (FieldSensitivePointBasedHeap)super.smallStepSemantics(expression, pp, oracle);
            AccessChild accessChild = (AccessChild)expression;
            HashMap<AllocationSite, ExpressionSet> mapping = new HashMap<AllocationSite, ExpressionSet>(sss.fields.getMap());
            ExpressionSet exprs = accessChild.getContainer().mightNeedRewriting() ? this.rewrite(accessChild.getContainer(), pp, oracle) : new ExpressionSet(accessChild.getContainer());
            for (SymbolicExpression rec : exprs) {
                ExpressionSet childs;
                AllocationSite site;
                if (rec instanceof MemoryPointer) {
                    site = (AllocationSite)((MemoryPointer)rec).getReferencedLocation();
                    childs = this.rewrite(accessChild.getChild(), pp, oracle);
                    for (SymbolicExpression child : childs) {
                        this.addField(site, child, mapping);
                    }
                    continue;
                }
                if (!(rec instanceof AllocationSite)) continue;
                site = (AllocationSite)rec;
                childs = this.rewrite(accessChild.getChild(), pp, oracle);
                for (SymbolicExpression child : childs) {
                    this.addField(site, child, mapping);
                }
            }
            return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)this.heapEnv, this.heapEnv.getSubstitution(), (GenericMapLattice<AllocationSite, ExpressionSet>)new GenericMapLattice((Lattice)((ExpressionSet)this.fields.lattice), mapping)));
        }
        if (expression instanceof MemoryAllocation) {
            String loc = expression.getCodeLocation().getCodeLocation();
            Set<AllocationSite> alreadyAllocated = this.getAllocatedAt(loc);
            FieldSensitivePointBasedHeap sss = (FieldSensitivePointBasedHeap)super.smallStepSemantics(expression, pp, oracle);
            HeapEnvironment env = sss.heapEnv;
            if (!alreadyAllocated.isEmpty()) {
                LinkedList<HeapSemanticOperation.HeapReplacement> replacements = new LinkedList<HeapSemanticOperation.HeapReplacement>();
                for (AllocationSite site : alreadyAllocated) {
                    if (!site.isWeak()) {
                        HeapSemanticOperation.HeapReplacement replacement = new HeapSemanticOperation.HeapReplacement();
                        replacement.addSource((Identifier)site);
                        replacement.addTarget((Identifier)site.toWeak());
                        replacements.add(replacement);
                    }
                    if (!this.fields.getKeys().contains((Object)site)) continue;
                    for (SymbolicExpression field : (ExpressionSet)this.fields.getState((Object)site)) {
                        AllocationSite withField = site.withField(field);
                        if (withField.isWeak()) continue;
                        HeapSemanticOperation.HeapReplacement replacement = new HeapSemanticOperation.HeapReplacement();
                        replacement.addSource((Identifier)withField);
                        replacement.addTarget((Identifier)withField.toWeak());
                        replacements.add(replacement);
                    }
                }
                if (!replacements.isEmpty()) {
                    HashMap<Identifier, AllocationSites> map = new HashMap<Identifier, AllocationSites>(env.getMap());
                    for (Map.Entry entry : env) {
                        Identifier id = (Identifier)entry.getKey();
                        AllocationSites sites = (AllocationSites)((Object)entry.getValue());
                        for (HeapSemanticOperation.HeapReplacement repl : replacements) {
                            if (repl.getSources().contains(id)) {
                                id = (Identifier)repl.getTargets().iterator().next();
                            }
                            sites = sites.applyReplacement(repl, pp);
                        }
                        map.put(id, sites);
                    }
                    env = new HeapEnvironment((NonRelationalHeapDomain)((AllocationSites)env.lattice), map);
                }
                return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)env, replacements, this.fields));
            }
        }
        FieldSensitivePointBasedHeap sss = (FieldSensitivePointBasedHeap)super.smallStepSemantics(expression, pp, oracle);
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)sss.heapEnv, this.fields));
    }

    private void addField(AllocationSite site, SymbolicExpression field, Map<AllocationSite, ExpressionSet> mapping) {
        HashSet<SymbolicExpression> tmp = new HashSet<SymbolicExpression>(mapping.getOrDefault((Object)site, new ExpressionSet()).elements());
        tmp.add(field);
        mapping.put(site, new ExpressionSet(tmp));
    }

    @Override
    public ExpressionSet rewrite(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return (ExpressionSet)expression.accept((ExpressionVisitor)new Rewriter(), new Object[]{pp, oracle});
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.fields);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSensitivePointBasedHeap other = (FieldSensitivePointBasedHeap)obj;
        return Objects.equals(this.fields, other.fields);
    }

    public FieldSensitivePointBasedHeap popScope(ScopeToken scope) throws SemanticException {
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)((HeapEnvironment)this.heapEnv.popScope(scope)), this.fields));
    }

    public FieldSensitivePointBasedHeap pushScope(ScopeToken scope) throws SemanticException {
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)((HeapEnvironment)this.heapEnv.pushScope(scope)), this.fields));
    }

    public FieldSensitivePointBasedHeap top() {
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)this.heapEnv.top(), Collections.emptyList(), (GenericMapLattice<AllocationSite, ExpressionSet>)this.fields.top()));
    }

    @Override
    public boolean isTop() {
        return this.heapEnv.isTop() && this.fields.isTop();
    }

    public FieldSensitivePointBasedHeap bottom() {
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)this.heapEnv.bottom(), Collections.emptyList(), (GenericMapLattice<AllocationSite, ExpressionSet>)this.fields.bottom()));
    }

    @Override
    public boolean isBottom() {
        return this.heapEnv.isBottom() && this.fields.isBottom();
    }

    public FieldSensitivePointBasedHeap lubAux(FieldSensitivePointBasedHeap other) throws SemanticException {
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)((HeapEnvironment)this.heapEnv.lub((BaseLattice)other.heapEnv)), Collections.emptyList(), (GenericMapLattice<AllocationSite, ExpressionSet>)((GenericMapLattice)this.fields.lub(other.fields))));
    }

    public FieldSensitivePointBasedHeap glbAux(FieldSensitivePointBasedHeap other) throws SemanticException {
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)((HeapEnvironment)this.heapEnv.glb((BaseLattice)other.heapEnv)), Collections.emptyList(), (GenericMapLattice<AllocationSite, ExpressionSet>)((GenericMapLattice)this.fields.glb(other.fields))));
    }

    @Override
    public boolean lessOrEqualAux(FieldSensitivePointBasedHeap other) throws SemanticException {
        return this.heapEnv.lessOrEqual((BaseLattice)other.heapEnv) && this.fields.lessOrEqual(other.fields);
    }

    public FieldSensitivePointBasedHeap forgetIdentifier(Identifier id) throws SemanticException {
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)((HeapEnvironment)this.heapEnv.forgetIdentifier(id)), this.fields));
    }

    public FieldSensitivePointBasedHeap forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        return this.mk(new FieldSensitivePointBasedHeap((HeapEnvironment<AllocationSites>)((HeapEnvironment)this.heapEnv.forgetIdentifiersIf(test)), this.fields));
    }

    public class Rewriter
    extends AllocationSiteBasedAnalysis.Rewriter {
        public Rewriter() {
            super(FieldSensitivePointBasedHeap.this);
        }

        @Override
        public ExpressionSet visit(AccessChild expression, ExpressionSet receiver, ExpressionSet child, Object ... params) throws SemanticException {
            HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
            for (SymbolicExpression rec : receiver) {
                AllocationSite site;
                if ((rec = this.removeTypingExpressions(rec)) instanceof MemoryPointer) {
                    site = (AllocationSite)((MemoryPointer)rec).getReferencedLocation();
                    this.populate(expression, child, result, site);
                    continue;
                }
                if (!(rec instanceof AllocationSite)) continue;
                site = (AllocationSite)rec;
                this.populate(expression, child, result, site);
            }
            return new ExpressionSet(result);
        }

        private void populate(AccessChild expression, ExpressionSet child, Set<SymbolicExpression> result, AllocationSite site) {
            for (SymbolicExpression target : child) {
                AllocationSite e = site instanceof StackAllocationSite ? new StackAllocationSite(expression.getStaticType(), site.getLocationName(), target, site.isWeak(), site.getCodeLocation()) : new HeapAllocationSite(expression.getStaticType(), site.getLocationName(), target, site.isWeak(), site.getCodeLocation());
                if (target instanceof Identifier) {
                    for (Annotation ann : e.getAnnotations()) {
                        e.addAnnotation(ann);
                    }
                }
                result.add((SymbolicExpression)e);
            }
        }

        @Override
        public ExpressionSet visit(MemoryAllocation expression, Object ... params) throws SemanticException {
            String pp = expression.getCodeLocation().getCodeLocation();
            boolean weak = !FieldSensitivePointBasedHeap.this.getAllocatedAt(pp).isEmpty();
            AllocationSite e = expression.isStackAllocation() ? new StackAllocationSite(expression.getStaticType(), pp, weak, expression.getCodeLocation()) : new HeapAllocationSite(expression.getStaticType(), pp, weak, expression.getCodeLocation());
            for (Annotation ann : expression.getAnnotations()) {
                e.getAnnotations().addAnnotation(ann);
            }
            return new ExpressionSet((SymbolicExpression)e);
        }
    }
}

