/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonInterference;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.nonrelational.inference.BaseInferredValue;
import it.unive.lisa.analysis.nonrelational.inference.InferenceSystem;
import it.unive.lisa.analysis.nonrelational.inference.InferredValue;
import it.unive.lisa.program.annotations.Annotation;
import it.unive.lisa.program.annotations.Annotations;
import it.unive.lisa.program.annotations.matcher.AnnotationMatcher;
import it.unive.lisa.program.annotations.matcher.BasicAnnotationMatcher;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.IdentityHashMap;
import java.util.Map;

public class NonInterference
implements BaseInferredValue<NonInterference> {
    public static final Annotation LOW_CONF_ANNOTATION = new Annotation("lisa.ni.LowConfidentiality");
    public static final AnnotationMatcher LOW_CONF_MATCHER = new BasicAnnotationMatcher(LOW_CONF_ANNOTATION);
    public static final Annotation HIGH_INT_ANNOTATION = new Annotation("lisa.ni.HighIntegrity");
    public static final AnnotationMatcher HIGH_INT_MATCHER = new BasicAnnotationMatcher(HIGH_INT_ANNOTATION);
    public static final byte NI_BOTTOM = 0;
    public static final byte NI_LOW = 1;
    public static final byte NI_HIGH = 2;
    private final byte confidentiality;
    private final byte integrity;
    private Map<ProgramPoint, NonInterference> guards;

    public NonInterference() {
        this(2, 1);
    }

    public NonInterference(byte confidentiality, byte integrity) {
        this.confidentiality = confidentiality;
        this.integrity = integrity;
        this.guards = null;
    }

    public NonInterference top() {
        return new NonInterference(2, 1);
    }

    public boolean isTop() {
        return this.confidentiality == 2 && this.integrity == 1;
    }

    public NonInterference bottom() {
        return new NonInterference(0, 0);
    }

    public boolean isBottom() {
        return this.confidentiality == 0 && this.integrity == 0;
    }

    public boolean isHighConfidentiality() {
        return this.confidentiality == 2;
    }

    public boolean isLowConfidentiality() {
        return this.confidentiality == 1;
    }

    public boolean isHighIntegrity() {
        return this.integrity == 2;
    }

    public boolean isLowIntegrity() {
        return this.integrity == 1;
    }

    public NonInterference lubAux(NonInterference other) throws SemanticException {
        NonInterference ni = this.combine(other);
        this.addGuards(other, ni);
        return ni;
    }

    private NonInterference combine(NonInterference other) {
        byte confidentiality = this.isHighConfidentiality() || other.isHighConfidentiality() ? (byte)2 : 1;
        byte integrity = this.isLowIntegrity() || other.isLowIntegrity() ? (byte)1 : 2;
        NonInterference ni = new NonInterference(confidentiality, integrity);
        return ni;
    }

    private void addGuards(NonInterference other, NonInterference ni) throws SemanticException {
        if (this.guards != null) {
            ni.guards = new IdentityHashMap<ProgramPoint, NonInterference>(this.guards);
        }
        if (other.guards != null) {
            if (ni.guards == null) {
                ni.guards = new IdentityHashMap<ProgramPoint, NonInterference>(other.guards);
            } else {
                for (Map.Entry<ProgramPoint, NonInterference> guard : other.guards.entrySet()) {
                    ni.guards.put(guard.getKey(), guard.getValue().combine(ni.guards.getOrDefault(guard.getKey(), this.bottom())));
                }
            }
        }
    }

    public boolean lessOrEqualAux(NonInterference other) throws SemanticException {
        return this.compare(other) && this.compareGuards(other);
    }

    private boolean compare(NonInterference other) {
        boolean confidentiality = this.isLowConfidentiality() || this.confidentiality == other.confidentiality;
        boolean integrity = this.isHighIntegrity() || this.integrity == other.integrity;
        return confidentiality && integrity;
    }

    private boolean compareGuards(NonInterference other) throws SemanticException {
        if (this.guards == null) {
            return true;
        }
        if (other.guards == null) {
            return false;
        }
        for (Map.Entry<ProgramPoint, NonInterference> guard : this.guards.entrySet()) {
            NonInterference val = other.guards.get(guard.getKey());
            if (val != null && guard.getValue().compare(val)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.confidentiality;
        result = 31 * result + (this.guards == null ? 0 : this.guards.hashCode());
        result = 31 * result + this.integrity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NonInterference other = (NonInterference)obj;
        if (this.confidentiality != other.confidentiality) {
            return false;
        }
        if (this.guards == null ? other.guards != null : !this.guards.equals(other.guards)) {
            return false;
        }
        return this.integrity == other.integrity;
    }

    public String toString() {
        return this.representation().toString();
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        return new StringRepresentation((this.isHighConfidentiality() ? "H" : "L") + (this.isHighIntegrity() ? "H" : "L"));
    }

    private NonInterference state(NonInterference state, ProgramPoint pp) throws SemanticException {
        if (state.guards == null || state.guards.isEmpty()) {
            return NonInterference.mkLowHigh();
        }
        IdentityHashMap<ProgramPoint, NonInterference> guards = new IdentityHashMap<ProgramPoint, NonInterference>();
        for (ProgramPoint guard : pp.getCFG().getGuards(pp)) {
            guards.put(guard, state.guards.getOrDefault(guard, this.bottom()));
        }
        NonInterference res = NonInterference.mkLowHigh();
        for (NonInterference guard : guards.values()) {
            res = res.combine(guard);
        }
        res.guards = new IdentityHashMap<ProgramPoint, NonInterference>();
        guards.forEach(res.guards::put);
        return res;
    }

    private static NonInterference mkLowHigh() {
        return new NonInterference(1, 2);
    }

    private static NonInterference mkLowLow() {
        return new NonInterference(1, 1);
    }

    private static NonInterference mkHighHigh() {
        return new NonInterference(2, 2);
    }

    private NonInterference mkHighLow() {
        return this.top();
    }

    public InferredValue.InferredPair<NonInterference> evalSkip(Skip skip, NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)this.bottom(), (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalPushAny(PushAny pushAny, NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)this.top(), (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalTypeConv(BinaryExpression conv, NonInterference left, NonInterference right, NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)left, (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalTypeCast(BinaryExpression cast, NonInterference left, NonInterference right, NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)left, (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalNullConstant(NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)NonInterference.mkLowHigh(), (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalNonNullConstant(Constant constant, NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)NonInterference.mkLowHigh(), (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalUnaryExpression(UnaryOperator operator, NonInterference arg, NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)arg, (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalBinaryExpression(BinaryOperator operator, NonInterference left, NonInterference right, NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)((NonInterference)left.lub((BaseLattice)right)), (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalTernaryExpression(TernaryOperator operator, NonInterference left, NonInterference middle, NonInterference right, NonInterference state, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)((NonInterference)((NonInterference)left.lub((BaseLattice)middle)).lub((BaseLattice)right)), (InferredValue)this.state(state, pp));
    }

    public InferredValue.InferredPair<NonInterference> evalIdentifier(Identifier id, InferenceSystem<NonInterference> environment, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return new InferredValue.InferredPair((InferredValue)this, (InferredValue)this.fixedVariable(id, pp, oracle), (InferredValue)this.state((NonInterference)environment.getExecutionState(), pp));
    }

    public NonInterference fixedVariable(Identifier id, ProgramPoint pp, SemanticOracle oracle) {
        Annotations annots = id.getAnnotations();
        if (annots.isEmpty()) {
            return this.mkHighLow();
        }
        boolean lowConf = annots.contains(LOW_CONF_MATCHER);
        boolean highInt = annots.contains(HIGH_INT_MATCHER);
        if (lowConf && highInt) {
            return NonInterference.mkLowHigh();
        }
        if (lowConf) {
            return NonInterference.mkLowLow();
        }
        if (highInt) {
            return NonInterference.mkHighHigh();
        }
        return this.mkHighLow();
    }

    public InferenceSystem<NonInterference> assume(InferenceSystem<NonInterference> environment, ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        InferredValue.InferredPair eval = this.eval(expression, environment, src, oracle);
        NonInterference inf = (NonInterference)eval.getInferred();
        inf.guards = new IdentityHashMap<ProgramPoint, NonInterference>();
        if (((NonInterference)eval.getState()).guards != null) {
            ((NonInterference)eval.getState()).guards.forEach(inf.guards::put);
        }
        inf.guards.put(src, inf);
        NonInterference state = this.state(inf, dest);
        return new InferenceSystem(environment, (InferredValue)state);
    }
}

