/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonRedundantSet;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.lattices.SetLattice;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;

public abstract class NonRedundantPowerset<C extends NonRedundantPowerset<C, T, E, I>, T extends SemanticDomain<T, E, I> & Lattice<T>, E extends SymbolicExpression, I extends Identifier>
extends SetLattice<C, T>
implements SemanticDomain<C, E, I> {
    public final T valueDomain;

    public NonRedundantPowerset(SortedSet<T> elements, boolean isTop, T valueDomain) {
        super(elements, isTop);
        this.valueDomain = valueDomain;
    }

    protected C removeRedundancy() throws SemanticException {
        TreeSet<SemanticDomain> newElementsSet = new TreeSet<SemanticDomain>();
        for (SemanticDomain element : this.elements) {
            if (((Lattice)element).isBottom()) continue;
            boolean toRemove = false;
            for (SemanticDomain otherElement : this.elements) {
                if (!((Lattice)element).lessOrEqual((Lattice)otherElement) || ((Lattice)otherElement).lessOrEqual((Lattice)element)) continue;
                toRemove = true;
            }
            if (toRemove) continue;
            newElementsSet.add(element);
        }
        return (C)this.mk(newElementsSet);
    }

    public C top() {
        return this.mk(new TreeSet(), true, this.valueDomain);
    }

    public C bottom() {
        return this.mk(new TreeSet(), false, this.valueDomain);
    }

    public boolean isBottom() {
        return !this.isTop && this.elements.isEmpty();
    }

    public boolean isTop() {
        return this.isTop && this.elements.isEmpty();
    }

    public C lubAux(C other) throws SemanticException {
        HashSet lubSet = new HashSet(this.elements);
        lubSet.addAll(((NonRedundantPowerset)((Object)other)).elements);
        return this.mk((Set)lubSet).removeRedundancy();
    }

    public C glbAux(C other) throws SemanticException {
        TreeSet<SemanticDomain> glbSet = new TreeSet<SemanticDomain>();
        for (SemanticDomain s1 : this.elements) {
            for (SemanticDomain s2 : ((NonRedundantPowerset)((Object)other)).elements) {
                glbSet.add((SemanticDomain)((Lattice)s1).glb((Lattice)s2));
            }
        }
        return this.mk(glbSet).removeRedundancy();
    }

    protected C EgliMilnerConnector(C other) throws SemanticException {
        HashSet unionSet = new HashSet(this.elements);
        unionSet.addAll(((NonRedundantPowerset)((Object)other)).elements);
        SemanticDomain completeLub = (SemanticDomain)((Lattice)this.valueDomain).bottom();
        if (!unionSet.isEmpty()) {
            for (SemanticDomain element : unionSet) {
                completeLub = (SemanticDomain)((Lattice)completeLub).lub((Lattice)element);
            }
        }
        TreeSet<SemanticDomain> newSet = new TreeSet<SemanticDomain>();
        if (completeLub != null) {
            newSet.add(completeLub);
        }
        return (C)this.mk(newSet);
    }

    protected C extrapolationHeuristic(C other) throws SemanticException {
        TreeSet<SemanticDomain> extrapolatedSet = new TreeSet<SemanticDomain>();
        for (SemanticDomain s1 : this.elements) {
            for (SemanticDomain s2 : ((NonRedundantPowerset)((Object)other)).elements) {
                if (!((Lattice)s1).lessOrEqual((Lattice)s2) || ((Lattice)s2).lessOrEqual((Lattice)s1)) continue;
                extrapolatedSet.add((SemanticDomain)((Lattice)s1).widening((Lattice)s2));
            }
        }
        return (C)((Object)((NonRedundantPowerset)this.mk(extrapolatedSet).removeRedundancy().lub(other)));
    }

    public C wideningAux(C other) throws SemanticException {
        if (this.lessOrEqualEgliMilner(other)) {
            return ((NonRedundantPowerset)((Object)this.extrapolationHeuristic(other))).removeRedundancy();
        }
        return ((NonRedundantPowerset)((Object)this.extrapolationHeuristic(this.EgliMilnerConnector(other)))).removeRedundancy();
    }

    public boolean lessOrEqualAux(C other) throws SemanticException {
        for (SemanticDomain s1 : this.elements) {
            boolean existsGreaterElement = false;
            for (SemanticDomain s2 : ((NonRedundantPowerset)((Object)other)).elements) {
                if (!((Lattice)s1).lessOrEqual((Lattice)s2)) continue;
                existsGreaterElement = true;
                break;
            }
            if (existsGreaterElement) continue;
            return false;
        }
        return true;
    }

    public boolean lessOrEqualEgliMilner(C other) throws SemanticException {
        if (this.lessOrEqual((BaseLattice)other)) {
            if (!this.isBottom()) {
                for (SemanticDomain s2 : ((NonRedundantPowerset)((Object)other)).elements) {
                    boolean existsLowerElement = false;
                    for (SemanticDomain s1 : this.elements) {
                        if (!((Lattice)s1).lessOrEqual((Lattice)s2)) continue;
                        existsLowerElement = true;
                        break;
                    }
                    if (existsLowerElement) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public C assign(I id, E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        TreeSet<SemanticDomain> newElements = new TreeSet<SemanticDomain>();
        for (SemanticDomain elem : this.elements) {
            newElements.add(elem.assign(id, expression, pp, oracle));
        }
        return this.mk(newElements).removeRedundancy();
    }

    public C smallStepSemantics(E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        TreeSet<SemanticDomain> newElements = new TreeSet<SemanticDomain>();
        for (SemanticDomain elem : this.elements) {
            newElements.add(elem.smallStepSemantics(expression, pp, oracle));
        }
        return this.mk(newElements).removeRedundancy();
    }

    public C assume(E expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        TreeSet<SemanticDomain> newElements = new TreeSet<SemanticDomain>();
        for (SemanticDomain elem : this.elements) {
            newElements.add(elem.assume(expression, src, dest, oracle));
        }
        return this.mk(newElements).removeRedundancy();
    }

    public C forgetIdentifier(Identifier id) throws SemanticException {
        TreeSet<SemanticDomain> newElements = new TreeSet<SemanticDomain>();
        for (SemanticDomain elem : this.elements) {
            newElements.add(elem.forgetIdentifier(id));
        }
        return this.mk(newElements).removeRedundancy();
    }

    public C forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        TreeSet<SemanticDomain> newElements = new TreeSet<SemanticDomain>();
        for (SemanticDomain elem : this.elements) {
            newElements.add(elem.forgetIdentifiersIf(test));
        }
        return this.mk(newElements).removeRedundancy();
    }

    public C pushScope(ScopeToken token) throws SemanticException {
        TreeSet<SemanticDomain> newElements = new TreeSet<SemanticDomain>();
        for (SemanticDomain elem : this.elements) {
            newElements.add((SemanticDomain)elem.pushScope(token));
        }
        return this.mk(newElements).removeRedundancy();
    }

    public C popScope(ScopeToken token) throws SemanticException {
        TreeSet<SemanticDomain> newElements = new TreeSet<SemanticDomain>();
        for (SemanticDomain elem : this.elements) {
            newElements.add((SemanticDomain)elem.popScope(token));
        }
        return this.mk(newElements).removeRedundancy();
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        Object representation = "[";
        boolean first = true;
        for (SemanticDomain element : this.elements) {
            if (!first) {
                representation = (String)representation + ", ";
            } else {
                first = false;
            }
            representation = (String)representation + element.representation();
        }
        representation = (String)representation + "]";
        return new StringRepresentation((String)representation);
    }

    public C mk(Set<T> set) {
        SortedSet<Object> sorted;
        SortedSet<Object> sortedSet = sorted = set instanceof SortedSet ? (SortedSet<Object>)set : new TreeSet<T>(set);
        if (set.isEmpty()) {
            return this.mk(sorted, false, this.valueDomain);
        }
        for (SemanticDomain elem : set) {
            if (!((Lattice)elem).isTop()) continue;
            return this.mk(new TreeSet(), true, this.valueDomain);
        }
        return this.mk(sorted, false, this.valueDomain);
    }

    public abstract C mk(SortedSet<T> var1, boolean var2, T var3);

    public Satisfiability satisfies(E expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        HashSet<Satisfiability> setSatisf = new HashSet<Satisfiability>();
        for (SemanticDomain element : this.elements) {
            setSatisf.add(element.satisfies(expression, pp, oracle));
        }
        if (setSatisf.contains(Satisfiability.SATISFIED) && setSatisf.contains(Satisfiability.NOT_SATISFIED) || setSatisf.contains(Satisfiability.UNKNOWN)) {
            return Satisfiability.UNKNOWN;
        }
        if (setSatisf.contains(Satisfiability.SATISFIED)) {
            return Satisfiability.SATISFIED;
        }
        if (setSatisf.contains(Satisfiability.NOT_SATISFIED)) {
            return Satisfiability.NOT_SATISFIED;
        }
        return Satisfiability.UNKNOWN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.valueDomain == null ? 0 : this.valueDomain.hashCode());
        result = 31 * result + (this.isTop ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NonRedundantPowerset other = (NonRedundantPowerset)((Object)obj);
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        if (this.valueDomain == null ? other.valueDomain != null : !this.valueDomain.equals(other.valueDomain)) {
            return false;
        }
        return this.isTop == other.isTop;
    }
}

