/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.nonRedundantSet;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonRedundantSet.NonRedundantPowersetOfInterval;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.util.representation.SetRepresentation;
import it.unive.lisa.util.representation.StructuredObject;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class NonRedundantPowersetOfBaseNonRelationalValueDomain<C extends NonRedundantPowersetOfBaseNonRelationalValueDomain<C, E>, E extends BaseNonRelationalValueDomain<E>>
implements BaseNonRelationalValueDomain<C> {
    protected final SortedSet<E> elementsSet;
    protected final E valueDomain;

    protected NonRedundantPowersetOfBaseNonRelationalValueDomain(SortedSet<E> elements, E element) {
        this.elementsSet = new TreeSet<E>(elements);
        this.valueDomain = (BaseNonRelationalValueDomain)element.bottom();
    }

    protected abstract C mk(SortedSet<E> var1);

    protected C removeRedundancy() throws SemanticException {
        TreeSet<BaseNonRelationalValueDomain> newElementsSet = new TreeSet<BaseNonRelationalValueDomain>();
        for (BaseNonRelationalValueDomain element : this.elementsSet) {
            if (element.isBottom()) continue;
            boolean toRemove = false;
            for (BaseNonRelationalValueDomain otherElement : this.elementsSet) {
                if (!element.lessOrEqual((BaseLattice)otherElement) || otherElement.lessOrEqual((BaseLattice)element)) continue;
                toRemove = true;
                break;
            }
            if (toRemove) continue;
            newElementsSet.add(element);
        }
        return this.mk(newElementsSet);
    }

    protected C removeOverlapping() throws SemanticException {
        SortedSet<BaseNonRelationalValueDomain> newSet;
        SortedSet<BaseNonRelationalValueDomain> tmpSet = this.elementsSet;
        do {
            newSet = tmpSet;
            tmpSet = new TreeSet();
            for (BaseNonRelationalValueDomain e1 : newSet) {
                boolean intersectionFound = false;
                for (BaseNonRelationalValueDomain e2 : newSet) {
                    if (((BaseNonRelationalValueDomain)e1.glb((BaseLattice)e2)).isBottom()) continue;
                    BaseNonRelationalValueDomain notOverlappingElement = this.removeOverlappingBetweenElements(e1, e2);
                    if (!tmpSet.contains(notOverlappingElement)) {
                        tmpSet.add(notOverlappingElement);
                    }
                    intersectionFound = true;
                }
                if (intersectionFound) continue;
                tmpSet.add(e1);
            }
        } while (tmpSet.size() != newSet.size());
        return ((NonRedundantPowersetOfBaseNonRelationalValueDomain)this.mk(tmpSet)).removeRedundancy();
    }

    protected E removeOverlappingBetweenElements(E e1, E e2) throws SemanticException {
        return (E)((BaseNonRelationalValueDomain)e1.lub(e2));
    }

    protected C EgliMilnerConnector(C other) throws SemanticException {
        TreeSet<BaseNonRelationalValueDomain> newSet = new TreeSet<BaseNonRelationalValueDomain>();
        if (this.elementsSet.isEmpty() && ((NonRedundantPowersetOfBaseNonRelationalValueDomain)other).elementsSet.isEmpty()) {
            return this.mk(newSet);
        }
        BaseNonRelationalValueDomain completeLub = (BaseNonRelationalValueDomain)this.valueDomain.bottom();
        for (BaseNonRelationalValueDomain element : this.elementsSet) {
            completeLub = (BaseNonRelationalValueDomain)completeLub.lub((BaseLattice)element);
        }
        for (BaseNonRelationalValueDomain element : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)other).elementsSet) {
            completeLub = (BaseNonRelationalValueDomain)completeLub.lub((BaseLattice)element);
        }
        newSet.add(completeLub);
        return this.mk(newSet);
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        return new SetRepresentation(this.elementsSet, StructuredObject::representation);
    }

    public String toString() {
        return this.representation().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elementsSet == null ? 0 : this.elementsSet.hashCode());
        result = 31 * result + (this.valueDomain == null ? 0 : this.valueDomain.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NonRedundantPowersetOfInterval other = (NonRedundantPowersetOfInterval)obj;
        if (this.elementsSet == null ? other.elementsSet != null : !this.elementsSet.equals(other.elementsSet)) {
            return false;
        }
        return !(this.valueDomain == null ? other.valueDomain != null : !this.valueDomain.equals(other.valueDomain));
    }

    public C lubAux(C other) throws SemanticException {
        TreeSet<E> lubSet = new TreeSet<E>(this.elementsSet);
        lubSet.addAll(((NonRedundantPowersetOfBaseNonRelationalValueDomain)other).elementsSet);
        return ((NonRedundantPowersetOfBaseNonRelationalValueDomain)((NonRedundantPowersetOfBaseNonRelationalValueDomain)this.mk(lubSet)).removeRedundancy()).removeOverlapping();
    }

    public C glbAux(C other) throws SemanticException {
        TreeSet<BaseNonRelationalValueDomain> glbSet = new TreeSet<BaseNonRelationalValueDomain>();
        for (BaseNonRelationalValueDomain s1 : this.elementsSet) {
            for (BaseNonRelationalValueDomain s2 : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)other).elementsSet) {
                glbSet.add((BaseNonRelationalValueDomain)s1.glb((BaseLattice)s2));
            }
        }
        return ((NonRedundantPowersetOfBaseNonRelationalValueDomain)((NonRedundantPowersetOfBaseNonRelationalValueDomain)this.mk(glbSet)).removeRedundancy()).removeOverlapping();
    }

    protected C extrapolationHeuristic(C other) throws SemanticException {
        TreeSet<BaseNonRelationalValueDomain> extrapolatedSet = new TreeSet<BaseNonRelationalValueDomain>();
        for (BaseNonRelationalValueDomain s1 : this.elementsSet) {
            for (BaseNonRelationalValueDomain s2 : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)other).elementsSet) {
                if (!s1.lessOrEqual((BaseLattice)s2) || s2.lessOrEqual((BaseLattice)s1)) continue;
                extrapolatedSet.add((BaseNonRelationalValueDomain)s1.widening((BaseLattice)s2));
            }
        }
        return (C)((NonRedundantPowersetOfBaseNonRelationalValueDomain)((NonRedundantPowersetOfBaseNonRelationalValueDomain)this.mk(extrapolatedSet)).removeRedundancy().lub(other));
    }

    public C wideningAux(C other) throws SemanticException {
        C arg = this.lessOrEqualEgliMilner(other) ? other : this.EgliMilnerConnector(other);
        return ((NonRedundantPowersetOfBaseNonRelationalValueDomain)((NonRedundantPowersetOfBaseNonRelationalValueDomain)this.extrapolationHeuristic(arg)).removeRedundancy()).removeOverlapping();
    }

    public boolean lessOrEqualEgliMilner(C other) throws SemanticException {
        if (!this.lessOrEqual((BaseLattice)other)) {
            return false;
        }
        if (this.isBottom()) {
            return true;
        }
        for (BaseNonRelationalValueDomain s2 : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)other).elementsSet) {
            boolean existsLowerElement = false;
            for (BaseNonRelationalValueDomain s1 : this.elementsSet) {
                if (!s1.lessOrEqual((BaseLattice)s2)) continue;
                existsLowerElement = true;
                break;
            }
            if (existsLowerElement) continue;
            return false;
        }
        return true;
    }

    public boolean lessOrEqualAux(C other) throws SemanticException {
        for (BaseNonRelationalValueDomain s1 : this.elementsSet) {
            boolean existsGreaterElement = false;
            for (BaseNonRelationalValueDomain s2 : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)other).elementsSet) {
                if (!s1.lessOrEqual((BaseLattice)s2)) continue;
                existsGreaterElement = true;
                break;
            }
            if (existsGreaterElement) continue;
            return false;
        }
        return true;
    }

    public C evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        TreeSet<BaseNonRelationalValueDomain> newSet = new TreeSet<BaseNonRelationalValueDomain>();
        newSet.add(this.valueDomain.evalNonNullConstant(constant, pp, oracle));
        return ((NonRedundantPowersetOfBaseNonRelationalValueDomain)((NonRedundantPowersetOfBaseNonRelationalValueDomain)this.mk(newSet)).removeRedundancy()).removeOverlapping();
    }

    public C evalUnaryExpression(UnaryOperator operator, C arg, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        TreeSet<BaseNonRelationalValueDomain> newSet = new TreeSet<BaseNonRelationalValueDomain>();
        for (BaseNonRelationalValueDomain s : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)arg).elementsSet) {
            newSet.add(this.valueDomain.evalUnaryExpression(operator, s, pp, oracle));
        }
        return ((NonRedundantPowersetOfBaseNonRelationalValueDomain)((NonRedundantPowersetOfBaseNonRelationalValueDomain)this.mk(newSet)).removeRedundancy()).removeOverlapping();
    }

    public C evalBinaryExpression(BinaryOperator operator, C left, C right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        TreeSet<BaseNonRelationalValueDomain> newSet = new TreeSet<BaseNonRelationalValueDomain>();
        for (BaseNonRelationalValueDomain sLeft : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)left).elementsSet) {
            for (BaseNonRelationalValueDomain sRight : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)right).elementsSet) {
                newSet.add(this.valueDomain.evalBinaryExpression(operator, sLeft, sRight, pp, oracle));
            }
        }
        return ((NonRedundantPowersetOfBaseNonRelationalValueDomain)((NonRedundantPowersetOfBaseNonRelationalValueDomain)this.mk(newSet)).removeRedundancy()).removeOverlapping();
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, C left, C right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (((NonRedundantPowersetOfBaseNonRelationalValueDomain)left).isTop() || ((NonRedundantPowersetOfBaseNonRelationalValueDomain)right).isTop()) {
            return Satisfiability.UNKNOWN;
        }
        Satisfiability sat = Satisfiability.BOTTOM;
        for (BaseNonRelationalValueDomain sLeft : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)left).elementsSet) {
            for (BaseNonRelationalValueDomain sRight : ((NonRedundantPowersetOfBaseNonRelationalValueDomain)right).elementsSet) {
                sat = (Satisfiability)sat.lub((Lattice)this.valueDomain.satisfiesBinaryExpression(operator, sLeft, sRight, pp, oracle));
            }
        }
        return sat;
    }

    public C top() {
        TreeSet<BaseNonRelationalValueDomain> topSet = new TreeSet<BaseNonRelationalValueDomain>();
        topSet.add((BaseNonRelationalValueDomain)this.valueDomain.top());
        return this.mk(topSet);
    }

    public C bottom() {
        return this.mk(Collections.emptySortedSet());
    }

    public boolean isBottom() {
        return this.elementsSet.isEmpty();
    }

    public boolean isTop() {
        for (BaseNonRelationalValueDomain element : this.elementsSet) {
            if (!element.isTop()) continue;
            return true;
        }
        return false;
    }
}

