/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.ModuloOperator;
import it.unive.lisa.symbolic.value.operator.MultiplicationOperator;
import it.unive.lisa.symbolic.value.operator.RemainderOperator;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonNe;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;

public class IntegerConstantPropagation
implements BaseNonRelationalValueDomain<IntegerConstantPropagation> {
    private static final IntegerConstantPropagation TOP = new IntegerConstantPropagation(true, false);
    private static final IntegerConstantPropagation BOTTOM = new IntegerConstantPropagation(false, true);
    private final boolean isTop;
    private final boolean isBottom;
    private final Integer value;

    public IntegerConstantPropagation() {
        this(null, true, false);
    }

    private IntegerConstantPropagation(Integer value, boolean isTop, boolean isBottom) {
        this.value = value;
        this.isTop = isTop;
        this.isBottom = isBottom;
    }

    public IntegerConstantPropagation(Integer value) {
        this(value, false, false);
    }

    private IntegerConstantPropagation(boolean isTop, boolean isBottom) {
        this(null, isTop, isBottom);
    }

    public IntegerConstantPropagation top() {
        return TOP;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public IntegerConstantPropagation bottom() {
        return BOTTOM;
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation(this.value.toString());
    }

    public IntegerConstantPropagation evalNullConstant(ProgramPoint pp, SemanticOracle oracle) {
        return this.top();
    }

    public IntegerConstantPropagation evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        if (constant.getValue() instanceof Integer) {
            return new IntegerConstantPropagation((Integer)constant.getValue());
        }
        return this.top();
    }

    public IntegerConstantPropagation evalUnaryExpression(UnaryOperator operator, IntegerConstantPropagation arg, ProgramPoint pp, SemanticOracle oracle) {
        if (arg.isTop()) {
            return this.top();
        }
        if (operator == NumericNegation.INSTANCE) {
            return new IntegerConstantPropagation(-this.value.intValue());
        }
        return this.top();
    }

    public IntegerConstantPropagation evalBinaryExpression(BinaryOperator operator, IntegerConstantPropagation left, IntegerConstantPropagation right, ProgramPoint pp, SemanticOracle oracle) {
        if (operator instanceof AdditionOperator) {
            return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(left.value + right.value);
        }
        if (operator instanceof DivisionOperator) {
            if (!left.isTop() && left.value == 0) {
                return new IntegerConstantPropagation(0);
            }
            if (!right.isTop() && right.value == 0) {
                return this.bottom();
            }
            if (left.isTop() || right.isTop() || left.value % right.value != 0) {
                return this.top();
            }
            return new IntegerConstantPropagation(left.value / right.value);
        }
        if (operator instanceof ModuloOperator) {
            return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(right.value < 0 ? -Math.abs(left.value % right.value) : -Math.abs(left.value % right.value));
        }
        if (operator instanceof RemainderOperator) {
            return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(left.value % right.value);
        }
        if (operator instanceof MultiplicationOperator) {
            return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(left.value * right.value);
        }
        if (operator instanceof SubtractionOperator) {
            return left.isTop() || right.isTop() ? this.top() : new IntegerConstantPropagation(left.value - right.value);
        }
        return this.top();
    }

    public IntegerConstantPropagation evalTernaryExpression(TernaryOperator operator, IntegerConstantPropagation left, IntegerConstantPropagation middle, IntegerConstantPropagation right, ProgramPoint pp, SemanticOracle oracle) {
        return this.top();
    }

    public IntegerConstantPropagation lubAux(IntegerConstantPropagation other) throws SemanticException {
        return TOP;
    }

    public boolean lessOrEqualAux(IntegerConstantPropagation other) throws SemanticException {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isBottom ? 1231 : 1237);
        result = 31 * result + (this.isTop ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerConstantPropagation other = (IntegerConstantPropagation)obj;
        if (this.isBottom != other.isBottom) {
            return false;
        }
        if (this.isTop != other.isTop) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, IntegerConstantPropagation left, IntegerConstantPropagation right, ProgramPoint pp, SemanticOracle oracle) {
        if (left.isTop() || right.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonEq.INSTANCE) {
            return left.value.intValue() == right.value.intValue() ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonGe.INSTANCE) {
            return left.value >= right.value ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonGt.INSTANCE) {
            return left.value > right.value ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonLe.INSTANCE) {
            return left.value <= right.value ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonLt.INSTANCE) {
            return left.value < right.value ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        if (operator == ComparisonNe.INSTANCE) {
            return left.value.intValue() != right.value.intValue() ? Satisfiability.SATISFIED : Satisfiability.NOT_SATISFIED;
        }
        return Satisfiability.UNKNOWN;
    }

    public ValueEnvironment<IntegerConstantPropagation> assumeBinaryExpression(ValueEnvironment<IntegerConstantPropagation> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        if (operator == ComparisonEq.INSTANCE) {
            if (left instanceof Identifier) {
                IntegerConstantPropagation eval = (IntegerConstantPropagation)this.eval(right, environment, src, oracle);
                if (eval.isBottom()) {
                    return environment.bottom();
                }
                return (ValueEnvironment)environment.putState((Object)((Identifier)left), (Lattice)eval);
            }
            if (right instanceof Identifier) {
                IntegerConstantPropagation eval = (IntegerConstantPropagation)this.eval(left, environment, src, oracle);
                if (eval.isBottom()) {
                    return environment.bottom();
                }
                return (ValueEnvironment)environment.putState((Object)((Identifier)right), (Lattice)eval);
            }
        }
        return environment;
    }
}

