/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.ModuloOperator;
import it.unive.lisa.symbolic.value.operator.MultiplicationOperator;
import it.unive.lisa.symbolic.value.operator.RemainderOperator;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonNe;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import it.unive.lisa.symbolic.value.operator.unary.StringLength;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;

public class Interval
implements BaseNonRelationalValueDomain<Interval>,
Comparable<Interval> {
    public static final Interval ZERO = new Interval(IntInterval.ZERO);
    public static final Interval TOP = new Interval(IntInterval.INFINITY);
    public static final Interval BOTTOM = new Interval(null);
    public final IntInterval interval;

    public Interval(IntInterval interval) {
        this.interval = interval;
    }

    public Interval(MathNumber low, MathNumber high) {
        this(new IntInterval(low, high));
    }

    public Interval(int low, int high) {
        this(new IntInterval(low, high));
    }

    public Interval() {
        this(IntInterval.INFINITY);
    }

    public Interval top() {
        return TOP;
    }

    public boolean isTop() {
        return this.interval != null && this.interval.isInfinity();
    }

    public Interval bottom() {
        return BOTTOM;
    }

    public boolean isBottom() {
        return this.interval == null;
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        return new StringRepresentation(this.interval.toString());
    }

    public String toString() {
        return this.representation().toString();
    }

    public Interval evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) {
        if (constant.getValue() instanceof Integer) {
            Integer i = (Integer)constant.getValue();
            return new Interval(new MathNumber((long)i.intValue()), new MathNumber((long)i.intValue()));
        }
        return this.top();
    }

    public Interval evalUnaryExpression(UnaryOperator operator, Interval arg, ProgramPoint pp, SemanticOracle oracle) {
        if (operator == NumericNegation.INSTANCE) {
            if (arg.isTop()) {
                return this.top();
            }
            return new Interval(arg.interval.mul(IntInterval.MINUS_ONE));
        }
        if (operator == StringLength.INSTANCE) {
            return new Interval(MathNumber.ZERO, MathNumber.PLUS_INFINITY);
        }
        return this.top();
    }

    public boolean is(int n) {
        return !this.isBottom() && this.interval.is(n);
    }

    public Interval evalBinaryExpression(BinaryOperator operator, Interval left, Interval right, ProgramPoint pp, SemanticOracle oracle) {
        if (!(operator instanceof DivisionOperator) && (left.isTop() || right.isTop())) {
            return this.top();
        }
        if (operator instanceof AdditionOperator) {
            return new Interval(left.interval.plus(right.interval));
        }
        if (operator instanceof SubtractionOperator) {
            return new Interval(left.interval.diff(right.interval));
        }
        if (operator instanceof MultiplicationOperator) {
            if (left.is(0) || right.is(0)) {
                return ZERO;
            }
            return new Interval(left.interval.mul(right.interval));
        }
        if (operator instanceof DivisionOperator) {
            if (right.is(0)) {
                return this.bottom();
            }
            if (left.is(0)) {
                return ZERO;
            }
            if (left.isTop() || right.isTop()) {
                return this.top();
            }
            return new Interval(left.interval.div(right.interval, false, false));
        }
        if (operator instanceof ModuloOperator) {
            if (right.is(0)) {
                return this.bottom();
            }
            if (left.is(0)) {
                return ZERO;
            }
            if (left.isTop() || right.isTop()) {
                return this.top();
            }
            if (right.interval.getHigh().compareTo(MathNumber.ZERO) < 0) {
                return new Interval(right.interval.getLow().add(MathNumber.ONE), MathNumber.ZERO);
            }
            if (right.interval.getLow().compareTo(MathNumber.ZERO) > 0) {
                return new Interval(MathNumber.ZERO, right.interval.getHigh().subtract(MathNumber.ONE));
            }
            return new Interval(right.interval.getLow().add(MathNumber.ONE), right.interval.getHigh().subtract(MathNumber.ONE));
        }
        if (operator instanceof RemainderOperator) {
            if (right.is(0)) {
                return this.bottom();
            }
            if (left.is(0)) {
                return ZERO;
            }
            if (left.isTop() || right.isTop()) {
                return this.top();
            }
            MathNumber M = right.interval.getHigh().compareTo(MathNumber.ZERO) < 0 ? right.interval.getLow().multiply(MathNumber.MINUS_ONE) : (right.interval.getLow().compareTo(MathNumber.ZERO) > 0 ? right.interval.getHigh() : right.interval.getLow().abs().max(right.interval.getHigh().abs()));
            if (left.interval.getHigh().compareTo(MathNumber.ZERO) < 0) {
                return new Interval(M.multiply(MathNumber.MINUS_ONE).add(MathNumber.ONE), MathNumber.ZERO);
            }
            if (left.interval.getLow().compareTo(MathNumber.ZERO) > 0) {
                return new Interval(MathNumber.ZERO, M.subtract(MathNumber.ONE));
            }
            return new Interval(M.multiply(MathNumber.MINUS_ONE).add(MathNumber.ONE), M.subtract(MathNumber.ONE));
        }
        return this.top();
    }

    public Interval lubAux(Interval other) throws SemanticException {
        MathNumber newLow = this.interval.getLow().min(other.interval.getLow());
        MathNumber newHigh = this.interval.getHigh().max(other.interval.getHigh());
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    public Interval glbAux(Interval other) {
        MathNumber newHigh;
        MathNumber newLow = this.interval.getLow().max(other.interval.getLow());
        if (newLow.compareTo(newHigh = this.interval.getHigh().min(other.interval.getHigh())) > 0) {
            return this.bottom();
        }
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    public Interval wideningAux(Interval other) throws SemanticException {
        MathNumber newHigh = other.interval.getHigh().compareTo(this.interval.getHigh()) > 0 ? MathNumber.PLUS_INFINITY : this.interval.getHigh();
        MathNumber newLow = other.interval.getLow().compareTo(this.interval.getLow()) < 0 ? MathNumber.MINUS_INFINITY : this.interval.getLow();
        return newLow.isMinusInfinity() && newHigh.isPlusInfinity() ? this.top() : new Interval(newLow, newHigh);
    }

    public Interval narrowingAux(Interval other) throws SemanticException {
        MathNumber newHigh = this.interval.getHigh().isInfinite() ? other.interval.getHigh() : this.interval.getHigh();
        MathNumber newLow = this.interval.getLow().isInfinite() ? other.interval.getLow() : this.interval.getLow();
        return new Interval(newLow, newHigh);
    }

    public boolean lessOrEqualAux(Interval other) throws SemanticException {
        return other.interval.includes(this.interval);
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, Interval left, Interval right, ProgramPoint pp, SemanticOracle oracle) {
        if (left.isTop() || right.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonEq.INSTANCE) {
            Interval glb = null;
            try {
                glb = (Interval)left.glb((BaseLattice)right);
            }
            catch (SemanticException e) {
                return Satisfiability.UNKNOWN;
            }
            if (glb.isBottom()) {
                return Satisfiability.NOT_SATISFIED;
            }
            if (left.interval.isSingleton() && left.equals(right)) {
                return Satisfiability.SATISFIED;
            }
            return Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonGe.INSTANCE) {
            return this.satisfiesBinaryExpression((BinaryOperator)ComparisonLe.INSTANCE, right, left, pp, oracle);
        }
        if (operator == ComparisonGt.INSTANCE) {
            return this.satisfiesBinaryExpression((BinaryOperator)ComparisonLt.INSTANCE, right, left, pp, oracle);
        }
        if (operator == ComparisonLe.INSTANCE) {
            Interval glb = null;
            try {
                glb = (Interval)left.glb((BaseLattice)right);
            }
            catch (SemanticException e) {
                return Satisfiability.UNKNOWN;
            }
            if (glb.isBottom()) {
                return Satisfiability.fromBoolean((left.interval.getHigh().compareTo(right.interval.getLow()) <= 0 ? 1 : 0) != 0);
            }
            if (glb.interval.isSingleton() && left.interval.getHigh().compareTo(right.interval.getLow()) == 0) {
                return Satisfiability.SATISFIED;
            }
            return Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonLt.INSTANCE) {
            Interval glb = null;
            try {
                glb = (Interval)left.glb((BaseLattice)right);
            }
            catch (SemanticException e) {
                return Satisfiability.UNKNOWN;
            }
            if (glb.isBottom()) {
                return Satisfiability.fromBoolean((left.interval.getHigh().compareTo(right.interval.getLow()) < 0 ? 1 : 0) != 0);
            }
            return Satisfiability.UNKNOWN;
        }
        if (operator == ComparisonNe.INSTANCE) {
            Interval glb = null;
            try {
                glb = (Interval)left.glb((BaseLattice)right);
            }
            catch (SemanticException e) {
                return Satisfiability.UNKNOWN;
            }
            if (glb.isBottom()) {
                return Satisfiability.SATISFIED;
            }
            return Satisfiability.UNKNOWN;
        }
        return Satisfiability.UNKNOWN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        return !(this.interval == null ? other.interval != null : !this.interval.equals((Object)other.interval));
    }

    public ValueEnvironment<Interval> assumeBinaryExpression(ValueEnvironment<Interval> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        boolean rightIsExpr;
        Identifier id;
        Interval eval;
        if (left instanceof Identifier) {
            eval = (Interval)this.eval(right, environment, src, oracle);
            id = (Identifier)left;
            rightIsExpr = true;
        } else if (right instanceof Identifier) {
            eval = (Interval)this.eval(left, environment, src, oracle);
            id = (Identifier)right;
            rightIsExpr = false;
        } else {
            return environment;
        }
        Interval starting = (Interval)environment.getState((Object)id);
        if (eval.isBottom() || starting.isBottom()) {
            return environment.bottom();
        }
        boolean lowIsMinusInfinity = eval.interval.lowIsMinusInfinity();
        Interval low_inf = new Interval(eval.interval.getLow(), MathNumber.PLUS_INFINITY);
        Interval lowp1_inf = new Interval(eval.interval.getLow().add(MathNumber.ONE), MathNumber.PLUS_INFINITY);
        Interval inf_high = new Interval(MathNumber.MINUS_INFINITY, eval.interval.getHigh());
        Interval inf_highm1 = new Interval(MathNumber.MINUS_INFINITY, eval.interval.getHigh().subtract(MathNumber.ONE));
        Interval update = null;
        if (operator == ComparisonEq.INSTANCE) {
            update = eval;
        } else if (operator == ComparisonGe.INSTANCE) {
            update = rightIsExpr ? (lowIsMinusInfinity ? null : (Interval)starting.glb((BaseLattice)low_inf)) : (Interval)starting.glb((BaseLattice)inf_high);
        } else if (operator == ComparisonGt.INSTANCE) {
            update = rightIsExpr ? (lowIsMinusInfinity ? null : (Interval)starting.glb((BaseLattice)lowp1_inf)) : (lowIsMinusInfinity ? eval : (Interval)starting.glb((BaseLattice)inf_highm1));
        } else if (operator == ComparisonLe.INSTANCE) {
            update = rightIsExpr ? (Interval)starting.glb((BaseLattice)inf_high) : (lowIsMinusInfinity ? null : (Interval)starting.glb((BaseLattice)low_inf));
        } else if (operator == ComparisonLt.INSTANCE) {
            if (rightIsExpr) {
                update = lowIsMinusInfinity ? eval : (Interval)starting.glb((BaseLattice)inf_highm1);
            } else {
                Interval interval = update = lowIsMinusInfinity ? null : (Interval)starting.glb((BaseLattice)lowp1_inf);
            }
        }
        if (update == null) {
            return environment;
        }
        if (update.isBottom()) {
            return environment.bottom();
        }
        return (ValueEnvironment)environment.putState((Object)id, (Lattice)update);
    }

    @Override
    public int compareTo(Interval o) {
        if (this.isBottom()) {
            return o.isBottom() ? 0 : -1;
        }
        if (this.isTop()) {
            return o.isTop() ? 0 : 1;
        }
        if (o.isBottom()) {
            return 1;
        }
        if (o.isTop()) {
            return -1;
        }
        return this.interval.compareTo(o.interval);
    }
}

