/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.numeric;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.util.representation.SetRepresentation;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class UpperBounds
implements BaseNonRelationalValueDomain<UpperBounds>,
Iterable<Identifier> {
    private static final UpperBounds TOP = new UpperBounds(true);
    private static final UpperBounds BOTTOM = new UpperBounds(new TreeSet<Identifier>());
    private final boolean isTop;
    private final Set<Identifier> bounds;

    public UpperBounds() {
        this(true);
    }

    public UpperBounds(boolean isTop) {
        this.bounds = null;
        this.isTop = isTop;
    }

    public UpperBounds(Set<Identifier> bounds) {
        this.bounds = bounds;
        this.isTop = false;
    }

    public StructuredRepresentation representation() {
        if (this.isTop()) {
            return new StringRepresentation("{}");
        }
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        return new SetRepresentation(this.bounds, StringRepresentation::new);
    }

    public UpperBounds top() {
        return TOP;
    }

    public UpperBounds bottom() {
        return BOTTOM;
    }

    public boolean isBottom() {
        return !this.isTop && this.bounds.isEmpty();
    }

    public UpperBounds lubAux(UpperBounds other) throws SemanticException {
        HashSet<Identifier> lub = new HashSet<Identifier>(this.bounds);
        lub.retainAll(other.bounds);
        return new UpperBounds(lub);
    }

    public UpperBounds glbAux(UpperBounds other) throws SemanticException {
        HashSet<Identifier> lub = new HashSet<Identifier>(this.bounds);
        lub.addAll(other.bounds);
        return new UpperBounds(lub);
    }

    public boolean lessOrEqualAux(UpperBounds other) throws SemanticException {
        return this.bounds.containsAll(other.bounds);
    }

    public UpperBounds wideningAux(UpperBounds other) throws SemanticException {
        return other.bounds.containsAll(this.bounds) ? other : TOP;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpperBounds other = (UpperBounds)obj;
        return Objects.equals(this.bounds, other.bounds) && this.isTop == other.isTop;
    }

    public int hashCode() {
        return Objects.hash(this.bounds, this.isTop);
    }

    public ValueEnvironment<UpperBounds> assumeBinaryExpression(ValueEnvironment<UpperBounds> environment, BinaryOperator operator, ValueExpression left, ValueExpression right, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        if (!(left instanceof Identifier) || !(right instanceof Identifier)) {
            return environment;
        }
        Identifier x = (Identifier)left;
        Identifier y = (Identifier)right;
        if (operator instanceof ComparisonEq) {
            UpperBounds set = (UpperBounds)((UpperBounds)environment.getState((Object)x)).glb((BaseLattice)((UpperBounds)environment.getState((Object)y)));
            return (ValueEnvironment)((ValueEnvironment)environment.putState((Object)x, (Lattice)set)).putState((Object)y, (Lattice)set);
        }
        if (operator instanceof ComparisonLt) {
            UpperBounds set = (UpperBounds)((UpperBounds)((UpperBounds)environment.getState((Object)x)).glb((BaseLattice)((UpperBounds)environment.getState((Object)y)))).glb((BaseLattice)new UpperBounds(Collections.singleton(y)));
            return (ValueEnvironment)environment.putState((Object)x, (Lattice)set);
        }
        if (operator instanceof ComparisonLe) {
            UpperBounds set = (UpperBounds)((UpperBounds)environment.getState((Object)x)).glb((BaseLattice)((UpperBounds)environment.getState((Object)y)));
            return (ValueEnvironment)environment.putState((Object)x, (Lattice)set);
        }
        if (operator instanceof ComparisonGt) {
            UpperBounds set = (UpperBounds)((UpperBounds)((UpperBounds)environment.getState((Object)x)).glb((BaseLattice)((UpperBounds)environment.getState((Object)y)))).glb((BaseLattice)new UpperBounds(Collections.singleton(x)));
            return (ValueEnvironment)environment.putState((Object)y, (Lattice)set);
        }
        if (operator instanceof ComparisonGe) {
            UpperBounds set = (UpperBounds)((UpperBounds)environment.getState((Object)x)).glb((BaseLattice)((UpperBounds)environment.getState((Object)y)));
            return (ValueEnvironment)environment.putState((Object)y, (Lattice)set);
        }
        return environment;
    }

    @Override
    public Iterator<Identifier> iterator() {
        if (this.bounds == null) {
            return Collections.emptyIterator();
        }
        return this.bounds.iterator();
    }

    public boolean contains(Identifier id) {
        return this.bounds != null && this.bounds.contains(id);
    }

    public UpperBounds add(Identifier id) {
        HashSet<Identifier> res = new HashSet<Identifier>();
        if (!this.isTop() && !this.isBottom()) {
            res.addAll(this.bounds);
        }
        res.add(id);
        return new UpperBounds(res);
    }
}

