/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.stability;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.NonRelationalValueDomain;
import it.unive.lisa.analysis.nonrelational.value.ValueEnvironment;
import it.unive.lisa.analysis.stability.Trend;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.SyntheticLocation;
import it.unive.lisa.program.cfg.CodeLocation;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.AdditionOperator;
import it.unive.lisa.symbolic.value.operator.DivisionOperator;
import it.unive.lisa.symbolic.value.operator.MultiplicationOperator;
import it.unive.lisa.symbolic.value.operator.SubtractionOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonEq;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonGt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLe;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonLt;
import it.unive.lisa.symbolic.value.operator.binary.ComparisonNe;
import it.unive.lisa.symbolic.value.operator.unary.NumericNegation;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.representation.ObjectRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class Stability<V extends ValueDomain<V>>
implements BaseLattice<Stability<V>>,
ValueDomain<Stability<V>> {
    private final V aux;
    private final ValueEnvironment<Trend> trends;

    public Stability(V aux) {
        this.aux = (ValueDomain)aux.top();
        this.trends = new ValueEnvironment((NonRelationalValueDomain)Trend.TOP);
    }

    public Stability(V aux, ValueEnvironment<Trend> trends) {
        this.aux = trends.isBottom() ? (ValueDomain)aux.bottom() : aux;
        this.trends = aux.isBottom() ? trends.bottom() : trends;
    }

    public Stability<V> lubAux(Stability<V> other) throws SemanticException {
        ValueDomain ad = (ValueDomain)this.aux.lub(other.aux);
        ValueEnvironment t = (ValueEnvironment)this.trends.lub(other.trends);
        if (ad.isBottom() || t.isBottom()) {
            return this.bottom();
        }
        return new Stability<ValueDomain>(ad, (ValueEnvironment<Trend>)t);
    }

    public Stability<V> glbAux(Stability<V> other) throws SemanticException {
        ValueDomain ad = (ValueDomain)this.aux.glb(other.aux);
        ValueEnvironment t = (ValueEnvironment)this.trends.glb(other.trends);
        if (ad.isBottom() || t.isBottom()) {
            return this.bottom();
        }
        return new Stability<ValueDomain>(ad, (ValueEnvironment<Trend>)t);
    }

    public Stability<V> wideningAux(Stability<V> other) throws SemanticException {
        ValueDomain ad = (ValueDomain)this.aux.widening(other.aux);
        ValueEnvironment t = (ValueEnvironment)this.trends.widening(other.trends);
        if (ad.isBottom() || t.isBottom()) {
            return this.bottom();
        }
        return new Stability<ValueDomain>(ad, (ValueEnvironment<Trend>)t);
    }

    public boolean lessOrEqualAux(Stability<V> other) throws SemanticException {
        return this.aux.lessOrEqual(other.aux) && this.trends.lessOrEqual(other.trends);
    }

    public boolean isTop() {
        return this.aux.isTop() && this.trends.isTop();
    }

    public boolean isBottom() {
        return this.aux.isBottom() || this.trends.isBottom();
    }

    public Stability<V> top() {
        return new Stability<ValueDomain>((ValueDomain)this.aux.top(), (ValueEnvironment<Trend>)this.trends.top());
    }

    public Stability<V> bottom() {
        return new Stability<ValueDomain>((ValueDomain)this.aux.bottom(), (ValueEnvironment<Trend>)this.trends.bottom());
    }

    public Stability<V> pushScope(ScopeToken token) throws SemanticException {
        return new Stability<ValueDomain>((ValueDomain)this.aux.pushScope(token), (ValueEnvironment<Trend>)((ValueEnvironment)this.trends.pushScope(token)));
    }

    public Stability<V> popScope(ScopeToken token) throws SemanticException {
        return new Stability<ValueDomain>((ValueDomain)this.aux.popScope(token), (ValueEnvironment<Trend>)((ValueEnvironment)this.trends.popScope(token)));
    }

    private boolean query(BinaryExpression query, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.aux.satisfies((SymbolicExpression)query, pp, oracle) == Satisfiability.SATISFIED;
    }

    private BinaryExpression binary(BinaryOperator operator, SymbolicExpression l, SymbolicExpression r, ProgramPoint pp) {
        return new BinaryExpression((Type)pp.getProgram().getTypes().getBooleanType(), l, r, operator, (CodeLocation)SyntheticLocation.INSTANCE);
    }

    private Constant constantInt(int c, ProgramPoint pp) {
        return new Constant((Type)pp.getProgram().getTypes().getIntegerType(), (Object)c, (CodeLocation)SyntheticLocation.INSTANCE);
    }

    private Trend increasingIfGreater(SymbolicExpression a, SymbolicExpression b, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.STABLE;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonGt.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.INC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonGe.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.NON_DEC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonLt.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.DEC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonLe.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.NON_INC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonNe.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.NON_STABLE;
        }
        return Trend.TOP;
    }

    private Trend increasingIfLess(SymbolicExpression a, SymbolicExpression b, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.increasingIfGreater(a, b, pp, oracle).invert();
    }

    private Trend nonDecreasingIfGreater(SymbolicExpression a, SymbolicExpression b, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.STABLE;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonGt.INSTANCE, a, b, pp), pp, oracle) || this.query(this.binary((BinaryOperator)ComparisonGe.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.NON_DEC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonLt.INSTANCE, a, b, pp), pp, oracle) || this.query(this.binary((BinaryOperator)ComparisonLe.INSTANCE, a, b, pp), pp, oracle)) {
            return Trend.NON_INC;
        }
        return Trend.TOP;
    }

    private Trend nonDecreasingIfLess(SymbolicExpression a, SymbolicExpression b, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.nonDecreasingIfGreater(a, b, pp, oracle).invert();
    }

    private Trend increasingIfBetweenZeroAndOne(SymbolicExpression a, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        Constant zero = this.constantInt(0, pp);
        Constant one = this.constantInt(1, pp);
        if (this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) || this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.STABLE;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonGt.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) && this.query(this.binary((BinaryOperator)ComparisonLt.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.INC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonGe.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) && this.query(this.binary((BinaryOperator)ComparisonLe.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.NON_DEC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonLt.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) && this.query(this.binary((BinaryOperator)ComparisonGt.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.DEC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonLe.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) && this.query(this.binary((BinaryOperator)ComparisonGe.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.NON_INC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonNe.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) && this.query(this.binary((BinaryOperator)ComparisonNe.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.NON_STABLE;
        }
        return Trend.TOP;
    }

    private Trend increasingIfOutsideZeroAndOne(SymbolicExpression a, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.increasingIfBetweenZeroAndOne(a, pp, oracle).invert();
    }

    private Trend nonDecreasingIfBetweenZeroAndOne(SymbolicExpression a, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        Constant zero = this.constantInt(0, pp);
        Constant one = this.constantInt(1, pp);
        if (this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) || this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.STABLE;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonGe.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) && this.query(this.binary((BinaryOperator)ComparisonLe.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.NON_DEC;
        }
        if (this.query(this.binary((BinaryOperator)ComparisonLe.INSTANCE, a, (SymbolicExpression)zero, pp), pp, oracle) || this.query(this.binary((BinaryOperator)ComparisonGe.INSTANCE, a, (SymbolicExpression)one, pp), pp, oracle)) {
            return Trend.NON_INC;
        }
        return Trend.TOP;
    }

    private Trend nonDecreasingIfOutsideZeroAndOne(SymbolicExpression a, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.nonDecreasingIfBetweenZeroAndOne(a, pp, oracle).invert();
    }

    public Stability<V> assign(Identifier id, ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return this.bottom();
        }
        ValueDomain post = (ValueDomain)this.aux.assign(id, (SymbolicExpression)expression, pp, oracle);
        if (post.isBottom()) {
            return this.bottom();
        }
        if (!((Trend)this.trends.lattice).canProcess((SymbolicExpression)id, pp, oracle) || !((Trend)this.trends.lattice).canProcess((SymbolicExpression)expression, pp, oracle)) {
            return new Stability<ValueDomain>(post, this.trends);
        }
        if (!this.trends.knowsIdentifier(id)) {
            return new Stability<ValueDomain>(post, (ValueEnvironment<Trend>)((ValueEnvironment)this.trends.putState((Object)id, (Lattice)Trend.STABLE)));
        }
        Trend t = Trend.TOP;
        if (expression instanceof Constant) {
            t = this.increasingIfLess((SymbolicExpression)id, (SymbolicExpression)expression, pp, oracle);
        } else if (expression instanceof UnaryExpression && ((UnaryExpression)expression).getOperator() instanceof NumericNegation) {
            t = this.increasingIfLess((SymbolicExpression)id, (SymbolicExpression)expression, pp, oracle);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expression;
            BinaryOperator op = be.getOperator();
            SymbolicExpression left = be.getLeft();
            SymbolicExpression right = be.getRight();
            boolean isLeft = id.equals((Object)left);
            boolean isRight = id.equals((Object)right);
            if (op instanceof DivisionOperator && this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, right, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                return this.bottom();
            }
            if (isLeft || isRight) {
                SymbolicExpression other;
                SymbolicExpression symbolicExpression = other = isLeft ? right : left;
                if (op instanceof AdditionOperator) {
                    t = this.increasingIfGreater(other, (SymbolicExpression)this.constantInt(0, pp), pp, oracle);
                } else if (op instanceof SubtractionOperator) {
                    t = isLeft ? this.increasingIfLess(other, (SymbolicExpression)this.constantInt(0, pp), pp, oracle) : this.increasingIfLess((SymbolicExpression)id, (SymbolicExpression)expression, pp, oracle);
                } else if (op instanceof MultiplicationOperator) {
                    if (this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle) || this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, other, (SymbolicExpression)this.constantInt(1, pp), pp), pp, oracle)) {
                        t = Trend.STABLE;
                    } else if (this.query(this.binary((BinaryOperator)ComparisonGt.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                        t = this.increasingIfGreater(other, (SymbolicExpression)this.constantInt(1, pp), pp, oracle);
                    } else if (this.query(this.binary((BinaryOperator)ComparisonLt.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                        t = this.increasingIfLess(other, (SymbolicExpression)this.constantInt(1, pp), pp, oracle);
                    } else if (this.query(this.binary((BinaryOperator)ComparisonGe.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                        t = this.nonDecreasingIfGreater(other, (SymbolicExpression)this.constantInt(1, pp), pp, oracle);
                    } else if (this.query(this.binary((BinaryOperator)ComparisonLe.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                        t = this.nonDecreasingIfLess(other, (SymbolicExpression)this.constantInt(1, pp), pp, oracle);
                    } else if (this.query(this.binary((BinaryOperator)ComparisonNe.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle) && this.query(this.binary((BinaryOperator)ComparisonNe.INSTANCE, other, (SymbolicExpression)this.constantInt(1, pp), pp), pp, oracle)) {
                        t = Trend.NON_STABLE;
                    }
                } else if (op instanceof DivisionOperator) {
                    if (isLeft) {
                        if (this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle) || this.query(this.binary((BinaryOperator)ComparisonEq.INSTANCE, other, (SymbolicExpression)this.constantInt(1, pp), pp), pp, oracle)) {
                            t = Trend.STABLE;
                        } else if (this.query(this.binary((BinaryOperator)ComparisonGt.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                            t = this.increasingIfBetweenZeroAndOne(other, pp, oracle);
                        } else if (this.query(this.binary((BinaryOperator)ComparisonLt.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                            t = this.increasingIfOutsideZeroAndOne(other, pp, oracle);
                        } else if (this.query(this.binary((BinaryOperator)ComparisonGe.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                            t = this.nonDecreasingIfBetweenZeroAndOne(other, pp, oracle);
                        } else if (this.query(this.binary((BinaryOperator)ComparisonLe.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle)) {
                            t = this.nonDecreasingIfOutsideZeroAndOne(other, pp, oracle);
                        } else if (this.query(this.binary((BinaryOperator)ComparisonNe.INSTANCE, (SymbolicExpression)id, (SymbolicExpression)this.constantInt(0, pp), pp), pp, oracle) && this.query(this.binary((BinaryOperator)ComparisonNe.INSTANCE, other, (SymbolicExpression)this.constantInt(1, pp), pp), pp, oracle)) {
                            t = Trend.NON_STABLE;
                        }
                    } else {
                        t = this.increasingIfLess((SymbolicExpression)id, (SymbolicExpression)expression, pp, oracle);
                    }
                }
            } else {
                t = this.increasingIfLess((SymbolicExpression)id, (SymbolicExpression)expression, pp, oracle);
            }
        }
        ValueEnvironment trnd = (ValueEnvironment)Stability.stabilize(this.trends).putState((Object)id, (Lattice)t);
        if (trnd.isBottom()) {
            return this.bottom();
        }
        return new Stability<ValueDomain>(post, (ValueEnvironment<Trend>)trnd);
    }

    public Stability<V> smallStepSemantics(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        ValueDomain post = (ValueDomain)this.aux.smallStepSemantics((SymbolicExpression)expression, pp, oracle);
        ValueEnvironment sss = (ValueEnvironment)Stability.stabilize(this.trends).smallStepSemantics((SymbolicExpression)expression, pp, oracle);
        if (post.isBottom() || sss.isBottom()) {
            return this.bottom();
        }
        return new Stability<ValueDomain>(post, (ValueEnvironment<Trend>)sss);
    }

    public Stability<V> assume(ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        ValueDomain post = (ValueDomain)this.aux.assume((SymbolicExpression)expression, src, dest, oracle);
        ValueEnvironment assume = (ValueEnvironment)this.trends.assume((SymbolicExpression)expression, src, dest, oracle);
        if (post.isBottom() || assume.isBottom()) {
            return this.bottom();
        }
        return new Stability<ValueDomain>(post, (ValueEnvironment<Trend>)assume);
    }

    public boolean knowsIdentifier(Identifier id) {
        return this.aux.knowsIdentifier(id) || this.trends.knowsIdentifier(id);
    }

    public Stability<V> forgetIdentifier(Identifier id) throws SemanticException {
        return new Stability<ValueDomain>((ValueDomain)this.aux.forgetIdentifier(id), (ValueEnvironment<Trend>)((ValueEnvironment)this.trends.forgetIdentifier(id)));
    }

    public Stability<V> forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        return new Stability<ValueDomain>((ValueDomain)this.aux.forgetIdentifiersIf(test), (ValueEnvironment<Trend>)((ValueEnvironment)this.trends.forgetIdentifiersIf(test)));
    }

    public Satisfiability satisfies(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.aux.satisfies((SymbolicExpression)expression, pp, oracle);
    }

    public StructuredRepresentation representation() {
        return new ObjectRepresentation(Map.of("aux", this.aux.representation(), "trends", this.trends.representation()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stability other = (Stability)obj;
        return Objects.equals(this.aux, other.aux) && Objects.equals(this.trends, other.trends);
    }

    public int hashCode() {
        return Objects.hash(this.aux, this.trends);
    }

    public String toString() {
        return this.representation().toString();
    }

    public ValueEnvironment<Trend> getTrends() {
        return this.trends;
    }

    public V getAuxiliaryDomain() {
        return this.aux;
    }

    public Stability<V> combine(Stability<V> other) throws SemanticException {
        ValueEnvironment result = new ValueEnvironment((NonRelationalValueDomain)((Trend)other.trends.lattice), other.trends.function);
        for (Identifier id : other.trends.getKeys()) {
            if (!this.trends.knowsIdentifier(id)) continue;
            Trend tmp = ((Trend)this.trends.getState((Object)id)).combine((Trend)other.trends.getState((Object)id));
            result = (ValueEnvironment)result.putState((Object)id, (Lattice)tmp);
        }
        return new Stability<V>(other.aux, (ValueEnvironment<Trend>)result);
    }

    public Map<Trend, Set<Identifier>> getCovarianceClasses() {
        HashMap<Trend, Set<Identifier>> map = new HashMap<Trend, Set<Identifier>>();
        for (Identifier id : this.trends.getKeys()) {
            Trend t = (Trend)this.trends.getState((Object)id);
            map.computeIfAbsent(t, k -> new HashSet()).add(id);
        }
        return map;
    }

    private static ValueEnvironment<Trend> stabilize(ValueEnvironment<Trend> trends) {
        ValueEnvironment result = new ValueEnvironment((NonRelationalValueDomain)((Trend)trends.lattice));
        for (Identifier id : trends.getKeys()) {
            result = (ValueEnvironment)result.putState((Object)id, (Lattice)Trend.STABLE);
        }
        return result;
    }
}

