/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.bricks;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.string.bricks.Bricks;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.numeric.MathNumberConversionException;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class Brick
implements BaseNonRelationalValueDomain<Brick> {
    private final Set<String> strings;
    private final IntInterval interval;
    private static final Brick TOP = new Brick();
    private static final Brick BOTTOM = new Brick(new IntInterval(1, 1), new TreeSet<String>());

    public Brick() {
        this(new IntInterval(new MathNumber(0L), MathNumber.PLUS_INFINITY), null);
    }

    public Brick(int min, int max, Set<String> strings) {
        if (min < 0 || max < 0) {
            throw new IllegalArgumentException();
        }
        this.interval = new IntInterval(min, max);
        this.strings = strings;
    }

    public Brick(MathNumber min, MathNumber max, Set<String> strings) {
        this.interval = new IntInterval(min, max);
        this.strings = strings;
    }

    public Brick(IntInterval interval, Set<String> strings) {
        this.interval = interval;
        this.strings = strings;
    }

    public Brick lubAux(Brick other) throws SemanticException {
        TreeSet<String> resultStrings;
        if (this.strings == null || other.strings == null) {
            resultStrings = null;
        } else {
            resultStrings = new TreeSet<String>();
            resultStrings.addAll(this.strings);
            resultStrings.addAll(other.strings);
        }
        return new Brick(this.getMin().min(other.getMin()), this.getMax().max(other.getMax()), resultStrings);
    }

    public boolean lessOrEqualAux(Brick other) throws SemanticException {
        if (this.getMin().lt(other.getMin())) {
            return false;
        }
        if (this.getMax().gt(other.getMax())) {
            return false;
        }
        if (other.strings == null) {
            return true;
        }
        if (this.strings == null) {
            return false;
        }
        if (this.strings.size() > other.strings.size()) {
            return false;
        }
        return other.strings.containsAll(this.strings);
    }

    public Brick wideningAux(Brick other) throws SemanticException {
        MathNumber minOfMins = this.getMin().min(other.getMin());
        MathNumber maxOfMaxs = this.getMax().max(other.getMax());
        TreeSet<String> resultSet = new TreeSet<String>(this.getStrings());
        resultSet.addAll(other.getStrings());
        if (resultSet.size() > Bricks.kS) {
            return TOP;
        }
        if (maxOfMaxs.subtract(minOfMins).geq(new MathNumber((long)Bricks.kI))) {
            IntInterval interval = new IntInterval(MathNumber.ZERO, MathNumber.PLUS_INFINITY);
            return new Brick(interval, resultSet);
        }
        return new Brick(minOfMins, maxOfMaxs, resultSet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Brick brick = (Brick)o;
        return Objects.equals(this.strings, brick.strings) && Objects.equals(this.interval, brick.interval);
    }

    public int hashCode() {
        return Objects.hash(this.strings, this.interval);
    }

    public MathNumber getMin() {
        return this.interval.getLow();
    }

    public MathNumber getMax() {
        return this.interval.getHigh();
    }

    public Set<String> getStrings() {
        return this.strings;
    }

    public Brick top() {
        return TOP;
    }

    public Brick bottom() {
        return BOTTOM;
    }

    public boolean isTop() {
        return this == TOP || this.equals(TOP);
    }

    public boolean isFinite() {
        return this.getMax().isFinite() && this.strings != null;
    }

    public Set<String> getReps() {
        if (!this.isFinite()) {
            throw new IllegalStateException("Brick must be finite.");
        }
        TreeSet<String> reps = new TreeSet<String>();
        try {
            if (this.strings.size() == 1) {
                String element = this.strings.iterator().next();
                reps.add(element.repeat(this.getMin().toInt()));
                reps.add(element.repeat(this.getMax().toInt()));
                return reps;
            }
            this.recGetReps(reps, this.getMin().toInt(), 0, "");
        }
        catch (MathNumberConversionException e) {
            throw new IllegalStateException("Brick must be finite.");
        }
        return reps;
    }

    private void recGetReps(Set<String> reps, int min, int numberOfReps, String currentStr) throws MathNumberConversionException {
        if (!this.isFinite()) {
            throw new IllegalStateException("Brick must be finite.");
        }
        if (min > this.getMax().toInt() && numberOfReps >= this.getMin().toInt()) {
            reps.add(currentStr);
        } else {
            for (String string : this.strings) {
                if (!(currentStr.equals("") && this.getMin().toInt() != 0 || numberOfReps < this.getMin().toInt())) {
                    reps.add(currentStr);
                }
                this.recGetReps(reps, min + 1, numberOfReps + 1, currentStr + string);
            }
        }
    }

    public String toString() {
        return this.representation().toString();
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation("[{" + (this.strings == null ? "#TOP#" : StringUtils.join(this.strings, (String)", ")) + "}](" + this.interval.getLow() + "," + this.interval.getHigh() + ")");
    }
}

