/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.fsa;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.numeric.Interval;
import it.unive.lisa.analysis.string.ContainsCharProvider;
import it.unive.lisa.analysis.string.fsa.SimpleAutomaton;
import it.unive.lisa.analysis.string.fsa.StringSymbol;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.StringConcat;
import it.unive.lisa.symbolic.value.operator.binary.StringContains;
import it.unive.lisa.symbolic.value.operator.ternary.StringReplace;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.util.collections.workset.FIFOWorkingSet;
import it.unive.lisa.util.datastructures.automaton.CyclicAutomatonException;
import it.unive.lisa.util.datastructures.automaton.State;
import it.unive.lisa.util.datastructures.automaton.Transition;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.numeric.MathNumberConversionException;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class FSA
implements BaseNonRelationalValueDomain<FSA>,
ContainsCharProvider {
    private static final FSA TOP = new FSA(new SimpleAutomaton("").unknownString());
    public static final int WIDENING_TH = 5;
    private final SimpleAutomaton a;

    public FSA() {
        this.a = new SimpleAutomaton("").emptyLanguage();
    }

    public FSA(SimpleAutomaton a) {
        this.a = a;
    }

    public FSA lubAux(FSA other) throws SemanticException {
        return new FSA((SimpleAutomaton)((SimpleAutomaton)this.a.union(other.a)).minimize());
    }

    public FSA glbAux(FSA other) throws SemanticException {
        return new FSA((SimpleAutomaton)((SimpleAutomaton)this.a.intersection(other.a)).minimize());
    }

    public FSA wideningAux(FSA other) throws SemanticException {
        return new FSA((SimpleAutomaton)((SimpleAutomaton)this.a.union(other.a)).widening(this.getSizeDiffCapped(other)));
    }

    public int size() {
        return this.a.getStates().size();
    }

    private int getSizeDiffCapped(FSA other) {
        int otherSize;
        int size = this.size();
        if (size > (otherSize = other.size())) {
            return Math.min(size - otherSize, 5);
        }
        if (size < otherSize) {
            return Math.min(otherSize - size, 5);
        }
        return 5;
    }

    public boolean lessOrEqualAux(FSA other) throws SemanticException {
        return this.a.isContained(other.a);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FSA fsa = (FSA)o;
        return Objects.equals((Object)this.a, (Object)fsa.a);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.a});
    }

    public FSA top() {
        return TOP;
    }

    public boolean isBottom() {
        return !this.isTop() && this.a.acceptsEmptyLanguage();
    }

    public FSA bottom() {
        TreeSet<State> states = new TreeSet<State>();
        states.add(new State(0, true, false));
        return new FSA(new SimpleAutomaton(states, new TreeSet<Transition<StringSymbol>>()));
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation((Object)this.a.toRegex().simplify());
    }

    public FSA evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (constant.getValue() instanceof String) {
            return new FSA(new SimpleAutomaton((String)constant.getValue()));
        }
        return this.top();
    }

    public FSA evalBinaryExpression(BinaryOperator operator, FSA left, FSA right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringConcat.INSTANCE) {
            return new FSA((SimpleAutomaton)left.a.concat(right.a));
        }
        return this.top();
    }

    public FSA evalTernaryExpression(TernaryOperator operator, FSA left, FSA middle, FSA right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringReplace.INSTANCE) {
            try {
                return new FSA(left.a.replace(middle.a, right.a));
            }
            catch (CyclicAutomatonException e) {
                return TOP;
            }
        }
        return TOP;
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, FSA left, FSA right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringContains.INSTANCE) {
            return left.contains(right);
        }
        return Satisfiability.UNKNOWN;
    }

    public FSA substring(long begin, long end) throws CyclicAutomatonException {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        if (!this.a.hasCycle()) {
            SimpleAutomaton result = this.a.emptyLanguage();
            Iterator iterator = this.a.getLanguage().iterator();
            if (iterator.hasNext()) {
                String s2 = (String)iterator.next();
                result = begin < (long)s2.length() && end < (long)s2.length() ? (SimpleAutomaton)result.union(new SimpleAutomaton(s2.substring((int)begin, (int)end))) : (SimpleAutomaton)result.union(new SimpleAutomaton(""));
                return new FSA(result);
            }
        }
        SimpleAutomaton[] array = (SimpleAutomaton[])this.a.toRegex().substring((int)begin, (int)end).parallelStream().map(s -> new SimpleAutomaton(s.toString())).toArray(SimpleAutomaton[]::new);
        SimpleAutomaton result = this.a.emptyLanguage();
        for (int i = 0; i < array.length; ++i) {
            result = (SimpleAutomaton)result.union(array[i]);
        }
        return new FSA(result);
    }

    public IntInterval length() {
        return new IntInterval(this.a.toRegex().minLength(), this.a.lenghtOfLongestString());
    }

    public IntInterval indexOf(FSA s) throws CyclicAutomatonException {
        if (this.a.hasCycle()) {
            return this.mkInterval(-1, null);
        }
        if (!this.a.hasCycle() && !s.a.hasCycle()) {
            SortedSet first = this.a.getLanguage();
            SortedSet second = s.a.getLanguage();
            IntInterval result = null;
            for (String f1 : first) {
                for (String f2 : second) {
                    IntInterval partial;
                    if (f1.contains(f2)) {
                        int i2 = f1.indexOf(f2);
                        partial = this.mkInterval(i2, i2);
                    } else {
                        partial = this.mkInterval(-1, -1);
                    }
                    result = result == null ? partial : this.mkInterval(partial, result);
                }
            }
            return result;
        }
        HashSet<Integer> indexesOf = new HashSet<Integer>();
        for (State q : this.a.getStates()) {
            SimpleAutomaton build = (SimpleAutomaton)this.a.factorsChangingInitialState(q);
            if (((SimpleAutomaton)build.intersection(s.a)).acceptsEmptyLanguage()) continue;
            indexesOf.add(this.a.maximumPath(q, q).size() - 1);
        }
        if (indexesOf.isEmpty()) {
            return this.mkInterval(-1, -1);
        }
        if (s.a.recognizesExactlyOneString() && this.a.recognizesExactlyOneString()) {
            return this.mkInterval(indexesOf.stream().mapToInt(i -> i).min().getAsInt(), indexesOf.stream().mapToInt(i -> i).max().getAsInt());
        }
        return this.mkInterval(-1, indexesOf.stream().mapToInt(i -> i).max().getAsInt());
    }

    public FSA concat(FSA other) {
        return new FSA((SimpleAutomaton)this.a.concat(other.a));
    }

    private IntInterval mkInterval(Integer min, Integer max) {
        return new IntInterval(min, max);
    }

    private IntInterval mkInterval(IntInterval first, IntInterval second) {
        MathNumber newLow = first.getLow().min(second.getLow());
        MathNumber newHigh = first.getHigh().max(second.getHigh());
        return new IntInterval(newLow, newHigh);
    }

    public Satisfiability contains(FSA other) {
        if (other.a.isEqualTo(this.a.emptyString())) {
            return Satisfiability.SATISFIED;
        }
        if (((SimpleAutomaton)((SimpleAutomaton)this.a.factors()).intersection(other.a)).acceptsEmptyLanguage()) {
            return Satisfiability.NOT_SATISFIED;
        }
        try {
            SortedSet rightLang = other.a.getLanguage();
            SortedSet leftLang = this.a.getLanguage();
            if (rightLang.size() == 1 && rightLang.contains("")) {
                return Satisfiability.SATISFIED;
            }
            boolean atLeastOne = false;
            boolean all = true;
            for (String a : leftLang) {
                for (String b : rightLang) {
                    boolean cont = a.contains(b);
                    atLeastOne = atLeastOne || cont;
                    all = all && cont;
                }
            }
            if (all) {
                return Satisfiability.SATISFIED;
            }
            if (atLeastOne) {
                return Satisfiability.UNKNOWN;
            }
            return Satisfiability.NOT_SATISFIED;
        }
        catch (CyclicAutomatonException e) {
            return Satisfiability.UNKNOWN;
        }
    }

    public FSA replace(FSA search, FSA repl) {
        try {
            return new FSA(this.a.replace(search.a, repl.a));
        }
        catch (CyclicAutomatonException e) {
            return TOP;
        }
    }

    @Override
    public Satisfiability containsChar(char c) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        if (!this.a.hasCycle()) {
            Satisfiability sat = Satisfiability.BOTTOM;
            try {
                for (String s : this.a.getLanguage()) {
                    if (s.contains(String.valueOf(c))) {
                        sat = (Satisfiability)sat.lub((Lattice)Satisfiability.SATISFIED);
                        continue;
                    }
                    sat = (Satisfiability)sat.lub((Lattice)Satisfiability.NOT_SATISFIED);
                }
            }
            catch (CyclicAutomatonException cyclicAutomatonException) {
                // empty catch block
            }
            return sat;
        }
        FIFOWorkingSet ws = FIFOWorkingSet.mk();
        TreeSet<State> visited = new TreeSet<State>();
        for (State q : this.a.getInitialStates()) {
            ws.push((Object)q);
        }
        while (!ws.isEmpty()) {
            State top = (State)ws.pop();
            for (Transition tr : this.a.getOutgoingTransitionsFrom(top)) {
                if (!((StringSymbol)tr.getSymbol()).getSymbol().equals(String.valueOf(c))) continue;
                return Satisfiability.SATISFIED;
            }
            visited.add(top);
            for (Transition tr : this.a.getOutgoingTransitionsFrom(top)) {
                if (visited.contains(tr.getDestination())) {
                    return Satisfiability.UNKNOWN;
                }
                ws.push((Object)tr.getDestination());
            }
        }
        return Satisfiability.NOT_SATISFIED;
    }

    public FSA trim() {
        if (this.isBottom() || this.isTop()) {
            return this;
        }
        return new FSA(this.a.trim());
    }

    public FSA repeat(Interval i) throws MathNumberConversionException {
        if (this.isBottom() || this.isTop()) {
            return this;
        }
        return new FSA(this.a.repeat(i));
    }
}

