/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.tarsis;

import it.unive.lisa.analysis.string.tarsis.RegexAutomaton;
import it.unive.lisa.analysis.string.tarsis.StringSearcher;
import it.unive.lisa.util.datastructures.automaton.CyclicAutomatonException;
import it.unive.lisa.util.datastructures.automaton.Transition;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.datastructures.regex.TopAtom;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class IndexFinder {
    public static Pair<Integer, Integer> findIndexesOf(RegexAutomaton automaton, RegexAutomaton search) throws CyclicAutomatonException {
        RegexAutomaton exploded = automaton.explode();
        StringSearcher searcher = new StringSearcher(exploded);
        Set allPaths = exploded.getAllPaths();
        Set topTransitions = exploded.getTransitions().parallelStream().filter(t -> t.getSymbol() == TopAtom.INSTANCE).collect(Collectors.toSet());
        int min = Integer.MAX_VALUE;
        int max = -1;
        boolean maxIsInfinity = true;
        for (String s : search.getLanguage()) {
            if (s.isEmpty()) {
                return Pair.of((Object)0, automaton.acceptsTopEventually() || automaton.hasCycle() ? null : Integer.valueOf(automaton.lenghtOfLongestString()));
            }
            Set<Vector<Transition<RegularExpression>>> matching = searcher.searchInAllPaths(s);
            for (List p : allPaths) {
                int lower = Integer.MAX_VALUE;
                boolean isInfinity = false;
                int missing = 0;
                for (Vector<Transition<RegularExpression>> match : matching) {
                    int index = p.indexOf(match.firstElement().getSource());
                    if (index != -1 && (match.size() < 2 || p.indexOf(match.get(1).getSource()) == index + 1)) {
                        int i = index;
                        long tops = topTransitions.parallelStream().map(t -> Pair.of((Object)t.getSource(), (Object)t.getDestination())).map(pair -> Pair.of((Object)p.indexOf(pair.getLeft()), (Object)p.indexOf(pair.getRight()))).filter(pair -> (Integer)pair.getLeft() == (Integer)pair.getRight() - 1).filter(pair -> (Integer)pair.getLeft() < i).count();
                        if ((index = (int)((long)index - tops)) > lower) continue;
                        if (tops > 0L) {
                            if (index < lower) {
                                isInfinity = true;
                            }
                        } else {
                            isInfinity = false;
                        }
                        lower = index;
                        continue;
                    }
                    ++missing;
                }
                if (missing == matching.size()) {
                    min = -1;
                } else if (lower <= min) {
                    if (isInfinity) {
                        if (lower < min) {
                            maxIsInfinity = true;
                        }
                    } else {
                        maxIsInfinity = false;
                    }
                    min = lower;
                }
                if (lower < max) continue;
                if (isInfinity) {
                    if (lower > max) {
                        maxIsInfinity = true;
                    }
                } else {
                    maxIsInfinity = false;
                }
                max = lower;
            }
        }
        return Pair.of((Object)min, (Object)(maxIsInfinity ? null : Integer.valueOf(max)));
    }
}

