/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.tarsis;

import it.unive.lisa.analysis.string.tarsis.RegexAutomaton;
import it.unive.lisa.analysis.string.tarsis.StringSearcher;
import it.unive.lisa.util.datastructures.automaton.State;
import it.unive.lisa.util.datastructures.automaton.Transition;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.Atom;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class StringReplacer {
    private final RegexAutomaton origin;
    private final StringSearcher searcher;

    public StringReplacer(RegexAutomaton origin) {
        this.origin = origin.explode();
        this.searcher = new StringSearcher(origin);
    }

    public RegexAutomaton replace(String toReplace, RegexAutomaton str, boolean must) {
        if (toReplace.isEmpty()) {
            return this.emptyStringReplace(str);
        }
        Set<Vector<Transition<RegularExpression>>> replaceablePaths = this.searcher.searchInAllPaths(toReplace);
        if (replaceablePaths.isEmpty()) {
            return this.origin;
        }
        RegexAutomaton replaced = must ? str : (RegexAutomaton)str.union(this.origin.singleString(toReplace));
        AtomicInteger counter = new AtomicInteger();
        for (Vector<Transition<RegularExpression>> path : replaceablePaths) {
            HashSet<State> statesToRemove = new HashSet<State>();
            HashSet<Transition<RegularExpression>> edgesToRemove = new HashSet<Transition<RegularExpression>>();
            for (int i = path.size() - 1; i >= 0; --i) {
                Transition<RegularExpression> t = path.get(i);
                if (i == path.size() - 1) {
                    edgesToRemove.add(t);
                    continue;
                }
                if (this.origin.getOutgoingTransitionsFrom(t.getDestination()).size() >= 2) break;
                edgesToRemove.add(t);
                statesToRemove.add(t.getDestination());
            }
            this.origin.removeTransitions(edgesToRemove);
            this.origin.removeStates(statesToRemove);
            HashMap<State, State> conversion = new HashMap<State, State>();
            HashSet<State> states = new HashSet<State>();
            HashSet<Transition> delta = new HashSet<Transition>();
            Function<State, State> maker = s -> new State(counter.getAndIncrement(), false, false);
            for (State origin : replaced.getStates()) {
                State r = conversion.computeIfAbsent(origin, maker);
                states.add(r);
                for (Transition t : replaced.getOutgoingTransitionsFrom(origin)) {
                    State dest = conversion.computeIfAbsent(t.getDestination(), maker);
                    states.add(dest);
                    delta.add(new Transition(r, dest, (TransitionSymbol)((RegularExpression)t.getSymbol())));
                }
            }
            states.forEach(arg_0 -> ((RegexAutomaton)this.origin).addState(arg_0));
            delta.forEach(arg_0 -> ((RegexAutomaton)this.origin).addTransition(arg_0));
            for (State s2 : replaced.getInitialStates()) {
                this.origin.addTransition(path.firstElement().getSource(), (State)conversion.get(s2), (TransitionSymbol)Atom.EPSILON);
            }
            for (State f : replaced.getFinalStates()) {
                this.origin.addTransition((State)conversion.get(f), path.lastElement().getDestination(), (TransitionSymbol)Atom.EPSILON);
            }
        }
        return this.origin;
    }

    private RegexAutomaton emptyStringReplace(RegexAutomaton str) {
        State dest;
        State r;
        HashMap<State, State> conversion;
        int maxId = this.origin.getStates().stream().mapToInt(s -> s.getId()).max().getAsInt();
        AtomicInteger counter = new AtomicInteger(maxId + 1);
        TreeSet<State> states = new TreeSet<State>();
        TreeSet<Transition<RegularExpression>> delta = new TreeSet<Transition<RegularExpression>>();
        HashMap mapper = new HashMap();
        this.origin.getStates().forEach(s -> mapper.put(s, new State(s.getId(), s.isInitial(), false)));
        states.addAll(mapper.values());
        Function<State, State> maker = s -> new State(counter.getAndIncrement(), false, false);
        for (Transition t : this.origin.getTransitions()) {
            conversion = new HashMap<State, State>();
            for (State origin : str.getStates()) {
                r = conversion.computeIfAbsent(origin, maker);
                states.add(r);
                for (Transition tt : str.getOutgoingTransitionsFrom(origin)) {
                    dest = conversion.computeIfAbsent(tt.getDestination(), maker);
                    states.add(dest);
                    delta.add((Transition<RegularExpression>)new Transition(r, dest, (TransitionSymbol)((RegularExpression)tt.getSymbol())));
                }
            }
            for (State s2 : str.getInitialStates()) {
                delta.add((Transition<RegularExpression>)new Transition((State)mapper.get(t.getSource()), (State)conversion.get(s2), (TransitionSymbol)Atom.EPSILON));
            }
            for (State f : str.getFinalStates()) {
                delta.add((Transition<RegularExpression>)new Transition((State)conversion.get(f), (State)mapper.get(t.getDestination()), (TransitionSymbol)((RegularExpression)t.getSymbol())));
            }
        }
        maker = s -> new State(counter.getAndIncrement(), false, s.isFinal());
        for (State f : this.origin.getFinalStates()) {
            conversion = new HashMap();
            for (State origin : str.getStates()) {
                r = conversion.computeIfAbsent(origin, maker);
                states.add(r);
                for (Transition tt : str.getOutgoingTransitionsFrom(origin)) {
                    dest = conversion.computeIfAbsent(tt.getDestination(), maker);
                    states.add(dest);
                    delta.add((Transition<RegularExpression>)new Transition(r, dest, (TransitionSymbol)((RegularExpression)tt.getSymbol())));
                }
            }
            for (State s2 : str.getInitialStates()) {
                delta.add((Transition<RegularExpression>)new Transition(f, (State)conversion.get(s2), (TransitionSymbol)Atom.EPSILON));
            }
        }
        return new RegexAutomaton(states, delta);
    }
}

