/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.string.tarsis;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.nonrelational.value.BaseNonRelationalValueDomain;
import it.unive.lisa.analysis.numeric.Interval;
import it.unive.lisa.analysis.string.ContainsCharProvider;
import it.unive.lisa.analysis.string.fsa.FSA;
import it.unive.lisa.analysis.string.fsa.SimpleAutomaton;
import it.unive.lisa.analysis.string.fsa.StringSymbol;
import it.unive.lisa.analysis.string.tarsis.IndexFinder;
import it.unive.lisa.analysis.string.tarsis.RegexAutomaton;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.binary.StringConcat;
import it.unive.lisa.symbolic.value.operator.binary.StringContains;
import it.unive.lisa.symbolic.value.operator.ternary.StringReplace;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.util.datastructures.automaton.CyclicAutomatonException;
import it.unive.lisa.util.datastructures.automaton.State;
import it.unive.lisa.util.datastructures.automaton.Transition;
import it.unive.lisa.util.datastructures.automaton.TransitionSymbol;
import it.unive.lisa.util.datastructures.regex.RegularExpression;
import it.unive.lisa.util.datastructures.regex.TopAtom;
import it.unive.lisa.util.numeric.IntInterval;
import it.unive.lisa.util.numeric.MathNumber;
import it.unive.lisa.util.numeric.MathNumberConversionException;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;

public class Tarsis
implements BaseNonRelationalValueDomain<Tarsis>,
ContainsCharProvider {
    private static final Tarsis TOP = new Tarsis();
    private static final Tarsis BOTTOM = new Tarsis(RegexAutomaton.emptyLang());
    public static final int WIDENING_CAP = 5;
    private final RegexAutomaton a;

    public Tarsis() {
        this.a = RegexAutomaton.topString();
    }

    public Tarsis(RegexAutomaton a) {
        this.a = a;
    }

    public RegexAutomaton getAutomaton() {
        return this.a;
    }

    public Tarsis lubAux(Tarsis other) throws SemanticException {
        return new Tarsis((RegexAutomaton)this.a.union(other.a));
    }

    public Tarsis glbAux(Tarsis other) throws SemanticException {
        return new Tarsis(this.a.intersection(other.a));
    }

    public int size() {
        return this.a.getStates().size();
    }

    private int getSizeDiffCapped(Tarsis other) {
        int otherSize;
        int size = this.size();
        if (size > (otherSize = other.size())) {
            return Math.min(size - otherSize, 5);
        }
        if (size < otherSize) {
            return Math.min(otherSize - size, 5);
        }
        return 5;
    }

    public Tarsis wideningAux(Tarsis other) throws SemanticException {
        return new Tarsis((RegexAutomaton)((RegexAutomaton)this.a.union(other.a)).widening(this.getSizeDiffCapped(other)));
    }

    public boolean lessOrEqualAux(Tarsis other) throws SemanticException {
        return this.a.isContained(other.a);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tarsis fsa = (Tarsis)o;
        return Objects.equals((Object)this.a, (Object)fsa.a);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.a});
    }

    public Tarsis top() {
        return TOP;
    }

    public Tarsis bottom() {
        return BOTTOM;
    }

    public boolean isBottom() {
        return !this.isTop() && this.a.acceptsEmptyLanguage();
    }

    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        return new StringRepresentation((Object)this.a.toRegex().simplify());
    }

    public Tarsis evalNonNullConstant(Constant constant, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (constant.getValue() instanceof String) {
            return new Tarsis(RegexAutomaton.string((String)constant.getValue()));
        }
        return this.top();
    }

    public Tarsis evalBinaryExpression(BinaryOperator operator, Tarsis left, Tarsis right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringConcat.INSTANCE) {
            return new Tarsis((RegexAutomaton)left.a.concat(right.a));
        }
        return this.top();
    }

    public Tarsis evalTernaryExpression(TernaryOperator operator, Tarsis left, Tarsis middle, Tarsis right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringReplace.INSTANCE) {
            return left.replace(middle, right);
        }
        return TOP;
    }

    public Satisfiability satisfiesBinaryExpression(BinaryOperator operator, Tarsis left, Tarsis right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (operator == StringContains.INSTANCE) {
            return left.contains(right);
        }
        return Satisfiability.UNKNOWN;
    }

    public Satisfiability contains(Tarsis other) {
        try {
            if (!(this.a.hasCycle() || other.a.hasCycle() || this.a.acceptsTopEventually() || other.a.acceptsTopEventually())) {
                boolean atLeastOne = false;
                boolean all = true;
                for (String a : this.a.getLanguage()) {
                    for (String b : other.a.getLanguage()) {
                        boolean cont = a.contains(b);
                        atLeastOne = atLeastOne || cont;
                        all = all && cont;
                    }
                }
                if (all) {
                    return Satisfiability.SATISFIED;
                }
                if (atLeastOne) {
                    return Satisfiability.UNKNOWN;
                }
                return Satisfiability.NOT_SATISFIED;
            }
            if (!other.a.hasCycle() && other.a.getLanguage().size() == 1 && ((String)other.a.getLanguage().iterator().next()).isEmpty()) {
                return Satisfiability.SATISFIED;
            }
            if (other.a.hasOnlyOnePath() && !other.a.acceptsTopEventually()) {
                Satisfiability allSat = Satisfiability.UNKNOWN;
                RegexAutomaton C = (RegexAutomaton)other.a.extractLongestString();
                String longest = (String)C.getLanguage().iterator().next();
                RegexAutomaton withNoScc = (RegexAutomaton)((RegexAutomaton)this.a.minimize()).makeAcyclic();
                SortedSet lang = withNoScc.getLanguage();
                for (String a : lang) {
                    allSat = allSat.glb(this.contains(a, longest));
                }
                if (!lang.isEmpty() && allSat == Satisfiability.SATISFIED) {
                    return allSat;
                }
            }
            RegexAutomaton transformed = (RegexAutomaton)this.a.explode().factors();
            RegexAutomaton otherExploded = other.a.explode();
            if (otherExploded.intersection(transformed).acceptsEmptyLanguage()) {
                return Satisfiability.NOT_SATISFIED;
            }
        }
        catch (CyclicAutomatonException cyclicAutomatonException) {
            // empty catch block
        }
        return Satisfiability.UNKNOWN;
    }

    private Satisfiability contains(String other, String that) {
        if (!other.contains("\u0372")) {
            if (other.contains(that)) {
                return Satisfiability.SATISFIED;
            }
            return Satisfiability.NOT_SATISFIED;
        }
        String otherWithoutTops = other.replaceAll("\u0372", "");
        if (otherWithoutTops.contains(that)) {
            return Satisfiability.SATISFIED;
        }
        return Satisfiability.UNKNOWN;
    }

    public Tarsis substring(long begin, long end) {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        RegexAutomaton[] array = (RegexAutomaton[])this.a.toRegex().substring((int)begin, (int)end).parallelStream().map(s -> RegexAutomaton.string(s)).toArray(RegexAutomaton[]::new);
        RegexAutomaton result = RegexAutomaton.emptyLang();
        for (int i = 0; i < array.length; ++i) {
            result = (RegexAutomaton)result.union(array[i]);
        }
        return new Tarsis(result);
    }

    public IntInterval length() {
        int max = this.a.lenghtOfLongestString();
        int min = this.a.toRegex().minLength();
        return new IntInterval(Integer.valueOf(min), max == Integer.MAX_VALUE ? null : Integer.valueOf(max));
    }

    public IntInterval indexOf(Tarsis s) throws CyclicAutomatonException {
        if (this.contains(s) == Satisfiability.NOT_SATISFIED) {
            return new IntInterval(-1, -1);
        }
        if (this.a.hasCycle() || s.a.hasCycle() || s.a.acceptsTopEventually()) {
            return new IntInterval(MathNumber.MINUS_ONE, MathNumber.PLUS_INFINITY);
        }
        Pair<Integer, Integer> interval = IndexFinder.findIndexesOf(this.a, s.a);
        return new IntInterval((Integer)interval.getLeft(), (Integer)interval.getRight());
    }

    public Tarsis concat(Tarsis other) {
        return new Tarsis((RegexAutomaton)this.a.concat(other.a));
    }

    public Tarsis replace(Tarsis search, Tarsis repl) {
        if (this.isBottom() || search.isBottom() || repl.isBottom()) {
            return this.bottom();
        }
        try {
            return new Tarsis(this.a.replace(search.a, repl.a));
        }
        catch (CyclicAutomatonException e) {
            return TOP;
        }
    }

    public FSA toFSA() {
        RegexAutomaton exploded = ((RegexAutomaton)this.a.minimize()).explode();
        TreeSet<Transition<StringSymbol>> fsaDelta = new TreeSet<Transition<StringSymbol>>();
        if (!this.a.acceptsTopEventually()) {
            for (Transition t : exploded.getTransitions()) {
                fsaDelta.add((Transition<StringSymbol>)new Transition(t.getSource(), t.getDestination(), (TransitionSymbol)new StringSymbol(((RegularExpression)t.getSymbol()).toString())));
            }
            return new FSA(new SimpleAutomaton(exploded.getStates(), fsaDelta));
        }
        TreeSet<State> fsaStates = new TreeSet<State>(exploded.getStates());
        for (Transition t : exploded.getTransitions()) {
            if (t.getSymbol() != TopAtom.INSTANCE) {
                fsaDelta.add((Transition<StringSymbol>)new Transition(t.getSource(), t.getDestination(), (TransitionSymbol)new StringSymbol(((RegularExpression)t.getSymbol()).toString())));
                continue;
            }
            for (char c = ' '; c <= '{'; c = (char)(c + '\u0001')) {
                fsaDelta.add((Transition<StringSymbol>)new Transition(t.getSource(), t.getDestination(), (TransitionSymbol)new StringSymbol(c)));
            }
            fsaDelta.add((Transition<StringSymbol>)new Transition(t.getSource(), t.getDestination(), (TransitionSymbol)StringSymbol.EPSILON));
        }
        SimpleAutomaton fsa = (SimpleAutomaton)new SimpleAutomaton(fsaStates, fsaDelta).minimize();
        return new FSA(fsa);
    }

    @Override
    public Satisfiability containsChar(char c) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom()) {
            return Satisfiability.BOTTOM;
        }
        return this.satisfiesBinaryExpression((BinaryOperator)StringContains.INSTANCE, this, new Tarsis(RegexAutomaton.string(String.valueOf(c))), (ProgramPoint)null, (SemanticOracle)null);
    }

    public Tarsis repeat(Interval intv) throws MathNumberConversionException {
        if (this.isBottom()) {
            return this;
        }
        if (intv.isTop() || this.a.hasCycle()) {
            return new Tarsis((RegexAutomaton)this.a.star());
        }
        if (intv.interval.isFinite()) {
            if (intv.interval.isSingleton()) {
                return new Tarsis(this.a.repeat(intv.interval.getHigh().toLong()));
            }
            RegexAutomaton result = this.a.emptyLanguage();
            for (Long i : intv.interval) {
                result = (RegexAutomaton)result.union(this.a.repeat(i));
            }
            return new Tarsis(result);
        }
        return new Tarsis((RegexAutomaton)this.a.repeat(intv.interval.getLow().toLong()).concat((RegexAutomaton)this.a.star()));
    }

    public Tarsis trim() {
        if (this.isBottom() || this.isTop()) {
            return this;
        }
        return new Tarsis(this.a.trim());
    }
}

