/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.taint;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.taint.BaseTaint;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import it.unive.lisa.symbolic.value.operator.ternary.TernaryOperator;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;

public class ThreeLevelsTaint
extends BaseTaint<ThreeLevelsTaint> {
    private static final ThreeLevelsTaint TOP = new ThreeLevelsTaint(3);
    private static final ThreeLevelsTaint TAINTED = new ThreeLevelsTaint(2);
    private static final ThreeLevelsTaint CLEAN = new ThreeLevelsTaint(1);
    private static final ThreeLevelsTaint BOTTOM = new ThreeLevelsTaint(0);
    private final byte taint;

    public ThreeLevelsTaint() {
        this(3);
    }

    private ThreeLevelsTaint(byte v) {
        this.taint = v;
    }

    @Override
    protected ThreeLevelsTaint tainted() {
        return TAINTED;
    }

    @Override
    protected ThreeLevelsTaint clean() {
        return CLEAN;
    }

    @Override
    public boolean isAlwaysTainted() {
        return this == TAINTED;
    }

    @Override
    public boolean isPossiblyTainted() {
        return this == TOP;
    }

    public StructuredRepresentation representation() {
        return this == BOTTOM ? Lattice.bottomRepresentation() : (this == CLEAN ? new StringRepresentation("_") : (this == TAINTED ? new StringRepresentation("#") : Lattice.topRepresentation()));
    }

    public ThreeLevelsTaint top() {
        return TOP;
    }

    public ThreeLevelsTaint bottom() {
        return BOTTOM;
    }

    @Override
    public ThreeLevelsTaint evalBinaryExpression(BinaryOperator operator, ThreeLevelsTaint left, ThreeLevelsTaint right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (left == TAINTED || right == TAINTED) {
            return TAINTED;
        }
        if (left == TOP || right == TOP) {
            return TOP;
        }
        return CLEAN;
    }

    @Override
    public ThreeLevelsTaint evalTernaryExpression(TernaryOperator operator, ThreeLevelsTaint left, ThreeLevelsTaint middle, ThreeLevelsTaint right, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (left == TAINTED || right == TAINTED || middle == TAINTED) {
            return TAINTED;
        }
        if (left == TOP || right == TOP || middle == TOP) {
            return TOP;
        }
        return CLEAN;
    }

    public ThreeLevelsTaint lubAux(ThreeLevelsTaint other) throws SemanticException {
        return TOP;
    }

    public ThreeLevelsTaint wideningAux(ThreeLevelsTaint other) throws SemanticException {
        return TOP;
    }

    public boolean lessOrEqualAux(ThreeLevelsTaint other) throws SemanticException {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.taint;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreeLevelsTaint other = (ThreeLevelsTaint)obj;
        return this.taint == other.taint;
    }

    public String toString() {
        return this.representation().toString();
    }
}

