/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.traces;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.traces.Branching;
import it.unive.lisa.analysis.traces.ExecutionTrace;
import it.unive.lisa.analysis.traces.LoopIteration;
import it.unive.lisa.analysis.traces.LoopSummary;
import it.unive.lisa.analysis.traces.TraceToken;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.program.cfg.controlFlow.ControlFlowStructure;
import it.unive.lisa.program.cfg.controlFlow.IfThenElse;
import it.unive.lisa.program.cfg.controlFlow.Loop;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.Untyped;
import it.unive.lisa.util.representation.MapRepresentation;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredObject;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class TracePartitioning<A extends AbstractState<A>>
extends FunctionalLattice<TracePartitioning<A>, ExecutionTrace, A>
implements AbstractState<TracePartitioning<A>> {
    public static int MAX_LOOP_ITERATIONS = 5;
    public static int MAX_CONDITIONS = 5;

    public TracePartitioning(A lattice) {
        super(lattice);
    }

    private TracePartitioning(A lattice, Map<ExecutionTrace, A> function) {
        super(lattice, function);
    }

    public <D extends SemanticDomain<?, ?, ?>> Collection<D> getAllDomainInstances(Class<D> domain) {
        Collection result = super.getAllDomainInstances(domain);
        if (this.isTop()) {
            return ((AbstractState)((AbstractState)this.lattice).top()).getAllDomainInstances(domain);
        }
        if (this.isBottom() || this.function == null) {
            return ((AbstractState)((AbstractState)this.lattice).bottom()).getAllDomainInstances(domain);
        }
        for (AbstractState dom : this.getValues()) {
            result.addAll(dom.getAllDomainInstances(domain));
        }
        return result;
    }

    public TracePartitioning<A> top() {
        return new TracePartitioning<AbstractState>((AbstractState)((AbstractState)this.lattice).top(), null);
    }

    public TracePartitioning<A> bottom() {
        return new TracePartitioning<AbstractState>((AbstractState)((AbstractState)this.lattice).bottom(), null);
    }

    public TracePartitioning<A> assign(Identifier id, SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        if (this.isTop() || this.function == null) {
            result.put(new ExecutionTrace(), (AbstractState)((AbstractState)this.lattice).assign(id, expression, pp, oracle));
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry trace = (Map.Entry)iterator.next();
                result.put((ExecutionTrace)trace.getKey(), (AbstractState)((AbstractState)trace.getValue()).assign(id, expression, pp, oracle));
            }
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public TracePartitioning<A> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        if (this.isTop() || this.function == null) {
            result.put(new ExecutionTrace(), (AbstractState)((AbstractState)this.lattice).smallStepSemantics(expression, pp, oracle));
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry trace = (Map.Entry)iterator.next();
                result.put((ExecutionTrace)trace.getKey(), (AbstractState)((AbstractState)trace.getValue()).smallStepSemantics(expression, pp, oracle));
            }
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public TracePartitioning<A> assume(SymbolicExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        if (this.isBottom()) {
            return this;
        }
        ControlFlowStructure struct = src.getCFG().getControlFlowStructureOf(src);
        Map result = this.mkNewFunction(null, false);
        if (this.isTop() || this.function == null) {
            ExecutionTrace trace = new ExecutionTrace();
            ExecutionTrace nextTrace = TracePartitioning.generateTraceFor(trace, struct, src, dest);
            result.put(nextTrace, (AbstractState)((AbstractState)this.lattice).top());
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ExecutionTrace nextTrace;
                Map.Entry trace = (Map.Entry)iterator.next();
                AbstractState state = (AbstractState)trace.getValue();
                ExecutionTrace tokens = (ExecutionTrace)trace.getKey();
                AbstractState assume = (AbstractState)state.assume(expression, src, dest, oracle);
                if (assume.isBottom()) continue;
                AbstractState prev = (AbstractState)result.get(nextTrace = TracePartitioning.generateTraceFor(tokens, struct, src, dest));
                result.put(nextTrace, prev == null ? assume : (AbstractState)assume.lub((Lattice)prev));
            }
        }
        if (result.isEmpty()) {
            return this.bottom();
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    private static ExecutionTrace generateTraceFor(ExecutionTrace trace, ControlFlowStructure struct, ProgramPoint src, ProgramPoint dest) {
        if (struct instanceof Loop && ((Loop)struct).getBody().contains(dest)) {
            TraceToken prev = trace.lastLoopTokenFor(src);
            if (prev == null) {
                if (MAX_LOOP_ITERATIONS > 0) {
                    return trace.push(new LoopIteration(src, 0));
                }
                return trace.push(new LoopSummary(src));
            }
            if (prev instanceof LoopIteration) {
                LoopIteration li = (LoopIteration)prev;
                if (li.getIteration() < MAX_LOOP_ITERATIONS) {
                    return trace.push(new LoopIteration(src, li.getIteration() + 1));
                }
                return trace.push(new LoopSummary(src));
            }
        } else if (struct instanceof IfThenElse && trace.numberOfBranches() < MAX_CONDITIONS) {
            return trace.push(new Branching(src, ((IfThenElse)struct).getTrueBranch().contains(dest)));
        }
        return trace;
    }

    public TracePartitioning<A> forgetIdentifier(Identifier id) throws SemanticException {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            result.put((ExecutionTrace)trace.getKey(), (AbstractState)((AbstractState)trace.getValue()).forgetIdentifier(id));
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public TracePartitioning<A> forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            result.put((ExecutionTrace)trace.getKey(), (AbstractState)((AbstractState)trace.getValue()).forgetIdentifiersIf(test));
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom() || this.function == null) {
            return Satisfiability.BOTTOM;
        }
        Satisfiability result = Satisfiability.BOTTOM;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            Satisfiability sat = ((AbstractState)trace.getValue()).satisfies(expression, pp, oracle);
            if (sat == Satisfiability.BOTTOM) {
                return sat;
            }
            result = (Satisfiability)result.lub((Lattice)sat);
        }
        return result;
    }

    public TracePartitioning<A> pushScope(ScopeToken token) throws SemanticException {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            result.put((ExecutionTrace)trace.getKey(), (AbstractState)((AbstractState)trace.getValue()).pushScope(token));
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public TracePartitioning<A> popScope(ScopeToken token) throws SemanticException {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            result.put((ExecutionTrace)trace.getKey(), (AbstractState)((AbstractState)trace.getValue()).popScope(token));
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public StructuredRepresentation representation() {
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.function == null) {
            return new StringRepresentation("empty");
        }
        return new MapRepresentation(this.function, StringRepresentation::new, StructuredObject::representation);
    }

    public TracePartitioning<A> mk(A lattice, Map<ExecutionTrace, A> function) {
        return new TracePartitioning<A>(lattice, function);
    }

    public A collapse() {
        if (this.isTop()) {
            return (A)((AbstractState)((AbstractState)this.lattice).top());
        }
        AbstractState result = (AbstractState)((AbstractState)this.lattice).bottom();
        if (this.isBottom() || this.function == null) {
            return (A)result;
        }
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry trace = (Map.Entry)iterator.next();
                result = (AbstractState)result.lub((Lattice)((AbstractState)trace.getValue()));
            }
        }
        catch (SemanticException e) {
            return (A)((AbstractState)result.bottom());
        }
        return (A)result;
    }

    public String toString() {
        return this.representation().toString();
    }

    public ExpressionSet rewrite(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (!expression.mightNeedRewriting()) {
            return new ExpressionSet(expression);
        }
        if (this.isTop()) {
            return ((AbstractState)((AbstractState)this.lattice).top()).rewrite(expression, pp, oracle);
        }
        if (this.isBottom() || this.function == null) {
            return ((AbstractState)((AbstractState)this.lattice).bottom()).rewrite(expression, pp, oracle);
        }
        HashSet result = new HashSet();
        for (AbstractState dom : this.getValues()) {
            result.addAll(dom.rewrite(expression, pp, oracle).elements());
        }
        return new ExpressionSet(result);
    }

    public ExpressionSet rewrite(ExpressionSet expressions, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return ((AbstractState)((AbstractState)this.lattice).top()).rewrite(expressions, pp, oracle);
        }
        if (this.isBottom() || this.function == null) {
            return ((AbstractState)((AbstractState)this.lattice).bottom()).rewrite(expressions, pp, oracle);
        }
        HashSet result = new HashSet();
        for (AbstractState dom : this.getValues()) {
            result.addAll(dom.rewrite(expressions, pp, oracle).elements());
        }
        return new ExpressionSet(result);
    }

    public Set<Type> getRuntimeTypesOf(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return ((AbstractState)((AbstractState)this.lattice).top()).getRuntimeTypesOf(e, pp, oracle);
        }
        if (this.isBottom() || this.function == null) {
            return ((AbstractState)((AbstractState)this.lattice).bottom()).getRuntimeTypesOf(e, pp, oracle);
        }
        HashSet<Type> result = new HashSet<Type>();
        for (AbstractState dom : this.getValues()) {
            result.addAll(dom.getRuntimeTypesOf(e, pp, oracle));
        }
        return result;
    }

    public Type getDynamicTypeOf(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return ((AbstractState)((AbstractState)this.lattice).top()).getDynamicTypeOf(e, pp, oracle);
        }
        if (this.isBottom() || this.function == null) {
            return ((AbstractState)((AbstractState)this.lattice).bottom()).getDynamicTypeOf(e, pp, oracle);
        }
        HashSet<Type> result = new HashSet<Type>();
        for (AbstractState dom : this.getValues()) {
            result.add(dom.getDynamicTypeOf(e, pp, oracle));
        }
        return Type.commonSupertype(result, (Type)Untyped.INSTANCE);
    }

    public A stateOfUnknown(ExecutionTrace key) {
        return (A)((AbstractState)((AbstractState)this.lattice).bottom());
    }

    public boolean knowsIdentifier(Identifier id) {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return false;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            if (!((AbstractState)trace.getValue()).knowsIdentifier(id)) continue;
            return true;
        }
        return false;
    }

    public TracePartitioning<A> withTopMemory() {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            result.put((ExecutionTrace)trace.getKey(), ((AbstractState)trace.getValue()).withTopMemory());
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public TracePartitioning<A> withTopValues() {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            result.put((ExecutionTrace)trace.getKey(), ((AbstractState)trace.getValue()).withTopValues());
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public TracePartitioning<A> withTopTypes() {
        if (this.isTop() || this.isBottom() || this.function == null) {
            return this;
        }
        Map result = this.mkNewFunction(null, false);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            result.put((ExecutionTrace)trace.getKey(), ((AbstractState)trace.getValue()).withTopTypes());
        }
        return new TracePartitioning<AbstractState>((AbstractState)this.lattice, result);
    }

    public Satisfiability alias(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom() || this.function == null) {
            return Satisfiability.BOTTOM;
        }
        Satisfiability result = Satisfiability.BOTTOM;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            Satisfiability sat = ((AbstractState)trace.getValue()).alias(x, y, pp, oracle);
            if (sat == Satisfiability.BOTTOM) {
                return sat;
            }
            result = (Satisfiability)result.lub((Lattice)sat);
        }
        return result;
    }

    public Satisfiability isReachableFrom(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (this.isTop()) {
            return Satisfiability.UNKNOWN;
        }
        if (this.isBottom() || this.function == null) {
            return Satisfiability.BOTTOM;
        }
        Satisfiability result = Satisfiability.BOTTOM;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry trace = (Map.Entry)iterator.next();
            Satisfiability sat = ((AbstractState)trace.getValue()).isReachableFrom(x, y, pp, oracle);
            if (sat == Satisfiability.BOTTOM) {
                return sat;
            }
            result = (Satisfiability)result.lub((Lattice)sat);
        }
        return result;
    }
}

