/*
 * Decompiled with CFR 0.152.
 */
package com.litao.slider;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.Dimension;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\u0010"}, d2={"Lcom/litao/slider/Utils;", "", "()V", "dpToPx", "", "dp", "getActivityByContext", "Landroid/app/Activity;", "context", "Landroid/content/Context;", "getActivityByContextInner", "getActivityFromDecorContext", "getWindowWidth", "isActivityAlive", "", "activity", "slider_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final int dpToPx(@Dimension(unit=0) int dp) {
        Resources r = Resources.getSystem();
        return MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics()));
    }

    public final int getWindowWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.dpToPx(context.getResources().getConfiguration().screenWidthDp);
    }

    public final boolean isActivityAlive(@Nullable Context context) {
        return this.isActivityAlive(this.getActivityByContext(context));
    }

    public final boolean isActivityAlive(@Nullable Activity activity) {
        return activity != null && !activity.isFinishing() && !activity.isDestroyed();
    }

    @Nullable
    public final Activity getActivityByContext(@Nullable Context context) {
        Activity activity = this.getActivityByContextInner(context);
        return !this.isActivityAlive(activity) ? null : activity;
    }

    private final Activity getActivityByContextInner(Context context) {
        Context context2 = context;
        if (context2 == null) {
            return null;
        }
        Context context3 = context2;
        List list = new ArrayList();
        while (context3 instanceof ContextWrapper) {
            if (context3 instanceof Activity) {
                return (Activity)context3;
            }
            Activity activity = this.getActivityFromDecorContext(context3);
            if (activity != null) {
                return activity;
            }
            list.add(context3);
            context3 = ((ContextWrapper)context3).getBaseContext();
            if (context3 == null) {
                return null;
            }
            if (!list.contains(context3)) continue;
            return null;
        }
        return null;
    }

    private final Activity getActivityFromDecorContext(Context context) {
        if (context == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)context.getClass().getName(), (Object)"com.android.internal.policy.DecorContext")) {
            try {
                Field mActivityContextField = context.getClass().getDeclaredField("mActivityContext");
                mActivityContextField.setAccessible(true);
                Object object = mActivityContextField.get(context);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.ref.WeakReference<android.app.Activity?>");
                return (Activity)((WeakReference)object).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

