/*
 * Decompiled with CFR 0.152.
 */
package com.litao.slider.anim;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.util.ArrayMap;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import androidx.annotation.RequiresApi;
import androidx.transition.TransitionValues;
import androidx.transition.Visibility;
import com.litao.slider.anim.ITipTransition;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0003\u001f !B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J.\u0010\u001c\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\""}, d2={"Lcom/litao/slider/anim/RevealTransition;", "Landroidx/transition/Visibility;", "Lcom/litao/slider/anim/ITipTransition;", "()V", "centerX", "", "getCenterX", "()F", "setCenterX", "(F)V", "centerY", "getCenterY", "setCenterY", "sliderViewY", "getSliderViewY", "setSliderViewY", "tipViewBottomY", "getTipViewBottomY", "setTipViewBottomY", "onAppear", "Landroid/animation/Animator;", "sceneRoot", "Landroid/view/ViewGroup;", "view", "Landroid/view/View;", "startValues", "Landroidx/transition/TransitionValues;", "endValues", "onDisappear", "updateLocation", "", "AnimatorListenerWrapper", "Companion", "NoPauseAnimator", "slider_release"})
@RequiresApi(value=21)
public final class RevealTransition
extends Visibility
implements ITipTransition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float centerX = 0.5f;
    private float centerY = 0.5f;
    private float tipViewBottomY;
    private float sliderViewY;
    @NotNull
    private static final String TAG = "RevealTransition";
    private static final float DEFAULT_CENTER = 0.5f;

    public final float getCenterX() {
        return this.centerX;
    }

    public final void setCenterX(float f) {
        this.centerX = f;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    public final void setCenterY(float f) {
        this.centerY = f;
    }

    public final float getTipViewBottomY() {
        return this.tipViewBottomY;
    }

    public final void setTipViewBottomY(float f) {
        this.tipViewBottomY = f;
    }

    public final float getSliderViewY() {
        return this.sliderViewY;
    }

    public final void setSliderViewY(float f) {
        this.sliderViewY = f;
    }

    @NotNull
    public Animator onAppear(@Nullable ViewGroup sceneRoot, @NotNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int width = view.getWidth();
        int height = view.getHeight();
        int cx = (int)((float)width * this.centerX);
        int cy = (int)((float)height * this.centerY);
        int distance = width > height ? Math.max(width - cx, cx) : Math.max(height - cy, cy);
        float[] fArray = new float[]{0.0f, 1.0f};
        ObjectAnimator fadeAnim = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])fArray);
        float[] fArray2 = new float[]{this.sliderViewY, this.tipViewBottomY - (float)height};
        ObjectAnimator slideAnim = ObjectAnimator.ofFloat((Object)view, (String)"y", (float[])fArray2);
        Animator revealAnim = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)0.0f, (float)distance);
        slideAnim.setDuration(revealAnim.getDuration());
        AnimatorSet animatorSet = new AnimatorSet();
        Animator[] animatorArray = new Animator[]{(Animator)fadeAnim, (Animator)slideAnim, revealAnim};
        animatorSet.playTogether(animatorArray);
        return new NoPauseAnimator((Animator)animatorSet);
    }

    @NotNull
    public Animator onDisappear(@Nullable ViewGroup sceneRoot, @NotNull View view, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int width = view.getWidth();
        int height = view.getHeight();
        int cx = (int)((float)width * this.centerX);
        int cy = (int)((float)height * this.centerY);
        int distance = width > height ? Math.max(width - cx, cx) : Math.max(height - cy, cy);
        float[] fArray = new float[]{1.0f, 0.0f};
        ObjectAnimator fadeAnim = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])fArray);
        float[] fArray2 = new float[]{this.tipViewBottomY - (float)height, this.sliderViewY};
        ObjectAnimator slideAnim = ObjectAnimator.ofFloat((Object)view, (String)"y", (float[])fArray2);
        Animator revealAnim = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)distance, (float)0.0f);
        slideAnim.setDuration(revealAnim.getDuration());
        fadeAnim.setDuration(revealAnim.getDuration());
        AnimatorSet animatorSet = new AnimatorSet();
        Animator[] animatorArray = new Animator[]{(Animator)fadeAnim, (Animator)slideAnim, revealAnim};
        animatorSet.playTogether(animatorArray);
        return new NoPauseAnimator((Animator)animatorSet);
    }

    @Override
    public void updateLocation(float sliderViewY, float tipViewBottomY) {
        this.tipViewBottomY = tipViewBottomY;
        this.sliderViewY = sliderViewY;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/litao/slider/anim/RevealTransition$Companion;", "", "()V", "DEFAULT_CENTER", "", "TAG", "", "slider_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0011j\b\u0012\u0004\u0012\u00020\u0006`\u0012H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0012\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/litao/slider/anim/RevealTransition$NoPauseAnimator;", "Landroid/animation/Animator;", "mAnimator", "(Landroid/animation/Animator;)V", "mListeners", "Landroid/util/ArrayMap;", "Landroid/animation/Animator$AnimatorListener;", "addListener", "", "listener", "cancel", "end", "getDuration", "", "getInterpolator", "Landroid/animation/TimeInterpolator;", "getListeners", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getStartDelay", "isPaused", "", "isRunning", "isStarted", "removeAllListeners", "removeListener", "setDuration", "durationMS", "setInterpolator", "timeInterpolator", "setStartDelay", "delayMS", "setTarget", "target", "", "setupEndValues", "setupStartValues", "start", "slider_release"})
    private static final class NoPauseAnimator
    extends Animator {
        @NotNull
        private final Animator mAnimator;
        @NotNull
        private final ArrayMap<Animator.AnimatorListener, Animator.AnimatorListener> mListeners;

        public NoPauseAnimator(@NotNull Animator mAnimator) {
            Intrinsics.checkNotNullParameter((Object)mAnimator, (String)"mAnimator");
            this.mAnimator = mAnimator;
            this.mListeners = new ArrayMap();
        }

        public void addListener(@NotNull Animator.AnimatorListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Animator.AnimatorListener wrapper = new AnimatorListenerWrapper(this, listener);
            if (!this.mListeners.containsKey((Object)listener)) {
                ((Map)this.mListeners).put(listener, wrapper);
                this.mAnimator.addListener(wrapper);
            }
        }

        public void cancel() {
            this.mAnimator.cancel();
        }

        public void end() {
            this.mAnimator.end();
        }

        public long getDuration() {
            return this.mAnimator.getDuration();
        }

        @NotNull
        public TimeInterpolator getInterpolator() {
            TimeInterpolator timeInterpolator = this.mAnimator.getInterpolator();
            Intrinsics.checkNotNullExpressionValue((Object)timeInterpolator, (String)"mAnimator.interpolator");
            return timeInterpolator;
        }

        @NotNull
        public ArrayList<Animator.AnimatorListener> getListeners() {
            return new ArrayList<Animator.AnimatorListener>(this.mListeners.keySet());
        }

        public long getStartDelay() {
            return this.mAnimator.getStartDelay();
        }

        public boolean isPaused() {
            return this.mAnimator.isPaused();
        }

        public boolean isRunning() {
            return this.mAnimator.isRunning();
        }

        public boolean isStarted() {
            return this.mAnimator.isStarted();
        }

        public void removeAllListeners() {
            super.removeAllListeners();
            this.mListeners.clear();
            this.mAnimator.removeAllListeners();
        }

        public void removeListener(@NotNull Animator.AnimatorListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Animator.AnimatorListener wrapper = (Animator.AnimatorListener)this.mListeners.get((Object)listener);
            if (wrapper != null) {
                this.mListeners.remove((Object)listener);
                this.mAnimator.removeListener(wrapper);
            }
        }

        @NotNull
        public Animator setDuration(long durationMS) {
            this.mAnimator.setDuration(durationMS);
            return this;
        }

        public void setInterpolator(@NotNull TimeInterpolator timeInterpolator) {
            Intrinsics.checkNotNullParameter((Object)timeInterpolator, (String)"timeInterpolator");
            this.mAnimator.setInterpolator(timeInterpolator);
        }

        public void setStartDelay(long delayMS) {
            this.mAnimator.setStartDelay(delayMS);
        }

        public void setTarget(@Nullable Object target) {
            this.mAnimator.setTarget(target);
        }

        public void setupEndValues() {
            this.mAnimator.setupEndValues();
        }

        public void setupStartValues() {
            this.mAnimator.setupStartValues();
        }

        public void start() {
            this.mAnimator.start();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/litao/slider/anim/RevealTransition$AnimatorListenerWrapper;", "Landroid/animation/Animator$AnimatorListener;", "mAnimator", "Landroid/animation/Animator;", "mListener", "(Landroid/animation/Animator;Landroid/animation/Animator$AnimatorListener;)V", "onAnimationCancel", "", "animator", "onAnimationEnd", "animation", "isReverse", "", "onAnimationRepeat", "onAnimationStart", "slider_release"})
    private static final class AnimatorListenerWrapper
    implements Animator.AnimatorListener {
        @NotNull
        private final Animator mAnimator;
        @NotNull
        private final Animator.AnimatorListener mListener;

        public AnimatorListenerWrapper(@NotNull Animator mAnimator, @NotNull Animator.AnimatorListener mListener) {
            Intrinsics.checkNotNullParameter((Object)mAnimator, (String)"mAnimator");
            Intrinsics.checkNotNullParameter((Object)mListener, (String)"mListener");
            this.mAnimator = mAnimator;
            this.mListener = mListener;
        }

        public void onAnimationStart(@NotNull Animator animation, boolean isReverse) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            super.onAnimationStart(animation, isReverse);
        }

        public void onAnimationEnd(@NotNull Animator animation, boolean isReverse) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            super.onAnimationEnd(animation, isReverse);
        }

        public void onAnimationStart(@NotNull Animator animator) {
            Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            this.mListener.onAnimationStart(this.mAnimator);
        }

        public void onAnimationEnd(@NotNull Animator animator) {
            Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            this.mListener.onAnimationEnd(this.mAnimator);
        }

        public void onAnimationCancel(@NotNull Animator animator) {
            Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            this.mListener.onAnimationCancel(this.mAnimator);
        }

        public void onAnimationRepeat(@NotNull Animator animator) {
            Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
            this.mListener.onAnimationRepeat(this.mAnimator);
        }
    }
}

