/*
 * Decompiled with CFR 0.152.
 */
package com.litao.slider.anim;

import android.animation.ValueAnimator;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.FloatRange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/litao/slider/anim/ThumbValueAnimation;", "Landroid/animation/ValueAnimator;", "()V", "handler", "Landroid/os/Handler;", "isThumbHidden", "", "executeHide", "", "animated", "executeShow", "getAnimatedValue", "", "getAnimatedValueAbsolute", "", "hide", "delayMillis", "", "show", "toggle", "Companion", "slider_release"})
public final class ThumbValueAnimation
extends ValueAnimator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isThumbHidden;
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());
    public static final long DEFAULT_DURATION = 300L;

    public ThumbValueAnimation() {
        float[] fArray = new float[]{1.0f, 0.0f};
        this.setFloatValues(fArray);
        this.setDuration(300L);
    }

    @NotNull
    public Object getAnimatedValue() {
        Object object = super.getAnimatedValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"super.getAnimatedValue()");
        return object;
    }

    @FloatRange(from=0.0, to=1.0)
    public final float getAnimatedValueAbsolute() {
        return Float.parseFloat(this.getAnimatedValue().toString());
    }

    public final void hide(boolean animated, long delayMillis) {
        this.handler.removeCallbacksAndMessages(null);
        if (this.isRunning()) {
            this.end();
        }
        if (!this.isThumbHidden) {
            this.handler.postDelayed(() -> ThumbValueAnimation.hide$lambda$0(this, animated), delayMillis);
        } else {
            this.cancel();
        }
    }

    public static /* synthetic */ void hide$default(ThumbValueAnimation thumbValueAnimation, boolean bl, long l, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        thumbValueAnimation.hide(bl, l);
    }

    public final void show(boolean animated, long delayMillis) {
        this.handler.removeCallbacksAndMessages(null);
        if (this.isRunning()) {
            this.end();
        }
        if (this.isThumbHidden) {
            this.handler.postDelayed(() -> ThumbValueAnimation.show$lambda$1(this, animated), delayMillis);
        } else {
            this.cancel();
        }
    }

    public static /* synthetic */ void show$default(ThumbValueAnimation thumbValueAnimation, boolean bl, long l, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        thumbValueAnimation.show(bl, l);
    }

    public final void toggle(boolean animated) {
        if (this.isThumbHidden) {
            ThumbValueAnimation.show$default(this, animated, 0L, 2, null);
        } else {
            ThumbValueAnimation.hide$default(this, animated, 0L, 2, null);
        }
    }

    public static /* synthetic */ void toggle$default(ThumbValueAnimation thumbValueAnimation, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        thumbValueAnimation.toggle(bl);
    }

    private final void executeHide(boolean animated) {
        this.isThumbHidden = true;
        if (animated) {
            super.start();
        } else {
            this.setCurrentPlayTime(this.getDuration());
        }
    }

    private final void executeShow(boolean animated) {
        this.isThumbHidden = false;
        if (animated) {
            super.reverse();
        } else {
            this.setCurrentPlayTime(0L);
        }
    }

    public final boolean isThumbHidden() {
        return this.isThumbHidden && !this.isRunning();
    }

    private static final void hide$lambda$0(ThumbValueAnimation this$0, boolean $animated) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.executeHide($animated);
    }

    private static final void show$lambda$1(ThumbValueAnimation this$0, boolean $animated) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.executeShow($animated);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/litao/slider/anim/ThumbValueAnimation$Companion;", "", "()V", "DEFAULT_DURATION", "", "slider_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

