/*
 * Decompiled with CFR 0.152.
 */
package com.litao.slider.thumb;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.core.graphics.drawable.DrawableCompat;
import com.litao.slider.Utils;
import com.litao.slider.thumb.IBaseThumbDrawable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 [2\u00020\u00012\u00020\u0002:\u0001[B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010E\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0005H\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010L\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0002J\b\u0010M\u001a\u00020\u001eH\u0016J\b\u0010N\u001a\u00020\u0014H\u0016J\b\u0010O\u001a\u00020\u0014H\u0002J\b\u0010P\u001a\u00020\u0014H\u0002J\u0010\u0010Q\u001a\u00020H2\u0006\u0010R\u001a\u00020\u001aH\u0014J\u0010\u0010S\u001a\u00020\u00142\u0006\u0010T\u001a\u00020UH\u0014J\u0010\u0010V\u001a\u00020H2\u0006\u0010W\u001a\u00020\u001eH\u0016J\u0012\u0010X\u001a\u00020H2\b\u0010W\u001a\u0004\u0018\u00010YH\u0016J\u0010\u0010Z\u001a\u00020\u00142\u0006\u0010T\u001a\u00020UH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR(\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010%\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0011\"\u0004\b'\u0010\u0013R\u000e\u0010(\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0007\"\u0004\b+\u0010\tR\u001c\u0010,\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010 \"\u0004\b3\u0010\"R\u001e\u00104\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010 \"\u0004\b6\u0010\"R\u000e\u00107\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00108\u001a\u0004\u0018\u000109X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R&\u0010>\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u001e8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010 \"\u0004\b@\u0010\"R\u000e\u0010A\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010B\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0007\"\u0004\bD\u0010\t\u00a8\u0006\\"}, d2={"Lcom/litao/slider/thumb/DefaultThumbDrawable;", "Landroid/graphics/drawable/Drawable;", "Lcom/litao/slider/thumb/IBaseThumbDrawable;", "()V", "cornerSize", "", "getCornerSize", "()F", "setCornerSize", "(F)V", "elevation", "getElevation", "setElevation", "value", "Landroid/content/res/ColorStateList;", "fillColor", "getFillColor", "()Landroid/content/res/ColorStateList;", "setFillColor", "(Landroid/content/res/ColorStateList;)V", "", "isThumbTextBold", "()Z", "setThumbTextBold", "(Z)V", "rect", "Landroid/graphics/Rect;", "rectF", "Landroid/graphics/RectF;", "shadowColor", "", "getShadowColor", "()I", "setShadowColor", "(I)V", "shadowPaint", "Landroid/graphics/Paint;", "strokeColor", "getStrokeColor", "setStrokeColor", "strokePaint", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "thumbIcon", "getThumbIcon", "()Landroid/graphics/drawable/Drawable;", "setThumbIcon", "(Landroid/graphics/drawable/Drawable;)V", "thumbIconSize", "getThumbIconSize", "setThumbIconSize", "thumbIconTintColor", "getThumbIconTintColor", "setThumbIconTintColor", "thumbPaint", "thumbText", "", "getThumbText", "()Ljava/lang/String;", "setThumbText", "(Ljava/lang/String;)V", "thumbTextColor", "getThumbTextColor", "setThumbTextColor", "thumbTextPaint", "thumbTextSize", "getThumbTextSize", "setThumbTextSize", "calculateElevation", "radius", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawIconIfNeed", "drawTextIfNeed", "getOpacity", "isStateful", "isSupportShadow", "isSupportStroke", "onBoundsChange", "bounds", "onStateChange", "state", "", "setAlpha", "p0", "setColorFilter", "Landroid/graphics/ColorFilter;", "updateColorsForState", "Companion", "slider_release"})
public final class DefaultThumbDrawable
extends Drawable
implements IBaseThumbDrawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint thumbPaint = new Paint(5);
    @NotNull
    private final Paint strokePaint = new Paint(5);
    @NotNull
    private final Paint shadowPaint = new Paint(5);
    @NotNull
    private Paint thumbTextPaint = new Paint(5);
    @NotNull
    private final Rect rect = new Rect();
    @NotNull
    private final RectF rectF = new RectF();
    @Nullable
    private ColorStateList fillColor;
    @Nullable
    private ColorStateList strokeColor;
    private int shadowColor;
    private float cornerSize = -1.0f;
    private float strokeWidth;
    private float elevation;
    @Nullable
    private String thumbText;
    @ColorInt
    private int thumbTextColor;
    private float thumbTextSize = Utils.INSTANCE.dpToPx(14);
    private boolean isThumbTextBold;
    @Nullable
    private Drawable thumbIcon;
    private int thumbIconSize = -1;
    @ColorInt
    private int thumbIconTintColor = -1;
    private static final int HIGH_QUALITY_FLAGS = 5;

    public DefaultThumbDrawable() {
        Paint paint;
        Paint $this$_init__u24lambda_u240 = paint = this.thumbPaint;
        boolean bl = false;
        $this$_init__u24lambda_u240.setStyle(Paint.Style.FILL);
        Paint $this$_init__u24lambda_u241 = paint = this.strokePaint;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setStyle(Paint.Style.STROKE);
        Paint $this$_init__u24lambda_u242 = paint = this.shadowPaint;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.setAntiAlias(true);
        $this$_init__u24lambda_u242.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        Paint $this$_init__u24lambda_u243 = paint = this.thumbTextPaint;
        boolean bl4 = false;
        $this$_init__u24lambda_u243.setStyle(Paint.Style.FILL);
        $this$_init__u24lambda_u243.setTextAlign(Paint.Align.CENTER);
        int[] nArray = this.getState();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"state");
        this.updateColorsForState(nArray);
    }

    @Nullable
    public final ColorStateList getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(@Nullable ColorStateList value) {
        if (!Intrinsics.areEqual((Object)value, (Object)this.fillColor)) {
            this.fillColor = value;
            int[] nArray = this.getState();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"state");
            this.onStateChange(nArray);
        }
    }

    @Nullable
    public final ColorStateList getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(@Nullable ColorStateList value) {
        if (!Intrinsics.areEqual((Object)value, (Object)this.strokeColor)) {
            this.strokeColor = value;
            int[] nArray = this.getState();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"state");
            this.onStateChange(nArray);
        }
    }

    public final int getShadowColor() {
        return this.shadowColor;
    }

    public final void setShadowColor(int n) {
        this.shadowColor = n;
    }

    public final float getCornerSize() {
        return this.cornerSize;
    }

    public final void setCornerSize(float f) {
        this.cornerSize = f;
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(float value) {
        this.strokeWidth = value;
        this.strokePaint.setStrokeWidth(value);
    }

    public final float getElevation() {
        return this.elevation;
    }

    public final void setElevation(float f) {
        this.elevation = f;
    }

    @Nullable
    public final String getThumbText() {
        return this.thumbText;
    }

    public final void setThumbText(@Nullable String string) {
        this.thumbText = string;
    }

    public final int getThumbTextColor() {
        return this.thumbTextColor;
    }

    public final void setThumbTextColor(int value) {
        this.thumbTextColor = value;
        this.thumbTextPaint.setColor(value);
    }

    public final float getThumbTextSize() {
        return this.thumbTextSize;
    }

    public final void setThumbTextSize(float value) {
        this.thumbTextSize = value;
        this.thumbTextPaint.setTextSize(value);
    }

    public final boolean isThumbTextBold() {
        return this.isThumbTextBold;
    }

    public final void setThumbTextBold(boolean value) {
        this.isThumbTextBold = value;
        this.thumbTextPaint.setFakeBoldText(value);
    }

    @Nullable
    public final Drawable getThumbIcon() {
        return this.thumbIcon;
    }

    public final void setThumbIcon(@Nullable Drawable drawable2) {
        this.thumbIcon = drawable2;
    }

    public final int getThumbIconSize() {
        return this.thumbIconSize;
    }

    public final void setThumbIconSize(int n) {
        this.thumbIconSize = n;
    }

    public final int getThumbIconTintColor() {
        return this.thumbIconTintColor;
    }

    public final void setThumbIconTintColor(int n) {
        this.thumbIconTintColor = n;
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.copyBounds(this.rect);
        this.rectF.set(this.rect);
        if (this.cornerSize == -1.0f) {
            this.cornerSize = this.rectF.width() / 2.0f;
        }
        float radius = Math.min(this.cornerSize, this.rectF.width() / 2.0f);
        float shadowOffset = Utils.INSTANCE.dpToPx(1);
        boolean hasShadow = false;
        if (this.isSupportShadow()) {
            hasShadow = true;
            this.shadowPaint.setColor(this.shadowColor);
            this.shadowPaint.setShadowLayer(this.calculateElevation(this.elevation + shadowOffset, radius), 0.0f, 0.0f, this.shadowColor);
            this.rectF.inset(shadowOffset, shadowOffset);
            canvas.drawRoundRect(this.rectF, radius, radius, this.shadowPaint);
        }
        if (hasShadow) {
            this.rectF.inset(-shadowOffset, -shadowOffset);
        }
        canvas.drawRoundRect(this.rectF, radius, radius, this.thumbPaint);
        if (this.isSupportStroke()) {
            canvas.drawRoundRect(this.rectF, radius, radius, this.strokePaint);
        }
        this.drawTextIfNeed(canvas);
        this.drawIconIfNeed(canvas);
    }

    private final void drawTextIfNeed(Canvas canvas) {
        block0: {
            String string = this.thumbText;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            canvas.drawText(it, this.rectF.width() / (float)2, this.rectF.height() / (float)2 - (float)((this.thumbTextPaint.getFontMetricsInt().bottom + this.thumbTextPaint.getFontMetricsInt().top) / 2), this.thumbTextPaint);
        }
    }

    private final void drawIconIfNeed(Canvas canvas) {
        block3: {
            int iconSize;
            Drawable drawable2 = this.thumbIcon;
            if (drawable2 == null) break block3;
            Drawable it = drawable2;
            boolean bl = false;
            RectF $this$toRect$iv = this.rectF;
            boolean $i$f$toRect = false;
            Rect r$iv = new Rect();
            $this$toRect$iv.roundOut(r$iv);
            Rect iconRect = r$iv;
            int sizeLimit = Math.min(iconRect.width(), iconRect.height());
            int n = iconSize = this.thumbIconSize == -1 ? sizeLimit / 2 : this.thumbIconSize;
            if (iconSize > sizeLimit) {
                iconSize = sizeLimit;
            } else {
                int offset = (sizeLimit - iconSize) / 2;
                iconRect.set(iconRect.left + offset, iconRect.top + offset, iconRect.right - offset, iconRect.bottom - offset);
            }
            it.setBounds(iconRect);
            if (this.thumbIconTintColor != -1) {
                DrawableCompat.setTint((Drawable)it, (int)this.thumbIconTintColor);
            }
            it.draw(canvas);
        }
    }

    private final boolean isSupportShadow() {
        return this.elevation > 0.0f && this.shadowColor != 0 && this.rectF.width() > (float)Utils.INSTANCE.dpToPx(3) && this.rectF.height() > (float)Utils.INSTANCE.dpToPx(3);
    }

    private final boolean isSupportStroke() {
        return this.strokeWidth > 0.0f && this.rectF.width() > this.strokeWidth * (float)2 && this.rectF.height() > this.strokeWidth * (float)2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStateful() {
        boolean bl;
        if (super.isStateful()) return true;
        ColorStateList colorStateList = this.fillColor;
        if (colorStateList != null) {
            if (colorStateList.isStateful()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        ColorStateList colorStateList2 = this.strokeColor;
        if (colorStateList2 == null) return false;
        if (!colorStateList2.isStateful()) return false;
        return true;
    }

    protected boolean onStateChange(@NotNull int[] state) {
        boolean paintColorChanged;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        boolean invalidateSelf = paintColorChanged = this.updateColorsForState(state);
        return invalidateSelf;
    }

    private final boolean updateColorsForState(int[] state) {
        boolean invalidateSelf;
        block3: {
            int newStrokeColor;
            ColorStateList it;
            invalidateSelf = false;
            ColorStateList colorStateList = this.fillColor;
            if (colorStateList != null) {
                int newFillColor;
                it = colorStateList;
                boolean bl = false;
                int previousFillColor = this.thumbPaint.getColor();
                if (previousFillColor != (newFillColor = it.getColorForState(state, previousFillColor))) {
                    this.thumbPaint.setColor(newFillColor);
                    invalidateSelf = true;
                }
            }
            ColorStateList colorStateList2 = this.strokeColor;
            if (colorStateList2 == null) break block3;
            it = colorStateList2;
            boolean bl = false;
            int previousStrokeColor = this.strokePaint.getColor();
            if (previousStrokeColor != (newStrokeColor = it.getColorForState(state, previousStrokeColor))) {
                this.strokePaint.setColor(newStrokeColor);
                invalidateSelf = true;
            }
        }
        return invalidateSelf;
    }

    public void setAlpha(int p0) {
    }

    public void setColorFilter(@Nullable ColorFilter p0) {
    }

    public int getOpacity() {
        return -3;
    }

    private final float calculateElevation(float elevation, float radius) {
        return Math.min(elevation, radius);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/litao/slider/thumb/DefaultThumbDrawable$Companion;", "", "()V", "HIGH_QUALITY_FLAGS", "", "slider_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

