/*
 * Decompiled with CFR 0.152.
 */
package com.litao.slider.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.core.math.MathUtils;
import androidx.core.view.ViewCompat;
import androidx.transition.Fade;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import com.litao.slider.BaseSlider;
import com.litao.slider.R;
import com.litao.slider.Utils;
import com.litao.slider.anim.ITipTransition;
import com.litao.slider.anim.TipViewAnimator;
import com.litao.slider.widget.DefaultTipView;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\r\n\u0002\b\u0007\u0018\u0000 Y2\u00020\u0001:\u0001YB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u0002082\u0006\u0010:\u001a\u000200J\u000e\u0010;\u001a\u0002082\u0006\u0010:\u001a\u00020\u0016J\b\u0010<\u001a\u000208H\u0002J\u0014\u0010=\u001a\u0004\u0018\u00010>2\b\u0010:\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010?\u001a\u00020@H\u0002J\b\u0010A\u001a\u00020@H\u0002J\u0006\u0010B\u001a\u000208J\u001e\u0010C\u001a\u0002082\u0006\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020@2\u0006\u0010F\u001a\u00020@J(\u0010G\u001a\u0002082\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007H\u0014J\u0016\u0010L\u001a\u0002082\u0006\u0010M\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\u0007J\u0010\u0010O\u001a\u0002082\b\b\u0001\u0010P\u001a\u00020\u0007J\u000e\u0010Q\u001a\u0002082\u0006\u0010R\u001a\u00020SJ\u0010\u0010T\u001a\u0002082\b\b\u0001\u0010P\u001a\u00020\u0007J\u0006\u0010U\u001a\u000208J\u001c\u0010V\u001a\u0002082\b\b\u0002\u0010D\u001a\u00020@2\b\b\u0002\u0010E\u001a\u00020@H\u0002J\u0012\u0010W\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010X\u001a\u000208H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\"\"\u0004\b&\u0010$R\u001a\u0010'\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\"\"\u0004\b(\u0010$R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0012\"\u0004\b3\u0010\u0014R\u001a\u00104\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0012\"\u0004\b6\u0010\u0014\u00a8\u0006Z"}, d2={"Lcom/litao/slider/widget/TipViewContainer;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "TIP_VIEW_ID", "animator", "Lcom/litao/slider/anim/TipViewAnimator;", "getAnimator", "()Lcom/litao/slider/anim/TipViewAnimator;", "setAnimator", "(Lcom/litao/slider/anim/TipViewAnimator;)V", "currentViewId", "getCurrentViewId", "()I", "setCurrentViewId", "(I)V", "customTipView", "Landroid/view/View;", "getCustomTipView", "()Landroid/view/View;", "setCustomTipView", "(Landroid/view/View;)V", "defaultSpace", "defaultTipView", "Lcom/litao/slider/widget/DefaultTipView;", "defaultTransition", "Landroidx/transition/Fade;", "isAttached", "", "()Z", "setAttached", "(Z)V", "isClippingEnabled", "setClippingEnabled", "isTipTextAutoChange", "setTipTextAutoChange", "locationOnScreenX", "locationOnScreenY", "showRunnable", "Ljava/lang/Runnable;", "getShowRunnable", "()Ljava/lang/Runnable;", "slider", "Lcom/litao/slider/BaseSlider;", "verticalOffset", "getVerticalOffset", "setVerticalOffset", "windowWidth", "getWindowWidth", "setWindowWidth", "addTipViewIfNeed", "", "attachTipView", "view", "detachTipView", "executeTransition", "getContentView", "Landroid/view/ViewGroup;", "getRelativeCX", "", "getRelativeCY", "hide", "onLocationChanged", "cx", "cy", "value", "onSizeChanged", "w", "h", "oldw", "oldh", "setSize", "width", "height", "setTipBackground", "color", "setTipText", "text", "", "setTipTextColor", "show", "updateLocation", "updateLocationOnScreen", "updateParams", "Companion", "slider_release"})
public final class TipViewContainer
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int TIP_VIEW_ID;
    @Nullable
    private BaseSlider slider;
    private final int defaultSpace;
    private int locationOnScreenX;
    private int locationOnScreenY;
    @Nullable
    private View customTipView;
    @NotNull
    private DefaultTipView defaultTipView;
    @Nullable
    private TipViewAnimator animator;
    @NotNull
    private Fade defaultTransition;
    private boolean isTipTextAutoChange;
    private boolean isClippingEnabled;
    private int verticalOffset;
    private boolean isAttached;
    private int windowWidth;
    private int currentViewId;
    @NotNull
    private final Runnable showRunnable;
    @NotNull
    public static final String TAG = "TipViewContainer";

    @JvmOverloads
    public TipViewContainer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.TIP_VIEW_ID = R.id.nifty_slider_tip_view;
        this.defaultSpace = Utils.INSTANCE.dpToPx(-8);
        this.defaultTipView = new DefaultTipView(context, null, 0, 6, null);
        this.defaultTransition = new Fade();
        this.isTipTextAutoChange = true;
        this.currentViewId = this.TIP_VIEW_ID + this.hashCode();
        this.showRunnable = () -> TipViewContainer.showRunnable$lambda$0(this);
        this.setId(this.currentViewId);
        this.setVisibility(4);
        this.setSize(-2, -2);
    }

    public /* synthetic */ TipViewContainer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final View getCustomTipView() {
        return this.customTipView;
    }

    public final void setCustomTipView(@Nullable View view) {
        this.customTipView = view;
    }

    @Nullable
    public final TipViewAnimator getAnimator() {
        return this.animator;
    }

    public final void setAnimator(@Nullable TipViewAnimator tipViewAnimator) {
        this.animator = tipViewAnimator;
    }

    public final boolean isTipTextAutoChange() {
        return this.isTipTextAutoChange;
    }

    public final void setTipTextAutoChange(boolean bl) {
        this.isTipTextAutoChange = bl;
    }

    public final boolean isClippingEnabled() {
        return this.isClippingEnabled;
    }

    public final void setClippingEnabled(boolean bl) {
        this.isClippingEnabled = bl;
    }

    public final int getVerticalOffset() {
        return this.verticalOffset;
    }

    public final void setVerticalOffset(int n) {
        this.verticalOffset = n;
    }

    public final boolean isAttached() {
        return this.isAttached;
    }

    public final void setAttached(boolean bl) {
        this.isAttached = bl;
    }

    public final int getWindowWidth() {
        return this.windowWidth;
    }

    public final void setWindowWidth(int n) {
        this.windowWidth = n;
    }

    public final int getCurrentViewId() {
        return this.currentViewId;
    }

    public final void setCurrentViewId(int n) {
        this.currentViewId = n;
    }

    @NotNull
    public final Runnable getShowRunnable() {
        return this.showRunnable;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        TipViewContainer.updateLocation$default(this, 0.0f, 0.0f, 3, null);
    }

    public final void setSize(int width, int height) {
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
    }

    public final void attachTipView(@NotNull BaseSlider view) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
            ViewGroup contentView = this.getContentView(view);
            this.slider = view;
            ViewGroup viewGroup = contentView;
            if (viewGroup == null) break block1;
            ViewGroup it = viewGroup;
            boolean bl = false;
            TipViewContainer tipView = (TipViewContainer)it.findViewById(this.currentViewId);
            if (tipView == null) {
                it.addView((View)this);
            }
            this.isAttached = true;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.windowWidth = Utils.INSTANCE.getWindowWidth(context);
        }
    }

    private final void updateLocationOnScreen(View view) {
        if (view != null) {
            int[] locationOnScreen = new int[2];
            Rect globalRect = new Rect();
            ViewGroup viewGroup = this.getContentView(view);
            if (viewGroup != null) {
                viewGroup.getGlobalVisibleRect(globalRect);
            }
            view.getLocationOnScreen(locationOnScreen);
            this.locationOnScreenX = locationOnScreen[0];
            this.locationOnScreenY = locationOnScreen[1] - globalRect.top;
        }
    }

    private final void updateParams() {
        if (this.verticalOffset == 0) {
            BaseSlider baseSlider = this.slider;
            this.verticalOffset = -(baseSlider != null ? baseSlider.getThumbRadius() : 0) + this.defaultSpace;
        }
    }

    public final void detachTipView(@NotNull View view) {
        block2: {
            ViewGroup contentView;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            ViewGroup viewGroup = contentView = this.getContentView(view);
            if (viewGroup == null) break block2;
            View $this$doOnLayout$iv = (View)viewGroup;
            boolean $i$f$doOnLayout = false;
            if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
                View it = $this$doOnLayout$iv;
                boolean bl = false;
                contentView.removeView((View)this);
            } else {
                View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
                boolean $i$f$doOnNextLayout = false;
                $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(contentView, this){
                    final /* synthetic */ ViewGroup $contentView$inlined;
                    final /* synthetic */ TipViewContainer this$0;
                    {
                        this.$contentView$inlined = viewGroup;
                        this.this$0 = tipViewContainer;
                    }

                    public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                        View it = view;
                        boolean bl = false;
                        View it2 = it;
                        boolean bl2 = false;
                        this.$contentView$inlined.removeView((View)this.this$0);
                    }
                });
            }
        }
    }

    private final ViewGroup getContentView(View view) {
        if (view == null) {
            return null;
        }
        View rootView = view.getRootView();
        ViewGroup contentView = (ViewGroup)rootView.findViewById(0x1020002);
        if (contentView != null) {
            return contentView;
        }
        return rootView != view && rootView instanceof ViewGroup ? (ViewGroup)rootView : null;
    }

    public final void show() {
        this.removeCallbacks(this.showRunnable);
        if (this.isAttached) {
            this.postDelayed(this.showRunnable, 200L);
        }
    }

    public final void hide() {
        this.removeCallbacks(this.showRunnable);
        if (this.isAttached) {
            this.updateLocationOnScreen(this.slider);
            this.executeTransition();
            this.setVisibility(8);
        }
    }

    private final void executeTransition() {
        Transition customTransition;
        TipViewAnimator tipViewAnimator = this.animator;
        Object object = customTransition = tipViewAnimator != null ? tipViewAnimator.createTransition() : null;
        if (customTransition == null) {
            customTransition = (Transition)this.defaultTransition;
        } else if (customTransition instanceof ITipTransition) {
            float srcY = (float)this.locationOnScreenY + this.getRelativeCY() + (float)this.verticalOffset;
            ((ITipTransition)customTransition).updateLocation(this.locationOnScreenY, srcY);
        }
        TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)this), (Transition)customTransition);
    }

    public final void onLocationChanged(float cx, float cy, float value) {
        if (this.isAttached) {
            this.updateLocation(cx, cy);
            if (this.isTipTextAutoChange) {
                String string = "%.0f";
                Object[] objectArray = new Object[]{Float.valueOf(value)};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                this.setTipText(string2);
            }
        }
    }

    private final void updateLocation(float cx, float cy) {
        float viewX = (float)this.locationOnScreenX + cx - (float)(this.getWidth() / 2);
        if (this.isClippingEnabled) {
            viewX = MathUtils.clamp((float)viewX, (float)0.0f, (float)((float)this.windowWidth - (float)this.getWidth()));
        }
        this.setX(viewX);
        this.setY((float)this.locationOnScreenY + cy - (float)this.getHeight() + (float)this.verticalOffset);
    }

    static /* synthetic */ void updateLocation$default(TipViewContainer tipViewContainer, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = tipViewContainer.getRelativeCX();
        }
        if ((n & 2) != 0) {
            f2 = tipViewContainer.getRelativeCY();
        }
        tipViewContainer.updateLocation(f, f2);
    }

    public final void addTipViewIfNeed() {
        if (this.customTipView == null) {
            if (this.getChildCount() == 0) {
                this.addView((View)this.defaultTipView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            }
        } else if (this.getChildCount() == 0) {
            this.addView(this.customTipView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        }
    }

    public final void setTipBackground(@ColorInt int color2) {
        this.defaultTipView.setTipBackground(color2);
    }

    public final void setTipTextColor(@ColorInt int color2) {
        this.defaultTipView.setTipTextColor(color2);
    }

    public final void setTipText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.defaultTipView.setTipText(text);
    }

    private final float getRelativeCX() {
        BaseSlider baseSlider = this.slider;
        return baseSlider != null ? baseSlider.getThumbCenterX() : 0.0f;
    }

    private final float getRelativeCY() {
        BaseSlider baseSlider = this.slider;
        return baseSlider != null ? baseSlider.getThumbCenterY() : 0.0f;
    }

    @JvmOverloads
    public TipViewContainer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TipViewContainer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void showRunnable$lambda$0(TipViewContainer this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.addTipViewIfNeed();
        this$0.updateLocationOnScreen(this$0.slider);
        TipViewContainer.updateLocation$default(this$0, 0.0f, 0.0f, 3, null);
        this$0.updateParams();
        this$0.executeTransition();
        this$0.setVisibility(0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/litao/slider/widget/TipViewContainer$Companion;", "", "()V", "TAG", "", "slider_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

