/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.managers;

import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.semanticweb.elk.owl.implementation.ElkObjectBaseFactory;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectDelegatingFactory;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.managers.WeakElkAnnotationPropertyWrapper;
import org.semanticweb.elk.owl.managers.WeakElkClassWrapper;
import org.semanticweb.elk.owl.managers.WeakElkDataPropertyWrapper;
import org.semanticweb.elk.owl.managers.WeakElkDatatypeWrapper;
import org.semanticweb.elk.owl.managers.WeakElkNamedIndividualWrapper;
import org.semanticweb.elk.owl.managers.WeakElkObjectPropertyWrapper;
import org.semanticweb.elk.owl.managers.WeakWrapper;
import org.semanticweb.elk.owl.visitors.ElkEntityVisitor;

public class ElkObjectEntityRecyclingFactory
extends ElkObjectDelegatingFactory {
    private HashMap<WeakWrapper<? extends ElkEntity>, WeakWrapper<? extends ElkEntity>> cache = new HashMap();
    private ReferenceQueue<ElkEntity> referenceQueue = new ReferenceQueue();
    private ElkEntityVisitor<WeakWrapper<? extends ElkEntity>> wrapper = new ElkEntityVisitor<WeakWrapper<? extends ElkEntity>>(){

        public WeakWrapper<? extends ElkEntity> visit(ElkClass elkClass) {
            return new WeakElkClassWrapper(elkClass, ElkObjectEntityRecyclingFactory.this.referenceQueue);
        }

        public WeakWrapper<? extends ElkEntity> visit(ElkDatatype elkDatatype) {
            return new WeakElkDatatypeWrapper(elkDatatype, ElkObjectEntityRecyclingFactory.this.referenceQueue);
        }

        public WeakWrapper<? extends ElkEntity> visit(ElkObjectProperty elkObjectProperty) {
            return new WeakElkObjectPropertyWrapper(elkObjectProperty, ElkObjectEntityRecyclingFactory.this.referenceQueue);
        }

        public WeakWrapper<? extends ElkEntity> visit(ElkDataProperty elkDataProperty) {
            return new WeakElkDataPropertyWrapper(elkDataProperty, ElkObjectEntityRecyclingFactory.this.referenceQueue);
        }

        public WeakWrapper<? extends ElkEntity> visit(ElkNamedIndividual elkNamedIndividual) {
            return new WeakElkNamedIndividualWrapper(elkNamedIndividual, ElkObjectEntityRecyclingFactory.this.referenceQueue);
        }

        public WeakWrapper<? extends ElkEntity> visit(ElkAnnotationProperty elkAnnotationProperty) {
            return new WeakElkAnnotationPropertyWrapper(elkAnnotationProperty, ElkObjectEntityRecyclingFactory.this.referenceQueue);
        }
    };

    public ElkObjectEntityRecyclingFactory(ElkObject.Factory factory) {
        super(factory);
    }

    public ElkObjectEntityRecyclingFactory() {
        this(new ElkObjectBaseFactory());
    }

    protected <C extends ElkObject> C filter(C candidate) {
        if (candidate instanceof ElkEntity) {
            return (C)this.getCanonicalElkEntity((ElkEntity)candidate);
        }
        return candidate;
    }

    private ElkEntity getCanonicalElkEntity(ElkEntity entity) {
        ElkEntity result;
        this.processQueue();
        if (entity == null) {
            return null;
        }
        WeakWrapper key = (WeakWrapper)entity.accept(this.wrapper);
        WeakWrapper<? extends ElkEntity> value = this.cache.get(key);
        if (value != null && (result = (ElkEntity)value.get()) != null) {
            return result;
        }
        this.cache.put(key, key);
        return entity;
    }

    private final void processQueue() {
        WeakWrapper w = null;
        while ((w = (WeakWrapper)this.referenceQueue.poll()) != null) {
            this.cache.remove(w);
        }
    }
}

