/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.interfaces.ElkAnnotation;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationSubject;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationValue;
import org.semanticweb.elk.owl.interfaces.ElkAnonymousIndividual;
import org.semanticweb.elk.owl.interfaces.ElkAsymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataExactCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataHasValue;
import org.semanticweb.elk.owl.interfaces.ElkDataIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMaxCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkDataMinCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkDataOneOf;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDataRange;
import org.semanticweb.elk.owl.interfaces.ElkDataSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkDataUnionOf;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeDefinitionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDatatypeRestriction;
import org.semanticweb.elk.owl.interfaces.ElkDeclarationAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointUnionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentDataPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFacetRestriction;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalDataPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkHasKeyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkInverseObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIrreflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkLiteral;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNegativeDataPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectAllValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectExactCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasSelf;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectInverseOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMaxCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinalityQualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectMinCardinalityUnqualified;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectUnionOf;
import org.semanticweb.elk.owl.interfaces.ElkReflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSWRLRule;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubAnnotationPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubDataPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSymmetricObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.iris.ElkAbbreviatedIri;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.visitors.ElkObjectVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.owlapi.apibinding.OWLFunctionalSyntaxFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.vocab.OWLFacet;

public abstract class AbstractElkObjectConverter
implements ElkObjectVisitor<OWLObject> {
    private final OWLDataFactory owlFactory_;

    public AbstractElkObjectConverter() {
        this(OWLManager.getOWLDataFactory());
    }

    public AbstractElkObjectConverter(OWLDataFactory owlFactory) {
        this.owlFactory_ = owlFactory;
    }

    abstract OWLAnnotationProperty convert(ElkAnnotationProperty var1);

    abstract OWLAnnotationSubject convert(ElkAnnotationSubject var1);

    abstract OWLAnnotationValue convert(ElkAnnotationValue var1);

    abstract OWLAxiom convert(ElkAxiom var1);

    abstract OWLClass convert(ElkClass var1);

    abstract OWLClassExpression convert(ElkClassExpression var1);

    abstract OWLDataProperty convert(ElkDataProperty var1);

    abstract OWLDataPropertyExpression convert(ElkDataPropertyExpression var1);

    abstract OWLDataRange convert(ElkDataRange var1);

    abstract OWLDatatype convert(ElkDatatype var1);

    abstract OWLEntity convert(ElkEntity var1);

    abstract OWLFacetRestriction convert(ElkFacetRestriction var1);

    abstract OWLIndividual convert(ElkIndividual var1);

    abstract IRI convert(ElkIri var1);

    abstract OWLLiteral convert(ElkLiteral var1);

    abstract OWLNamedIndividual convert(ElkNamedIndividual var1);

    abstract OWLObjectProperty convert(ElkObjectProperty var1);

    abstract OWLObjectPropertyExpression convert(ElkObjectPropertyExpression var1);

    OWLClassExpression[] toClassExpressions(List<? extends ElkClassExpression> input) {
        OWLClassExpression[] result = new OWLClassExpression[input.size()];
        int i = 0;
        for (ElkClassExpression elkClassExpression : input) {
            result[i++] = this.convert(elkClassExpression);
        }
        return result;
    }

    OWLDataPropertyExpression[] toDataPropertyExpressions(List<? extends ElkDataPropertyExpression> input) {
        OWLDataPropertyExpression[] result = new OWLDataPropertyExpression[input.size()];
        int i = 0;
        for (ElkDataPropertyExpression elkDataPropertyExpression : input) {
            result[i++] = this.convert(elkDataPropertyExpression);
        }
        return result;
    }

    OWLDataRange[] toDataRanges(List<? extends ElkDataRange> input) {
        OWLDataRange[] result = new OWLDataRange[input.size()];
        int i = 0;
        for (ElkDataRange elkDataRange : input) {
            result[i++] = this.convert(elkDataRange);
        }
        return result;
    }

    OWLFacetRestriction[] toFacetRestrictions(List<? extends ElkFacetRestriction> input) {
        OWLFacetRestriction[] result = new OWLFacetRestriction[input.size()];
        int i = 0;
        for (ElkFacetRestriction elkFacetRestriction : input) {
            result[i++] = this.convert(elkFacetRestriction);
        }
        return result;
    }

    OWLIndividual[] toIndividuals(List<? extends ElkIndividual> input) {
        OWLIndividual[] result = new OWLIndividual[input.size()];
        int i = 0;
        for (ElkIndividual elkIndividual : input) {
            result[i++] = this.convert(elkIndividual);
        }
        return result;
    }

    OWLLiteral[] toLiteralSet(List<? extends ElkLiteral> input) {
        OWLLiteral[] result = new OWLLiteral[input.size()];
        int i = 0;
        for (ElkLiteral elkLiteral : input) {
            result[i++] = this.convert(elkLiteral);
        }
        return result;
    }

    OWLObjectPropertyExpression[] toObjectPropertyExpressions(List<? extends ElkObjectPropertyExpression> input) {
        OWLObjectPropertyExpression[] result = new OWLObjectPropertyExpression[input.size()];
        int i = 0;
        for (ElkObjectPropertyExpression elkObjectPropertyExpression : input) {
            result[i++] = this.convert(elkObjectPropertyExpression);
        }
        return result;
    }

    List<? extends OWLObjectPropertyExpression> toPropertyExpressionList(List<? extends ElkObjectPropertyExpression> input) {
        ArrayList<OWLObjectPropertyExpression> result = new ArrayList<OWLObjectPropertyExpression>(input.size());
        for (ElkObjectPropertyExpression elkObjectPropertyExpression : input) {
            result.add(this.convert(elkObjectPropertyExpression));
        }
        return result;
    }

    OWLPropertyExpression[] toPropertyExpressions(List<? extends ElkObjectPropertyExpression> objectProperties, List<? extends ElkDataPropertyExpression> dataProperties) {
        OWLPropertyExpression[] result = new OWLPropertyExpression[objectProperties.size() + dataProperties.size()];
        int i = 0;
        for (ElkObjectPropertyExpression elkObjectPropertyExpression : objectProperties) {
            result[i++] = this.convert(elkObjectPropertyExpression);
        }
        for (ElkDataPropertyExpression elkDataPropertyExpression : dataProperties) {
            result[i++] = this.convert(elkDataPropertyExpression);
        }
        return result;
    }

    public IRI visit(ElkAbbreviatedIri iri) {
        return IRI.create((String)iri.getPrefix().getIri().getFullIriAsString(), (String)iri.getLocalName());
    }

    public OWLAnnotation visit(ElkAnnotation annotation) {
        return OWLFunctionalSyntaxFactory.Annotation((OWLAnnotationProperty)this.convert(annotation.getProperty()), (OWLAnnotationValue)this.convert(annotation.getValue()));
    }

    public OWLAnnotationAssertionAxiom visit(ElkAnnotationAssertionAxiom axiom) {
        return OWLFunctionalSyntaxFactory.AnnotationAssertion((OWLAnnotationProperty)this.convert(axiom.getProperty()), (OWLAnnotationSubject)this.convert(axiom.getSubject()), (OWLAnnotationValue)this.convert(axiom.getValue()));
    }

    public OWLAnnotationProperty visit(ElkAnnotationProperty expression) {
        return OWLFunctionalSyntaxFactory.AnnotationProperty((IRI)this.convert(expression.getIri()));
    }

    public OWLAnnotationPropertyDomainAxiom visit(ElkAnnotationPropertyDomainAxiom axiom) {
        return OWLFunctionalSyntaxFactory.AnnotationPropertyDomain((OWLAnnotationProperty)this.convert((ElkAnnotationProperty)axiom.getProperty()), (IRI)this.convert((ElkIri)axiom.getDomain()));
    }

    public OWLAnnotationPropertyRangeAxiom visit(ElkAnnotationPropertyRangeAxiom axiom) {
        return OWLFunctionalSyntaxFactory.AnnotationPropertyRange((OWLAnnotationProperty)this.convert((ElkAnnotationProperty)axiom.getProperty()), (IRI)this.convert((ElkIri)axiom.getRange()));
    }

    public OWLAnonymousIndividual visit(ElkAnonymousIndividual expression) {
        return OWLFunctionalSyntaxFactory.AnonymousIndividual((String)expression.getNodeId());
    }

    public OWLAsymmetricObjectPropertyAxiom visit(ElkAsymmetricObjectPropertyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.AsymmetricObjectProperty((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLClass visit(ElkClass expression) {
        return OWLFunctionalSyntaxFactory.Class((IRI)this.convert(expression.getIri()));
    }

    public OWLClassAssertionAxiom visit(ElkClassAssertionAxiom axiom) {
        return OWLFunctionalSyntaxFactory.ClassAssertion((OWLClassExpression)this.convert(axiom.getClassExpression()), (OWLIndividual)this.convert(axiom.getIndividual()));
    }

    public OWLDataAllValuesFrom visit(ElkDataAllValuesFrom expression) {
        List expressions = expression.getDataPropertyExpressions();
        if (expressions.size() > 0) {
            throw new IllegalArgumentException("OWLAPI supports only one data property in OWLDataAllValuesFrom");
        }
        return OWLFunctionalSyntaxFactory.DataAllValuesFrom((OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)expressions.get(0)), (OWLDataRange)this.convert(expression.getDataRange()));
    }

    public OWLDataComplementOf visit(ElkDataComplementOf expression) {
        return OWLFunctionalSyntaxFactory.DataComplementOf((OWLDataRange)this.convert((ElkDataRange)expression));
    }

    public OWLDataExactCardinality visit(ElkDataExactCardinalityQualified expression) {
        return OWLFunctionalSyntaxFactory.DataExactCardinality((int)expression.getCardinality(), (OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)expression.getProperty()), (OWLDataRange)this.convert((ElkDataRange)expression.getFiller()));
    }

    public OWLDataExactCardinality visit(ElkDataExactCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLDataExactCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()));
    }

    public OWLDataHasValue visit(ElkDataHasValue expression) {
        return OWLFunctionalSyntaxFactory.DataHasValue((OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)expression.getProperty()), (OWLLiteral)this.convert((ElkLiteral)expression.getFiller()));
    }

    public OWLDataIntersectionOf visit(ElkDataIntersectionOf expression) {
        return OWLFunctionalSyntaxFactory.DataIntersectionOf((OWLDataRange[])this.toDataRanges(expression.getDataRanges()));
    }

    public OWLDataMaxCardinality visit(ElkDataMaxCardinalityQualified expression) {
        return OWLFunctionalSyntaxFactory.DataMaxCardinality((int)expression.getCardinality(), (OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)expression.getProperty()), (OWLDataRange)this.convert((ElkDataRange)expression.getFiller()));
    }

    public OWLDataMaxCardinality visit(ElkDataMaxCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLDataMaxCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()));
    }

    public OWLDataMinCardinality visit(ElkDataMinCardinalityQualified expression) {
        return OWLFunctionalSyntaxFactory.DataMinCardinality((int)expression.getCardinality(), (OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)expression.getProperty()), (OWLDataRange)this.convert((ElkDataRange)expression.getFiller()));
    }

    public OWLDataMinCardinality visit(ElkDataMinCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLDataMinCardinality(expression.getCardinality(), this.convert((ElkDataPropertyExpression)expression.getProperty()));
    }

    public OWLDataOneOf visit(ElkDataOneOf expression) {
        return OWLFunctionalSyntaxFactory.DataOneOf((OWLLiteral[])this.toLiteralSet(expression.getLiterals()));
    }

    public OWLDataProperty visit(ElkDataProperty expression) {
        return OWLFunctionalSyntaxFactory.DataProperty((IRI)this.convert(expression.getIri()));
    }

    public OWLDataPropertyAssertionAxiom visit(ElkDataPropertyAssertionAxiom axiom) {
        return OWLFunctionalSyntaxFactory.DataPropertyAssertion((OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)axiom.getProperty()), (OWLIndividual)this.convert((ElkIndividual)axiom.getSubject()), (OWLLiteral)this.convert((ElkLiteral)axiom.getObject()));
    }

    public OWLDataPropertyDomainAxiom visit(ElkDataPropertyDomainAxiom axiom) {
        return OWLFunctionalSyntaxFactory.DataPropertyDomain((OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)axiom.getProperty()), (OWLClassExpression)this.convert((ElkClassExpression)axiom.getDomain()));
    }

    public OWLDataPropertyRangeAxiom visit(ElkDataPropertyRangeAxiom axiom) {
        return OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)axiom.getProperty()), (OWLDataRange)this.convert((ElkDataRange)axiom.getRange()));
    }

    public OWLDataSomeValuesFrom visit(ElkDataSomeValuesFrom expression) {
        List propertyExpressions = expression.getDataPropertyExpressions();
        if (propertyExpressions.size() > 0) {
            throw new IllegalArgumentException("OWLAPI supports only one data property in OWLDataSomeValuesFrom");
        }
        return OWLFunctionalSyntaxFactory.DataSomeValuesFrom((OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)propertyExpressions.get(0)), (OWLDataRange)this.convert(expression.getDataRange()));
    }

    public OWLDatatype visit(ElkDatatype expression) {
        return OWLFunctionalSyntaxFactory.Datatype((IRI)this.convert(expression.getIri()));
    }

    public OWLDatatypeDefinitionAxiom visit(ElkDatatypeDefinitionAxiom axiom) {
        return OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)this.convert(axiom.getDatatype()), (OWLDataRange)this.convert(axiom.getDataRange()));
    }

    public OWLDatatypeRestriction visit(ElkDatatypeRestriction expression) {
        return OWLFunctionalSyntaxFactory.DatatypeRestriction((OWLDatatype)this.convert(expression.getDatatype()), (OWLFacetRestriction[])this.toFacetRestrictions(expression.getFacetRestrictions()));
    }

    public OWLDataUnionOf visit(ElkDataUnionOf expression) {
        return OWLFunctionalSyntaxFactory.DataUnionOf((OWLDataRange[])this.toDataRanges(expression.getDataRanges()));
    }

    public OWLDeclarationAxiom visit(ElkDeclarationAxiom axiom) {
        return OWLFunctionalSyntaxFactory.Declaration((OWLEntity)this.convert(axiom.getEntity()));
    }

    public OWLDifferentIndividualsAxiom visit(ElkDifferentIndividualsAxiom axiom) {
        return OWLFunctionalSyntaxFactory.DifferentIndividuals((OWLIndividual[])this.toIndividuals(axiom.getIndividuals()));
    }

    public OWLDisjointClassesAxiom visit(ElkDisjointClassesAxiom axiom) {
        return OWLFunctionalSyntaxFactory.DisjointClasses((OWLClassExpression[])this.toClassExpressions(axiom.getClassExpressions()));
    }

    public OWLDisjointDataPropertiesAxiom visit(ElkDisjointDataPropertiesAxiom axiom) {
        return this.owlFactory_.getOWLDisjointDataPropertiesAxiom(this.toDataPropertyExpressions(axiom.getDataPropertyExpressions()));
    }

    public OWLDisjointObjectPropertiesAxiom visit(ElkDisjointObjectPropertiesAxiom axiom) {
        return OWLFunctionalSyntaxFactory.DisjointObjectProperties((OWLObjectPropertyExpression[])this.toObjectPropertyExpressions(axiom.getObjectPropertyExpressions()));
    }

    public OWLDisjointUnionAxiom visit(ElkDisjointUnionAxiom axiom) {
        return OWLFunctionalSyntaxFactory.DisjointUnion((OWLClass)this.convert(axiom.getDefinedClass()), (OWLClassExpression[])this.toClassExpressions(axiom.getClassExpressions()));
    }

    public OWLEquivalentClassesAxiom visit(ElkEquivalentClassesAxiom axiom) {
        return OWLFunctionalSyntaxFactory.EquivalentClasses((OWLClassExpression[])this.toClassExpressions(axiom.getClassExpressions()));
    }

    public OWLEquivalentDataPropertiesAxiom visit(ElkEquivalentDataPropertiesAxiom axiom) {
        return OWLFunctionalSyntaxFactory.EquivalentDataProperties((OWLDataPropertyExpression[])this.toDataPropertyExpressions(axiom.getDataPropertyExpressions()));
    }

    public OWLEquivalentObjectPropertiesAxiom visit(ElkEquivalentObjectPropertiesAxiom axiom) {
        return OWLFunctionalSyntaxFactory.EquivalentObjectProperties((OWLObjectPropertyExpression[])this.toObjectPropertyExpressions(axiom.getObjectPropertyExpressions()));
    }

    public OWLFacetRestriction visit(ElkFacetRestriction restriction) {
        return OWLFunctionalSyntaxFactory.FacetRestriction((OWLFacet)OWLFacet.getFacet((IRI)this.convert(restriction.getConstrainingFacet())), (OWLLiteral)this.convert(restriction.getRestrictionValue()));
    }

    public IRI visit(ElkFullIri iri) {
        return IRI.create((String)iri.getFullIriAsString());
    }

    public OWLFunctionalDataPropertyAxiom visit(ElkFunctionalDataPropertyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.FunctionalDataProperty((OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)axiom.getProperty()));
    }

    public OWLFunctionalObjectPropertyAxiom visit(ElkFunctionalObjectPropertyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.FunctionalObjectProperty((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLHasKeyAxiom visit(ElkHasKeyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.HasKey((OWLClassExpression)this.convert(axiom.getClassExpression()), (OWLPropertyExpression[])this.toPropertyExpressions(axiom.getObjectPropertyExpressions(), axiom.getDataPropertyExpressions()));
    }

    public OWLInverseFunctionalObjectPropertyAxiom visit(ElkInverseFunctionalObjectPropertyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.InverseFunctionalObjectProperty((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLInverseObjectPropertiesAxiom visit(ElkInverseObjectPropertiesAxiom axiom) {
        return OWLFunctionalSyntaxFactory.InverseObjectProperties((OWLObjectPropertyExpression)this.convert(axiom.getFirstObjectPropertyExpression()), (OWLObjectPropertyExpression)this.convert(axiom.getSecondObjectPropertyExpression()));
    }

    public OWLIrreflexiveObjectPropertyAxiom visit(ElkIrreflexiveObjectPropertyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.IrreflexiveObjectProperty((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLLiteral visit(ElkLiteral expression) {
        return OWLFunctionalSyntaxFactory.Literal((String)expression.getLexicalForm(), (OWLDatatype)this.convert(expression.getDatatype()));
    }

    public OWLNamedIndividual visit(ElkNamedIndividual expression) {
        return OWLFunctionalSyntaxFactory.NamedIndividual((IRI)this.convert(expression.getIri()));
    }

    public OWLNegativeDataPropertyAssertionAxiom visit(ElkNegativeDataPropertyAssertionAxiom axiom) {
        return OWLFunctionalSyntaxFactory.NegativeDataPropertyAssertion((OWLDataPropertyExpression)this.convert((ElkDataPropertyExpression)axiom.getProperty()), (OWLIndividual)this.convert((ElkIndividual)axiom.getSubject()), (OWLLiteral)this.convert((ElkLiteral)axiom.getObject()));
    }

    public OWLNegativeObjectPropertyAssertionAxiom visit(ElkNegativeObjectPropertyAssertionAxiom axiom) {
        return OWLFunctionalSyntaxFactory.NegativeObjectPropertyAssertion((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()), (OWLIndividual)this.convert((ElkIndividual)axiom.getSubject()), (OWLIndividual)this.convert((ElkIndividual)axiom.getObject()));
    }

    public OWLObjectAllValuesFrom visit(ElkObjectAllValuesFrom expression) {
        return OWLFunctionalSyntaxFactory.ObjectAllValuesFrom((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)expression.getProperty()), (OWLClassExpression)this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectComplementOf visit(ElkObjectComplementOf expression) {
        return OWLFunctionalSyntaxFactory.ObjectComplementOf((OWLClassExpression)this.convert(expression.getClassExpression()));
    }

    public OWLObjectExactCardinality visit(ElkObjectExactCardinalityQualified expression) {
        return OWLFunctionalSyntaxFactory.ObjectExactCardinality((int)expression.getCardinality(), (OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)expression.getProperty()), (OWLClassExpression)this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectExactCardinality visit(ElkObjectExactCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLObjectExactCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectHasSelf visit(ElkObjectHasSelf expression) {
        return this.owlFactory_.getOWLObjectHasSelf(this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectHasValue visit(ElkObjectHasValue expression) {
        return OWLFunctionalSyntaxFactory.ObjectHasValue((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)expression.getProperty()), (OWLIndividual)this.convert((ElkIndividual)expression.getFiller()));
    }

    public OWLObjectIntersectionOf visit(ElkObjectIntersectionOf expression) {
        return OWLFunctionalSyntaxFactory.ObjectIntersectionOf((OWLClassExpression[])this.toClassExpressions(expression.getClassExpressions()));
    }

    public OWLObjectInverseOf visit(ElkObjectInverseOf expression) {
        return this.owlFactory_.getOWLObjectInverseOf(this.convert(expression.getObjectProperty()));
    }

    public OWLObjectMaxCardinality visit(ElkObjectMaxCardinalityQualified expression) {
        return OWLFunctionalSyntaxFactory.ObjectMaxCardinality((int)expression.getCardinality(), (OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)expression.getProperty()), (OWLClassExpression)this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectMaxCardinality visit(ElkObjectMaxCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLObjectMaxCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectMinCardinality visit(ElkObjectMinCardinalityQualified expression) {
        return OWLFunctionalSyntaxFactory.ObjectMinCardinality((int)expression.getCardinality(), (OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)expression.getProperty()), (OWLClassExpression)this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectMinCardinality visit(ElkObjectMinCardinalityUnqualified expression) {
        return this.owlFactory_.getOWLObjectMinCardinality(expression.getCardinality(), this.convert((ElkObjectPropertyExpression)expression.getProperty()));
    }

    public OWLObjectOneOf visit(ElkObjectOneOf expression) {
        return OWLFunctionalSyntaxFactory.ObjectOneOf((OWLIndividual[])this.toIndividuals(expression.getIndividuals()));
    }

    public OWLObjectProperty visit(ElkObjectProperty expression) {
        return OWLFunctionalSyntaxFactory.ObjectProperty((IRI)this.convert(expression.getIri()));
    }

    public OWLObjectPropertyAssertionAxiom visit(ElkObjectPropertyAssertionAxiom axiom) {
        return OWLFunctionalSyntaxFactory.ObjectPropertyAssertion((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()), (OWLIndividual)this.convert((ElkIndividual)axiom.getSubject()), (OWLIndividual)this.convert((ElkIndividual)axiom.getObject()));
    }

    public OWLObject visit(ElkObjectPropertyChain expression) {
        throw new ElkRuntimeException("ElkObjectPropertyChain cannot convert to OWLObject");
    }

    public OWLObjectPropertyDomainAxiom visit(ElkObjectPropertyDomainAxiom axiom) {
        return OWLFunctionalSyntaxFactory.ObjectPropertyDomain((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()), (OWLClassExpression)this.convert((ElkClassExpression)axiom.getDomain()));
    }

    public OWLObjectPropertyRangeAxiom visit(ElkObjectPropertyRangeAxiom axiom) {
        return OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()), (OWLClassExpression)this.convert((ElkClassExpression)axiom.getRange()));
    }

    public OWLObjectSomeValuesFrom visit(ElkObjectSomeValuesFrom expression) {
        return OWLFunctionalSyntaxFactory.ObjectSomeValuesFrom((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)expression.getProperty()), (OWLClassExpression)this.convert((ElkClassExpression)expression.getFiller()));
    }

    public OWLObjectUnionOf visit(ElkObjectUnionOf expression) {
        return OWLFunctionalSyntaxFactory.ObjectUnionOf((OWLClassExpression[])this.toClassExpressions(expression.getClassExpressions()));
    }

    public OWLReflexiveObjectPropertyAxiom visit(ElkReflexiveObjectPropertyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.ReflexiveObjectProperty((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLSameIndividualAxiom visit(ElkSameIndividualAxiom axiom) {
        return OWLFunctionalSyntaxFactory.SameIndividual((OWLIndividual[])this.toIndividuals(axiom.getIndividuals()));
    }

    public OWLSubAnnotationPropertyOfAxiom visit(ElkSubAnnotationPropertyOfAxiom axiom) {
        return OWLFunctionalSyntaxFactory.SubAnnotationPropertyOf((OWLAnnotationProperty)this.convert(axiom.getSubAnnotationProperty()), (OWLAnnotationProperty)this.convert(axiom.getSuperAnnotationProperty()));
    }

    public OWLObject visit(ElkSubClassOfAxiom axiom) {
        return OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)this.convert(axiom.getSubClassExpression()), (OWLClassExpression)this.convert(axiom.getSuperClassExpression()));
    }

    public OWLSubDataPropertyOfAxiom visit(ElkSubDataPropertyOfAxiom axiom) {
        return OWLFunctionalSyntaxFactory.SubDataPropertyOf((OWLDataPropertyExpression)this.convert(axiom.getSubDataPropertyExpression()), (OWLDataPropertyExpression)this.convert(axiom.getSuperDataPropertyExpression()));
    }

    public OWLObjectPropertyAxiom visit(final ElkSubObjectPropertyOfAxiom axiom) {
        return (OWLObjectPropertyAxiom)axiom.getSubObjectPropertyExpression().accept((ElkSubObjectPropertyExpressionVisitor)new ElkSubObjectPropertyExpressionVisitor<OWLObjectPropertyAxiom>(){

            OWLSubObjectPropertyOfAxiom defaultVisit(ElkObjectPropertyExpression subExpression) {
                return OWLFunctionalSyntaxFactory.SubObjectPropertyOf((OWLObjectPropertyExpression)AbstractElkObjectConverter.this.convert(subExpression), (OWLObjectPropertyExpression)AbstractElkObjectConverter.this.convert(axiom.getSuperObjectPropertyExpression()));
            }

            public OWLSubObjectPropertyOfAxiom visit(ElkObjectInverseOf expression) {
                return this.defaultVisit((ElkObjectPropertyExpression)expression);
            }

            public OWLSubObjectPropertyOfAxiom visit(ElkObjectProperty expression) {
                return this.defaultVisit((ElkObjectPropertyExpression)expression);
            }

            public OWLSubPropertyChainOfAxiom visit(ElkObjectPropertyChain subExpression) {
                return OWLFunctionalSyntaxFactory.SubPropertyChainOf(AbstractElkObjectConverter.this.toPropertyExpressionList(subExpression.getObjectPropertyExpressions()), (OWLObjectPropertyExpression)AbstractElkObjectConverter.this.convert(axiom.getSuperObjectPropertyExpression()));
            }
        });
    }

    public OWLObject visit(ElkSWRLRule axiom) {
        throw new ElkRuntimeException("SWRL rules not supported by ELK");
    }

    public OWLSymmetricObjectPropertyAxiom visit(ElkSymmetricObjectPropertyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.SymmetricObjectProperty((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }

    public OWLTransitiveObjectPropertyAxiom visit(ElkTransitiveObjectPropertyAxiom axiom) {
        return OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)this.convert((ElkObjectPropertyExpression)axiom.getProperty()));
    }
}

