/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import org.semanticweb.elk.owlapi.ElkReasoner;
import org.semanticweb.elk.owlapi.ElkReasonerConfiguration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElkReasonerFactory
implements OWLReasonerFactory {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ElkReasonerFactory.class);

    public String getReasonerName() {
        LOGGER_.trace("getReasonerName()");
        return ElkReasonerFactory.class.getPackage().getImplementationTitle();
    }

    public ElkReasoner createNonBufferingReasoner(OWLOntology ontology) {
        LOGGER_.trace("createNonBufferingReasoner(OWLOntology)");
        return this.createElkReasoner(ontology, false, null);
    }

    public ElkReasoner createReasoner(OWLOntology ontology) {
        LOGGER_.trace("createReasoner(OWLOntology)");
        return this.createElkReasoner(ontology, true, null);
    }

    public ElkReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        LOGGER_.trace("createNonBufferingReasoner(OWLOntology, OWLReasonerConfiguration)");
        return this.createElkReasoner(ontology, false, config);
    }

    public ElkReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        LOGGER_.trace("createReasoner(OWLOntology, OWLReasonerConfiguration)");
        return this.createElkReasoner(ontology, true, config);
    }

    ElkReasoner createElkReasoner(OWLOntology ontology, boolean isBufferingMode, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        LOGGER_.trace("createElkReasoner(OWLOntology, boolean, OWLReasonerConfiguration)");
        ElkReasonerConfiguration elkReasonerConfig = config != null ? (config instanceof ElkReasonerConfiguration ? (ElkReasonerConfiguration)config : new ElkReasonerConfiguration(config)) : new ElkReasonerConfiguration();
        return new ElkReasoner(ontology, isBufferingMode, elkReasonerConfig);
    }
}

