/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi.proofs;

import java.util.Collection;
import org.liveontologies.puli.BaseProof;
import org.liveontologies.puli.DynamicProof;
import org.liveontologies.puli.Producer;
import org.liveontologies.puli.Proofs;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.inferences.ElkInferenceOptimizedProducingFactory;
import org.semanticweb.elk.owl.inferences.ElkInferenceProducer;
import org.semanticweb.elk.owl.inferences.ElkProofGenerator;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owlapi.ElkConverter;
import org.semanticweb.elk.owlapi.ElkReasoner;
import org.semanticweb.elk.owlapi.proofs.ElkInferenceConvertingProducer;
import org.semanticweb.elk.owlapi.proofs.ElkOwlInference;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.elk.reasoner.proof.ReasonerProof;
import org.semanticweb.elk.reasoner.query.VerifiableQueryResult;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;

public class ElkOwlProof
extends BaseProof<ElkOwlInference>
implements ElkReasoner.ChangeListener {
    private final ElkReasoner elkReasoner_;
    private final OWLAxiom owlEntailment_;
    private boolean inSync_ = false;

    private ElkOwlProof(ElkReasoner elkReasoner, OWLAxiom elkEntailment) {
        this.elkReasoner_ = elkReasoner;
        this.owlEntailment_ = elkEntailment;
        elkReasoner.addListener(this);
    }

    public synchronized Collection<? extends ElkOwlInference> getInferences(Object conclusion) {
        this.ensureSync();
        return super.getInferences(conclusion);
    }

    synchronized void ensureSync() {
        if (!this.inSync_) {
            this.clear();
            this.generate();
            this.inSync_ = true;
        }
    }

    @Override
    public synchronized void ontologyChanged() {
        this.inSync_ = false;
        this.fireChanged();
    }

    public void dispose() {
        super.dispose();
        this.elkReasoner_.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate() {
        OwlConverter owlConverter = OwlConverter.getInstance();
        ElkConverter elkConverter = ElkConverter.getInstance();
        try {
            ElkAxiom elkAxiom = owlConverter.convert(this.owlEntailment_);
            VerifiableQueryResult result = this.elkReasoner_.getInternalReasoner().checkEntailment(elkAxiom);
            try {
                ElkInferenceConvertingProducer producer = new ElkInferenceConvertingProducer((Producer<ElkOwlInference>)this);
                ElkInferenceOptimizedProducingFactory factory = new ElkInferenceOptimizedProducingFactory((ElkInferenceProducer)producer);
                ReasonerProof evidence = result.getEvidence(false);
                new ElkProofGenerator(evidence, this.elkReasoner_.getInternalReasoner(), (ElkInference.Factory)factory).generate(result.getEntailment());
            }
            finally {
                result.unlock();
            }
        }
        catch (ElkException e) {
            throw elkConverter.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw elkConverter.convert(e);
        }
    }

    public static DynamicProof<ElkOwlInference> create(ElkReasoner reasoner, OWLAxiom entailment) throws UnsupportedEntailmentTypeException {
        if (reasoner == null) {
            return Proofs.emptyProof();
        }
        ElkOwlProof proof = new ElkOwlProof(reasoner, entailment);
        proof.ensureSync();
        return proof;
    }
}

