/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.matching;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.semanticweb.elk.matching.ConclusionMatchExpressionRecycleFactory;
import org.semanticweb.elk.matching.ConclusionMatchHierarchyImpl;
import org.semanticweb.elk.matching.ConclusionMatcherVisitor;
import org.semanticweb.elk.matching.InferenceMatchBufferringFactory;
import org.semanticweb.elk.matching.InferenceMatchMapImpl;
import org.semanticweb.elk.matching.InferenceMatchVisitor;
import org.semanticweb.elk.matching.conclusions.ConclusionMatch;
import org.semanticweb.elk.matching.conclusions.ConclusionMatchExpressionFactory;
import org.semanticweb.elk.matching.inferences.InferenceMatch;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.inferences.ElkInferenceOptimizedProducingFactory;
import org.semanticweb.elk.owl.inferences.ElkInferenceProducer;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionComposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubPropertyChain;
import org.semanticweb.elk.reasoner.tracing.TracingProof;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matcher {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(Matcher.class);
    private final Queue<InferenceMatch> toDoInferences_ = new LinkedList<InferenceMatch>();
    private final Queue<ConclusionMatch> toDoConclusions_ = new LinkedList<ConclusionMatch>();
    private final ConclusionMatch.Visitor<Void> conclusionMatcher_;
    private final InferenceMatch.Visitor<Void> inferenceMatcher_;
    private final ConclusionMatchExpressionFactory conclusionMatchFactory_;

    public Matcher(TracingProof inferences, ElkObject.Factory elkObjectFactory, ElkInference.Factory elkInferenceFactory) {
        InferenceMatchBufferringFactory inferenceMatchFactory = new InferenceMatchBufferringFactory(this.toDoInferences_);
        ConclusionMatchHierarchyImpl hierarchy = new ConclusionMatchHierarchyImpl();
        this.conclusionMatchFactory_ = new ConclusionMatchExpressionRecycleFactory(elkObjectFactory, this.toDoConclusions_, hierarchy);
        InferenceMatchMapImpl matchedInferences = new InferenceMatchMapImpl(inferences);
        this.conclusionMatcher_ = new ConclusionMatcherVisitor(inferenceMatchFactory, matchedInferences);
        this.inferenceMatcher_ = new InferenceMatchVisitor(matchedInferences, hierarchy, this.conclusionMatchFactory_, inferenceMatchFactory, elkInferenceFactory);
    }

    public Matcher(TracingProof inferences, ElkObject.Factory elkObjectFactory, ElkInferenceProducer elkInferenceProducer) {
        this(inferences, elkObjectFactory, new ElkInferenceOptimizedProducingFactory(elkInferenceProducer, elkObjectFactory));
    }

    public void trace(SubClassInclusionComposed conclusion, ElkClassExpression subClassMatch, ElkClassExpression superClassMatch) {
        this.conclusionMatchFactory_.getSubClassInclusionComposedMatch1(conclusion, this.conclusionMatchFactory_.getIndexedContextRootClassExpressionMatch(subClassMatch), superClassMatch);
        this.process();
    }

    public void trace(ClassInconsistency conclusion, ElkClassExpression inconsistent) {
        this.conclusionMatchFactory_.getClassInconsistencyMatch1(conclusion, this.conclusionMatchFactory_.getIndexedContextRootClassExpressionMatch(inconsistent));
        this.process();
    }

    public void trace(ClassInconsistency conclusion, ElkIndividual inconsistent) {
        this.conclusionMatchFactory_.getClassInconsistencyMatch1(conclusion, this.conclusionMatchFactory_.getIndexedContextRootClassExpressionMatch((ElkClassExpression)this.conclusionMatchFactory_.getObjectOneOf(Collections.singletonList(inconsistent))));
        this.process();
    }

    public void trace(SubPropertyChain conclusion, ElkSubObjectPropertyExpression subChainMatch, ElkSubObjectPropertyExpression superPropertyMatch) {
        this.conclusionMatchFactory_.getSubPropertyChainMatch2(this.conclusionMatchFactory_.getSubPropertyChainMatch1(conclusion, superPropertyMatch, 0), subChainMatch, 0);
        this.process();
    }

    private void process() {
        while (true) {
            ConclusionMatch conclusion;
            if ((conclusion = this.toDoConclusions_.poll()) != null) {
                LOGGER_.trace("{}: process", (Object)conclusion);
                conclusion.accept(this.conclusionMatcher_);
                continue;
            }
            InferenceMatch inference = this.toDoInferences_.poll();
            if (inference == null) break;
            LOGGER_.trace("{}: process", (Object)inference);
            inference.accept(this.inferenceMatcher_);
        }
    }
}

