/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.matching.root;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticweb.elk.matching.root.IndexedContextRootMatch;
import org.semanticweb.elk.matching.root.IndexedContextRootMatchEquality;
import org.semanticweb.elk.matching.root.IndexedContextRootMatchHash;
import org.semanticweb.elk.matching.root.IndexedContextRootMatchPrinter;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;

abstract class AbstractIndexedContextRootMatch<V extends ElkObject>
implements IndexedContextRootMatch {
    private final V value_;
    private final List<? extends ElkClassExpression> rangeMatches_;
    private int hashCode_ = 0;

    AbstractIndexedContextRootMatch(V value, List<? extends ElkClassExpression> rangeMatches) {
        this.value_ = value;
        this.rangeMatches_ = rangeMatches;
    }

    AbstractIndexedContextRootMatch(V value) {
        this(value, Collections.emptyList());
    }

    public final V getValue() {
        return this.value_;
    }

    @Override
    public final List<? extends ElkClassExpression> getRangeMatches() {
        return this.rangeMatches_;
    }

    @Override
    public final List<? extends ElkClassExpression> getFillerMatches(ElkObject.Factory factory) {
        ArrayList<ElkClassExpression> result = new ArrayList<ElkClassExpression>(this.rangeMatches_.size() + 1);
        result.add(this.getMainFillerMatch(factory));
        result.addAll(this.getRangeMatches());
        return result;
    }

    @Override
    public final ElkClassExpression toElkExpression(ElkObject.Factory factory) {
        ElkClassExpression filler = this.getMainFillerMatch(factory);
        if (this.getRangeMatches().isEmpty()) {
            return filler;
        }
        return factory.getObjectIntersectionOf(this.getFillerMatches(factory));
    }

    public final int hashCode() {
        if (this.hashCode_ == 0) {
            this.hashCode_ = IndexedContextRootMatchHash.hashCode(this);
        }
        return this.hashCode_;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IndexedContextRootMatch) {
            return this.hashCode() == o.hashCode() && this.accept(new IndexedContextRootMatchEquality((IndexedContextRootMatch)o)) != false;
        }
        return false;
    }

    public final String toString() {
        return IndexedContextRootMatchPrinter.toString(this);
    }

    List<? extends ElkClassExpression> extendRangeMatches(ElkClassExpression newRangeMatch) {
        ArrayList<ElkClassExpression> newRangeMatches = new ArrayList<ElkClassExpression>(this.rangeMatches_.size() + 1);
        for (ElkClassExpression elkClassExpression : this.rangeMatches_) {
            if (newRangeMatch.equals(elkClassExpression)) {
                return this.rangeMatches_;
            }
            newRangeMatches.add(elkClassExpression);
        }
        newRangeMatches.add(newRangeMatch);
        return newRangeMatches;
    }
}

