/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.AbstractList;
import java.util.List;
import org.semanticweb.elk.owl.implementation.ElkObjectBaseFactory;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.inferences.ElkInferenceEquality;
import org.semanticweb.elk.owl.inferences.ElkInferenceHash;
import org.semanticweb.elk.owl.inferences.ElkInferencePrinter;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;

public abstract class AbstractElkInference
implements ElkInference {
    private static final ElkObject.Factory ELK_FACTORY_ = new ElkObjectBaseFactory();
    private int hashCode_ = 0;

    static <T> T failGetPremise(int index) {
        throw new IndexOutOfBoundsException("No premise with index: " + index);
    }

    void checkPremiseIndex(int index) {
        if (index < 0 || index >= this.getPremiseCount()) {
            AbstractElkInference.failGetPremise(index);
        }
    }

    public ElkAxiom getConclusion() {
        return this.getConclusion(ELK_FACTORY_);
    }

    public List<? extends ElkAxiom> getPremises() {
        return new AbstractList<ElkAxiom>(){

            @Override
            public ElkAxiom get(int index) {
                return AbstractElkInference.this.getPremise(index, ELK_FACTORY_);
            }

            @Override
            public int size() {
                return AbstractElkInference.this.getPremiseCount();
            }
        };
    }

    public int hashCode() {
        if (this.hashCode_ == 0) {
            this.hashCode_ = this.accept(ElkInferenceHash.getHashVisitor());
        }
        return this.hashCode_;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ElkInference) {
            return this.hashCode() == o.hashCode() && ElkInferenceEquality.equals(this, (ElkInference)o);
        }
        return false;
    }

    public String toString() {
        return ElkInferencePrinter.toString(this);
    }
}

