/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;

public class ElkClassInclusionExistentialRange
extends AbstractElkInference {
    public static final String NAME = "Existential Range Intersection";
    private final ElkObjectPropertyExpression property_;
    private final ElkClassExpression filler_;
    private final List<? extends ElkClassExpression> ranges_;

    ElkClassInclusionExistentialRange(ElkObjectPropertyExpression property, ElkClassExpression filler, List<? extends ElkClassExpression> ranges) {
        if (ranges.size() < 1) {
            throw new IllegalArgumentException("No property ranges");
        }
        this.property_ = property;
        this.filler_ = filler;
        this.ranges_ = ranges;
    }

    ElkClassInclusionExistentialRange(ElkObjectPropertyExpression property, ElkClassExpression filler, ElkClassExpression ... ranges) {
        this(property, filler, Arrays.asList(ranges));
    }

    public ElkObjectPropertyExpression getProperty() {
        return this.property_;
    }

    public ElkClassExpression getFiller() {
        return this.filler_;
    }

    public List<? extends ElkClassExpression> getRanges() {
        return this.ranges_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return this.ranges_.size();
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        this.checkPremiseIndex(index);
        return this.getRangePremise(index, factory);
    }

    public ElkObjectPropertyRangeAxiom getRangePremise(int index, ElkObject.Factory factory) {
        return factory.getObjectPropertyRangeAxiom(this.property_, this.ranges_.get(index));
    }

    public ElkSubClassOfAxiom getConclusion(ElkObject.Factory factory) {
        ArrayList<Object> newFillers = new ArrayList<Object>(this.ranges_.size() + 1);
        newFillers.add(this.filler_);
        newFillers.addAll(this.ranges_);
        return factory.getSubClassOfAxiom((ElkClassExpression)factory.getObjectSomeValuesFrom(this.property_, this.filler_), (ElkClassExpression)factory.getObjectSomeValuesFrom(this.property_, (ElkClassExpression)factory.getObjectIntersectionOf(newFillers)));
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkClassInclusionExistentialRange var1);
    }

    public static interface Factory {
        public ElkClassInclusionExistentialRange getElkClassInclusionExistentialRange(ElkObjectPropertyExpression var1, ElkClassExpression var2, List<? extends ElkClassExpression> var3);

        public ElkClassInclusionExistentialRange getElkClassInclusionExistentialRange(ElkObjectPropertyExpression var1, ElkClassExpression var2, ElkClassExpression ... var3);
    }
}

