/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.Arrays;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;

public class ElkClassInclusionHierarchy
extends AbstractElkInference {
    public static final String NAME = "Class Hierarchy";
    private final List<? extends ElkClassExpression> expressions_;

    ElkClassInclusionHierarchy(List<? extends ElkClassExpression> expressions) {
        this.expressions_ = expressions;
    }

    ElkClassInclusionHierarchy(ElkClassExpression ... expressions) {
        this.expressions_ = Arrays.asList(expressions);
    }

    public List<? extends ElkClassExpression> getExpressions() {
        return this.expressions_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return this.expressions_.size() - 1;
    }

    public ElkSubClassOfAxiom getPremise(int index, ElkObject.Factory factory) {
        this.checkPremiseIndex(index);
        return factory.getSubClassOfAxiom(this.expressions_.get(index), this.expressions_.get(index + 1));
    }

    public ElkSubClassOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubClassOfAxiom(this.expressions_.get(0), this.expressions_.get(this.expressions_.size() - 1));
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkClassInclusionHierarchy var1);
    }

    public static interface Factory {
        public ElkClassInclusionHierarchy getElkClassInclusionHierarchy(ElkClassExpression ... var1);

        public ElkClassInclusionHierarchy getElkClassInclusionHierarchy(List<? extends ElkClassExpression> var1);
    }
}

