/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;

public class ElkClassInclusionObjectIntersectionOfComposition
extends AbstractElkInference {
    public static final String NAME = "Intersection Composition";
    private final ElkClassExpression subExpression_;
    private final List<? extends ElkClassExpression> conjuncts_;

    ElkClassInclusionObjectIntersectionOfComposition(ElkClassExpression subExpression, List<? extends ElkClassExpression> conjuncts) {
        this.subExpression_ = subExpression;
        this.conjuncts_ = conjuncts;
    }

    ElkClassInclusionObjectIntersectionOfComposition(ElkClassExpression subExpression, ElkClassExpression firstConjunct, ElkClassExpression secondConjunct) {
        this.subExpression_ = subExpression;
        ArrayList<? extends ElkClassExpression> conjuncts = new ArrayList<ElkClassExpression>(2);
        this.conjuncts_ = conjuncts;
        conjuncts.add((ElkClassExpression)firstConjunct);
        conjuncts.add((ElkClassExpression)secondConjunct);
    }

    public ElkClassExpression getSubExpression() {
        return this.subExpression_;
    }

    public List<? extends ElkClassExpression> getConjuncts() {
        return this.conjuncts_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return this.conjuncts_.size();
    }

    public ElkSubClassOfAxiom getPremise(int index, ElkObject.Factory factory) {
        this.checkPremiseIndex(index);
        return factory.getSubClassOfAxiom(this.subExpression_, this.conjuncts_.get(index));
    }

    public ElkSubClassOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubClassOfAxiom(this.subExpression_, (ElkClassExpression)factory.getObjectIntersectionOf(this.conjuncts_));
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkClassInclusionObjectIntersectionOfComposition var1);
    }

    public static interface Factory {
        public ElkClassInclusionObjectIntersectionOfComposition getElkClassInclusionObjectIntersectionOfComposition(ElkClassExpression var1, List<? extends ElkClassExpression> var2);

        public ElkClassInclusionObjectIntersectionOfComposition getElkClassInclusionObjectIntersectionOfComposition(ElkClassExpression var1, ElkClassExpression var2, ElkClassExpression var3);
    }
}

