/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;

public class ElkClassInclusionOfDisjointClasses
extends AbstractElkInference {
    public static final String NAME = "Disjoint Classes Translation";
    private final List<? extends ElkClassExpression> expressions_;
    private final int firstPos_;
    private final int secondPos_;

    ElkClassInclusionOfDisjointClasses(List<? extends ElkClassExpression> expressions, int firstPos, int secondPos) {
        if (firstPos == secondPos) {
            throw new IllegalArgumentException("Different positions expected but both = " + firstPos);
        }
        this.expressions_ = expressions;
        this.firstPos_ = firstPos;
        this.secondPos_ = secondPos;
    }

    public List<? extends ElkClassExpression> getExpressions() {
        return this.expressions_;
    }

    public int getFirstPos() {
        return this.firstPos_;
    }

    public int getSecondPos() {
        return this.secondPos_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return 1;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        if (index == 0) {
            return this.getPremise(factory);
        }
        return (ElkAxiom)ElkClassInclusionOfDisjointClasses.failGetPremise(index);
    }

    public ElkDisjointClassesAxiom getPremise(ElkObject.Factory factory) {
        return factory.getDisjointClassesAxiom(this.expressions_);
    }

    public ElkSubClassOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubClassOfAxiom((ElkClassExpression)factory.getObjectIntersectionOf(this.expressions_.get(this.firstPos_), this.expressions_.get(this.secondPos_), new ElkClassExpression[0]), (ElkClassExpression)factory.getOwlNothing());
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkClassInclusionOfDisjointClasses var1);
    }

    public static interface Factory {
        public ElkClassInclusionOfDisjointClasses getElkClassInclusionOfDisjointClasses(List<? extends ElkClassExpression> var1, int var2, int var3);
    }
}

