/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;

public class ElkClassInclusionOfEquivaletClasses
extends AbstractElkInference {
    public static final String NAME = "Equivalent Classes Decomposition";
    private final List<? extends ElkClassExpression> expressions_;
    private final int subPos_;
    private final int superPos_;

    ElkClassInclusionOfEquivaletClasses(List<? extends ElkClassExpression> expressions, int subPos, int superPos) {
        this.expressions_ = expressions;
        this.subPos_ = subPos;
        this.superPos_ = superPos;
    }

    ElkClassInclusionOfEquivaletClasses(ElkClassExpression first, ElkClassExpression second, boolean sameOrder) {
        ArrayList<? extends ElkClassExpression> expressions = new ArrayList<ElkClassExpression>(2);
        expressions.add(first);
        expressions.add(second);
        this.expressions_ = expressions;
        if (sameOrder) {
            this.subPos_ = 0;
            this.superPos_ = 1;
        } else {
            this.subPos_ = 1;
            this.superPos_ = 0;
        }
    }

    public List<? extends ElkClassExpression> getExpressions() {
        return this.expressions_;
    }

    public int getSubPos() {
        return this.subPos_;
    }

    public int getSuperPos() {
        return this.superPos_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return 1;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        if (index == 0) {
            return this.getPremise(factory);
        }
        return (ElkAxiom)ElkClassInclusionOfEquivaletClasses.failGetPremise(index);
    }

    public ElkEquivalentClassesAxiom getPremise(ElkObject.Factory factory) {
        return factory.getEquivalentClassesAxiom(this.expressions_);
    }

    public ElkSubClassOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubClassOfAxiom(this.expressions_.get(this.subPos_), this.expressions_.get(this.superPos_));
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkClassInclusionOfEquivaletClasses var1);
    }

    public static interface Factory {
        public ElkClassInclusionOfEquivaletClasses getElkClassInclusionOfEquivaletClasses(List<? extends ElkClassExpression> var1, int var2, int var3);

        public ElkClassInclusionOfEquivaletClasses getElkClassInclusionOfEquivaletClasses(ElkClassExpression var1, ElkClassExpression var2, boolean var3);
    }
}

